/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.breakpoints;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.debug.BreakpointEventArguments;
import org.eclipse.lsp4j.debug.Source;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.TruffleLineBreakpoint;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class NbBreakpoint {
    private static final Logger LOGGER = Logger.getLogger(NbBreakpoint.class.getName());
    private final DebugAdapterContext context;
    private final Source source;
    private final String sourceURL;
    private int line;
    private int hitCount;
    private String condition;
    private String logMessage;
    private final Map<Object, Object> properties = new HashMap<Object, Object>();
    private Breakpoint breakpoint;

    public NbBreakpoint(Source source, String sourceURL, int line, int hitCount, String condition, String logMessage, DebugAdapterContext context) {
        URI uri;
        this.source = source;
        Integer ref = source.getSourceReference();
        if (ref != null && ref != 0 && (uri = context.getSourceUri(ref)) != null) {
            try {
                sourceURL = uri.toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.sourceURL = sourceURL;
        this.line = line;
        this.hitCount = hitCount;
        this.condition = condition;
        this.logMessage = logMessage;
        this.context = context;
    }

    public Breakpoint getNBBreakpoint() {
        return this.breakpoint;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(int hitCount) {
        if (this.hitCount != hitCount) {
            this.hitCount = hitCount;
            if (hitCount > 0) {
                this.breakpoint.setHitCountFilter(hitCount, Breakpoint.HIT_COUNT_FILTERING_STYLE.GREATER);
            } else {
                this.breakpoint.setHitCountFilter(0, null);
            }
        }
    }

    public CompletableFuture<NbBreakpoint> install() {
        LineBreakpoint breakpoint;
        String sourceURLLower = this.sourceURL.toLowerCase();
        boolean isJava = sourceURLLower.endsWith(".java");
        boolean isScala = sourceURLLower.endsWith(".scala");
        boolean isGroovy = sourceURLLower.endsWith(".groovy");
        if (isScala) {
            Pattern PACKAGE = Pattern.compile("package *([\\p{Alnum}+\\.$]+) *");
            try {
                LineBreakpoint b = LineBreakpoint.create((String)this.sourceURL, (int)this.line);
                FileObject fo = URLMapper.findFileObject((URL)new URL(this.sourceURL));
                for (String code : fo.asLines()) {
                    Matcher match = PACKAGE.matcher(code);
                    if (!match.matches()) continue;
                    String pkg = match.group(1);
                    int slash = this.sourceURL.lastIndexOf("/");
                    int dot = this.sourceURL.indexOf(46, slash + 1);
                    if (dot < 0) break;
                    String filter = pkg + "." + this.sourceURL.substring(slash + 1, dot) + "*";
                    b.setPreferredClassName(filter);
                    break;
                }
                breakpoint = b;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (isJava || isGroovy) {
            LineBreakpoint b = LineBreakpoint.create((String)this.sourceURL, (int)this.line);
            if (this.condition != null && !this.condition.isEmpty()) {
                b.setCondition(this.condition);
            }
            if (this.logMessage != null && !this.logMessage.isEmpty()) {
                String message = NbBreakpoint.lsp2NBLogMessage(this.logMessage);
                b.setPrintText(message);
                b.setSuspend(0);
            }
            breakpoint = b;
        } else {
            URL url;
            try {
                url = new URL(this.sourceURL);
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.CONFIG, "source URL = " + this.sourceURL, ex);
                return null;
            }
            TruffleLineBreakpoint b = new TruffleLineBreakpoint(url, this.line);
            if (this.condition != null && !this.condition.isEmpty()) {
                b.setCondition(this.condition);
            }
            if (this.logMessage != null && !this.logMessage.isEmpty()) {
                String message = NbBreakpoint.lsp2NBLogMessage(this.logMessage);
                b.setPrintText(message);
                b.setSuspend(false);
            }
            breakpoint = b;
        }
        if (this.hitCount > 0) {
            breakpoint.setHitCountFilter(this.hitCount, Breakpoint.HIT_COUNT_FILTERING_STYLE.GREATER);
        }
        breakpoint.addPropertyChangeListener("validity", arg_0 -> this.lambda$install$0((Breakpoint)breakpoint, arg_0));
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        d.addBreakpoint((Breakpoint)breakpoint);
        this.updateValid((Breakpoint)breakpoint, false);
        this.breakpoint = breakpoint;
        return CompletableFuture.completedFuture(this);
    }

    private static final String lsp2NBLogMessage(String message) {
        return message.replaceAll("\\{([^\\}]+)\\}", "{=$1}");
    }

    private void updateValid(Breakpoint breakpoint, boolean sendNotify) {
        String message = breakpoint.getValidityMessage();
        boolean verified = breakpoint.getValidity() == Breakpoint.VALIDITY.VALID;
        this.putProperty("message", message);
        this.putProperty("verified", verified);
        if (verified) {
            this.line = breakpoint instanceof LineBreakpoint ? ((LineBreakpoint)breakpoint).getLineNumber() : ((TruffleLineBreakpoint)breakpoint).getLineNumber();
        }
        if (sendNotify) {
            BreakpointEventArguments bea = new BreakpointEventArguments();
            bea.setBreakpoint(this.convertDebuggerBreakpointToClient());
            bea.setReason("changed");
            this.context.getClient().breakpoint(bea);
        }
    }

    public void putProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        if (!Objects.equals(this.condition, condition)) {
            this.condition = condition;
            if (this.breakpoint instanceof LineBreakpoint) {
                ((LineBreakpoint)this.breakpoint).setCondition(condition);
            } else {
                ((TruffleLineBreakpoint)this.breakpoint).setCondition(condition);
            }
        }
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        if (!Objects.equals(this.logMessage, logMessage)) {
            this.logMessage = logMessage;
            if (this.breakpoint instanceof LineBreakpoint) {
                ((LineBreakpoint)this.breakpoint).setPrintText(logMessage);
            } else {
                ((TruffleLineBreakpoint)this.breakpoint).setPrintText(logMessage);
            }
        }
    }

    org.eclipse.lsp4j.debug.Breakpoint convertDebuggerBreakpointToClient() {
        int id = (Integer)this.getProperty("id");
        boolean verified = this.getProperty("verified") != null && (Boolean)this.getProperty("verified") != false;
        int lineNumber = this.context.getClientLine(this.getLineNumber());
        org.eclipse.lsp4j.debug.Breakpoint bp = new org.eclipse.lsp4j.debug.Breakpoint();
        bp.setId(id);
        bp.setVerified(verified);
        bp.setLine(lineNumber);
        bp.setSource(this.source);
        String message = (String)this.getProperty("message");
        if (message != null) {
            bp.setMessage(message);
        }
        return bp;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.sourceURL);
        hash = 59 * hash + this.line;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NbBreakpoint other = (NbBreakpoint)obj;
        if (this.line != other.line) {
            return false;
        }
        return Objects.equals(this.sourceURL, other.sourceURL);
    }

    public void close() throws Exception {
        if (this.breakpoint != null) {
            DebuggerManager d = DebuggerManager.getDebuggerManager();
            d.removeBreakpoint(this.breakpoint);
        }
    }

    private /* synthetic */ void lambda$install$0(Breakpoint breakpoint, PropertyChangeEvent evt) {
        this.updateValid(breakpoint, true);
    }
}

