/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.CPPThread;

public final class ThreadsCollector {
    private final CPPLiteDebugger debugger;
    private final Map<String, CPPThread> threads = new LinkedHashMap<String, CPPThread>();
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();

    ThreadsCollector(CPPLiteDebugger debugger) {
        this.debugger = debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(String id) {
        CPPThread thread = new CPPThread(this.debugger, id);
        Map<String, CPPThread> map = this.threads;
        synchronized (map) {
            this.threads.put(id, thread);
        }
        for (StateListener listener : this.stateListeners) {
            listener.threadStarted(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String id) {
        CPPThread thread;
        Map<String, CPPThread> map = this.threads;
        synchronized (map) {
            thread = this.threads.remove(id);
            thread.notifyExited();
        }
        for (StateListener listener : this.stateListeners) {
            listener.threadDied(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CPPThread> getAll() {
        Map<String, CPPThread> map = this.threads;
        synchronized (map) {
            return new ArrayList<CPPThread>(this.threads.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPPThread[] getAllArray() {
        Map<String, CPPThread> map = this.threads;
        synchronized (map) {
            return this.threads.values().toArray(new CPPThread[this.threads.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPPThread get(String id) {
        Map<String, CPPThread> map = this.threads;
        synchronized (map) {
            return this.threads.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CPPThread stopped(String id) {
        CPPThread thread;
        if ("all".equals(id)) {
            for (CPPThread thread2 : this.getAll()) {
                thread2.notifyStopped();
            }
            return null;
        }
        Map<String, CPPThread> map = this.threads;
        synchronized (map) {
            thread = this.threads.get(id);
        }
        if (thread != null) {
            thread.notifyStopped();
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopped(String[] ids) {
        CPPThread[] ts = new CPPThread[ids.length];
        Map<String, CPPThread> map = this.threads;
        synchronized (map) {
            for (int i = 0; i < ids.length; ++i) {
                ts[i] = this.threads.get(ids[i]);
            }
        }
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i] == null) continue;
            ts[i].notifyStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CPPThread running(String id) {
        CPPThread thread;
        if ("all".equals(id)) {
            for (CPPThread thread2 : this.getAll()) {
                thread2.notifyRunning();
            }
            return null;
        }
        Map<String, CPPThread> map = this.threads;
        synchronized (map) {
            thread = this.threads.get(id);
        }
        if (thread != null) {
            thread.notifyRunning();
        }
        return thread;
    }

    public void addStateListener(StateListener sl) {
        this.stateListeners.add(sl);
    }

    public void removeStateListener(StateListener sl) {
        this.stateListeners.remove(sl);
    }

    public static interface StateListener
    extends EventListener {
        public void threadStarted(CPPThread var1);

        public void threadDied(CPPThread var1);
    }
}

