/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.lsp.client.debugger.breakpoints.DAPLineBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{DAPLineBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        FileObject fo;
        if (!typeID.equals(DAPLineBreakpoint.class.getName())) {
            return null;
        }
        int lineNumber = properties.getInt("lineNumber", 0) + 1;
        String url = properties.getString("url", null);
        try {
            fo = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException ex) {
            fo = null;
        }
        if (fo == null) {
            return null;
        }
        DAPLineBreakpoint b = DAPLineBreakpoint.create(fo, lineNumber);
        b.setGroupName(properties.getString("groupName", ""));
        int hitCountFilter = properties.getInt("hitCountFilter", 0);
        Breakpoint.HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle = hitCountFilter > 0 ? Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[properties.getInt("hitCountFilter_style", 0)] : null;
        b.setHitCountFilter(hitCountFilter, hitCountFilteringStyle);
        String condition = properties.getString("condition", null);
        if (condition != null && !condition.isEmpty()) {
            b.setCondition(condition);
        }
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        return b;
    }

    public void write(Object object, Properties properties) {
        DAPLineBreakpoint b = (DAPLineBreakpoint)((Object)object);
        FileObject fo = b.getFileObject();
        properties.setString("url", fo.toURL().toString());
        properties.setInt("lineNumber", b.getLineNumber() - 1);
        properties.setString("groupName", b.getGroupName());
        properties.setBoolean("enabled", b.isEnabled());
        properties.setInt("hitCountFilter", b.getHitCountFilter());
        Breakpoint.HIT_COUNT_FILTERING_STYLE style = b.getHitCountFilteringStyle();
        properties.setInt("hitCountFilter_style", style != null ? style.ordinal() : 0);
        String condition = b.getCondition();
        if (condition == null) {
            condition = "";
        }
        properties.setString("condition", condition);
    }
}

