/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDatabaseKeyHistoryEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="kmsKeyVersionId")
    private final String kmsKeyVersionId;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="timeActivated")
    private final Date timeActivated;

    @Deprecated
    @ConstructorProperties(value={"id", "kmsKeyVersionId", "vaultId", "timeActivated"})
    public AutonomousDatabaseKeyHistoryEntry(String id, String kmsKeyVersionId, String vaultId, Date timeActivated) {
        this.id = id;
        this.kmsKeyVersionId = kmsKeyVersionId;
        this.vaultId = vaultId;
        this.timeActivated = timeActivated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getKmsKeyVersionId() {
        return this.kmsKeyVersionId;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public Date getTimeActivated() {
        return this.timeActivated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDatabaseKeyHistoryEntry(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", kmsKeyVersionId=").append(String.valueOf(this.kmsKeyVersionId));
        sb.append(", vaultId=").append(String.valueOf(this.vaultId));
        sb.append(", timeActivated=").append(String.valueOf(this.timeActivated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDatabaseKeyHistoryEntry)) {
            return false;
        }
        AutonomousDatabaseKeyHistoryEntry other = (AutonomousDatabaseKeyHistoryEntry)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.kmsKeyVersionId, other.kmsKeyVersionId) && Objects.equals(this.vaultId, other.vaultId) && Objects.equals(this.timeActivated, other.timeActivated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.kmsKeyVersionId == null ? 43 : this.kmsKeyVersionId.hashCode());
        result = result * 59 + (this.vaultId == null ? 43 : this.vaultId.hashCode());
        result = result * 59 + (this.timeActivated == null ? 43 : this.timeActivated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="kmsKeyVersionId")
        private String kmsKeyVersionId;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="timeActivated")
        private Date timeActivated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder kmsKeyVersionId(String kmsKeyVersionId) {
            this.kmsKeyVersionId = kmsKeyVersionId;
            this.__explicitlySet__.add("kmsKeyVersionId");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder timeActivated(Date timeActivated) {
            this.timeActivated = timeActivated;
            this.__explicitlySet__.add("timeActivated");
            return this;
        }

        public AutonomousDatabaseKeyHistoryEntry build() {
            AutonomousDatabaseKeyHistoryEntry model = new AutonomousDatabaseKeyHistoryEntry(this.id, this.kmsKeyVersionId, this.vaultId, this.timeActivated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDatabaseKeyHistoryEntry model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyVersionId")) {
                this.kmsKeyVersionId(model.getKmsKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("vaultId")) {
                this.vaultId(model.getVaultId());
            }
            if (model.wasPropertyExplicitlySet("timeActivated")) {
                this.timeActivated(model.getTimeActivated());
            }
            return this;
        }
    }
}

