/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.library;

import java.awt.Color;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.persistence.wizard.library.J2SEVolumeCustomizer;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PersistenceLibraryPanel
extends JPanel {
    public static final String IS_VALID = "PersistenceLibraryPanel_isValid";
    private LibraryImplementation libImpl;
    private Color nbErrorForeground;
    private Color nbWarningForeground;
    static final String ERROR_GIF = "org/netbeans/modules/dialogs/error.gif";
    static final String WARNING_GIF = "org/netbeans/modules/dialogs/warning.gif";
    private JLabel errorMessage;
    private JLabel jLabel1;
    private JTextField libraryNameTextField;
    private JTabbedPane tabbedPane;

    public PersistenceLibraryPanel(LibraryImplementation libImpl) {
        this.initComponents();
        this.libImpl = libImpl;
        J2SEVolumeCustomizer classPathCustomizer = new J2SEVolumeCustomizer("classpath");
        classPathCustomizer.setObject(libImpl);
        this.tabbedPane.add(classPathCustomizer);
        J2SEVolumeCustomizer srcCustomizer = new J2SEVolumeCustomizer("src");
        srcCustomizer.setObject(libImpl);
        this.tabbedPane.add(srcCustomizer);
        J2SEVolumeCustomizer javadocCustomizer = new J2SEVolumeCustomizer("javadoc");
        javadocCustomizer.setObject(libImpl);
        this.tabbedPane.add(javadocCustomizer);
        this.tabbedPane.setMnemonicAt(0, NbBundle.getMessage(PersistenceLibraryPanel.class, (String)"MNE_ClasspathTab").charAt(0));
        this.tabbedPane.setMnemonicAt(1, NbBundle.getMessage(PersistenceLibraryPanel.class, (String)"MNE_SourcesTab").charAt(0));
        this.tabbedPane.setMnemonicAt(2, NbBundle.getMessage(PersistenceLibraryPanel.class, (String)"MNE_JavadocTab").charAt(0));
        this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
        if (this.nbErrorForeground == null) {
            this.nbErrorForeground = new Color(255, 0, 0);
        }
        this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
        if (this.nbWarningForeground == null) {
            this.nbWarningForeground = new Color(51, 51, 51);
        }
        LibraryManager lm = LibraryManager.getDefault();
        String libraryName = "PersistenceLibrary";
        int index = 1;
        while (lm.getLibrary(libraryName + index) != null) {
            ++index;
        }
        this.libraryNameTextField.setText(libraryName + index);
        this.libraryNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PersistenceLibraryPanel.this.checkValidity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PersistenceLibraryPanel.this.checkValidity();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PersistenceLibraryPanel.this.checkValidity();
            }
        });
        libImpl.addPropertyChangeListener(evt -> this.checkValidity());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.libraryNameTextField.requestFocus();
        this.libraryNameTextField.selectAll();
    }

    public void apply() {
        this.libImpl.setName(this.libraryNameTextField.getText().trim());
        PersistenceLibrarySupport.getDefault().addLibrary(this.libImpl);
    }

    void checkValidity() {
        String libraryName = this.libraryNameTextField.getText();
        if (libraryName.trim().isEmpty()) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceLibrarySupport.class, (String)"ERR_EmptyName"), false);
            this.firePropertyChange(IS_VALID, true, false);
        } else if (LibraryManager.getDefault().getLibrary(libraryName) != null) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceLibrarySupport.class, (String)"ERR_LibraryExists"), false);
            this.firePropertyChange(IS_VALID, true, false);
        } else if (!this.containsEntityManager()) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceLibrarySupport.class, (String)"ERR_NoEntityManager"), false);
            this.firePropertyChange(IS_VALID, true, false);
        } else if (!this.containsPersistenceProvider()) {
            this.setErrorMessage(NbBundle.getMessage(PersistenceLibrarySupport.class, (String)"ERR_NoPersistenceProvider"), false);
            this.firePropertyChange(IS_VALID, true, false);
        } else {
            this.setErrorMessage("", true);
            this.firePropertyChange(IS_VALID, false, true);
        }
    }

    private void setErrorMessage(String msg, Boolean canContinue) {
        this.errorMessage.setForeground(this.nbErrorForeground);
        if (msg != null && msg.trim().length() > 0 && canContinue != null) {
            if (canContinue.booleanValue()) {
                this.errorMessage.setIcon(ImageUtilities.loadImageIcon((String)WARNING_GIF, (boolean)false));
                this.errorMessage.setForeground(this.nbWarningForeground);
            } else {
                this.errorMessage.setIcon(ImageUtilities.loadImageIcon((String)ERROR_GIF, (boolean)false));
            }
            this.errorMessage.setToolTipText(msg);
        } else {
            this.errorMessage.setIcon(null);
            this.errorMessage.setToolTipText(null);
        }
        this.errorMessage.setText(msg);
    }

    private boolean containsEntityManager() {
        return PersistenceLibrarySupport.containsClass(this.libImpl, "javax.persistence.EntityManager") || PersistenceLibrarySupport.containsClass(this.libImpl, "jakarta.persistence.EntityManager");
    }

    private boolean containsPersistenceProvider() {
        return PersistenceLibrarySupport.containsService(this.libImpl, "javax.persistence.spi.PersistenceProvider") || PersistenceLibrarySupport.containsService(this.libImpl, "jakarta.persistence.spi.PersistenceProvider");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.libraryNameTextField = new JTextField();
        this.tabbedPane = new JTabbedPane();
        this.errorMessage = new JLabel();
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/library/Bundle").getString("MNE_LibraryName").charAt(0));
        this.jLabel1.setLabelFor(this.libraryNameTextField);
        this.jLabel1.setText(NbBundle.getMessage(PersistenceLibraryPanel.class, (String)"LBL_LibraryName"));
        this.errorMessage.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbedPane, GroupLayout.Alignment.LEADING, -1, 417, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.libraryNameTextField, -1, 305, Short.MAX_VALUE)).addComponent(this.errorMessage, GroupLayout.Alignment.LEADING, -1, 417, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.libraryNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabbedPane, -1, 230, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorMessage).addContainerGap()));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/library/Bundle");
        this.libraryNameTextField.getAccessibleContext().setAccessibleName(bundle.getString("LBL_LibraryName"));
        this.libraryNameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_LibraryName"));
    }
}

