/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.db;

import org.netbeans.modules.glassfish.tooling.utils.StringPrefixTree;

public class JDBCConnectionPool {
    private String user = null;
    private String password = null;
    private String driverClass = null;
    private String url = null;
    private String databaseName = null;
    private String serverName = null;
    private int port = -1;

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getPort() {
        return this.port;
    }

    public boolean setProperty(PropertyType type, String value) {
        switch (type) {
            case USER: {
                this.user = value;
                return true;
            }
            case PASSWORD: {
                this.password = value;
                return true;
            }
            case DRIVER_CLASS: {
                this.driverClass = value;
                return true;
            }
            case URL: {
                this.url = value;
                return true;
            }
            case DATABASE_NAME: {
                this.databaseName = value;
                return true;
            }
            case SERVER_NAME: {
                this.serverName = value;
                return true;
            }
            case PORT_NUMBER: {
                try {
                    this.port = Integer.parseInt(value);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    this.port = -1;
                    return false;
                }
            }
        }
        return false;
    }

    public static enum PropertyType {
        UNKNOWN,
        USER,
        PASSWORD,
        DRIVER_CLASS,
        URL,
        DATABASE_NAME,
        SERVER_NAME,
        PORT_NUMBER;

        private static final String UNKNOWN_STR = "UNKNOWN";
        private static final String USER_STR = "User";
        private static final String PASSWORD_STR = "Password";
        private static final String DRIVER_CLASS_STR = "DriverClass";
        private static final String URL_STR = "URL";
        private static final String DATABASE_NAME_STR = "DatabaseName";
        private static final String SERVER_NAME_STR = "ServerName";
        private static final String PORT_NUMBER_STR = "PortNumber";
        private static final StringPrefixTree<PropertyType> stringValues;

        public static PropertyType toValue(String name) {
            if (name != null) {
                PropertyType type = (PropertyType)((Object)stringValues.match((CharSequence)name.toLowerCase()));
                return type != null ? type : UNKNOWN;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case UNKNOWN: {
                    return UNKNOWN_STR;
                }
                case USER: {
                    return USER_STR;
                }
                case PASSWORD: {
                    return PASSWORD_STR;
                }
                case DRIVER_CLASS: {
                    return DRIVER_CLASS_STR;
                }
                case URL: {
                    return URL_STR;
                }
                case DATABASE_NAME: {
                    return DATABASE_NAME_STR;
                }
                case SERVER_NAME: {
                    return SERVER_NAME_STR;
                }
                case PORT_NUMBER: {
                    return PORT_NUMBER_STR;
                }
            }
            throw new IllegalStateException("Invalid ResourceType value");
        }

        static {
            stringValues = new StringPrefixTree(false);
            stringValues.add(USER.toString(), (Object)USER);
            stringValues.add(PASSWORD.toString(), (Object)PASSWORD);
            stringValues.add(DRIVER_CLASS.toString(), (Object)DRIVER_CLASS);
            stringValues.add(URL.toString(), (Object)URL);
            stringValues.add(DATABASE_NAME.toString(), (Object)DATABASE_NAME);
            stringValues.add(SERVER_NAME.toString(), (Object)SERVER_NAME);
            stringValues.add(PORT_NUMBER.toString(), (Object)PORT_NUMBER);
        }
    }
}

