/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jsui.vars.tooltip;

import java.beans.PropertyChangeListener;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.debugger.jpda.js.vars.DebuggerSupport;
import org.netbeans.modules.debugger.jpda.js.vars.JSVariable;
import org.netbeans.modules.javascript2.debug.ui.tooltip.AbstractJSToolTipAnnotation;
import org.openide.util.Pair;

public final class ToolTipAnnotation
extends AbstractJSToolTipAnnotation {
    protected void handleToolTipClose(DebuggerEngine engine, ToolTipSupport tts) {
        JPDADebugger d = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return;
        }
        PropertyChangeListener l = evt -> {
            int state = (Integer)evt.getNewValue();
            if (4 == state || 2 == state) {
                SwingUtilities.invokeLater(() -> tts.setToolTipVisible(false));
            }
        };
        d.addPropertyChangeListener("state", l);
        tts.addPropertyChangeListener(pl -> {
            if ("status".equals(pl.getPropertyName()) && !tts.isToolTipVisible()) {
                d.removePropertyChangeListener("state", l);
            }
        });
    }

    protected Pair<String, Object> evaluate(String expression, DebuggerEngine engine) throws CancellationException {
        String toolTipText;
        Session session = (Session)engine.lookupFirst(null, Session.class);
        if (engine != session.getEngineForLanguage("JS")) {
            return null;
        }
        JPDADebugger d = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return null;
        }
        CallStackFrame frame = d.getCurrentCallStackFrame();
        if (frame == null) {
            return null;
        }
        JSVariable jsresult = null;
        try {
            Variable result = DebuggerSupport.evaluate((JPDADebugger)d, (CallStackFrame)frame, (String)expression);
            if (result == null) {
                throw new CancellationException();
            }
            if (result instanceof ObjectVariable) {
                jsresult = JSVariable.createIfScriptObject((JPDADebugger)d, (ObjectVariable)((ObjectVariable)result), (String)expression);
            }
            toolTipText = jsresult != null ? expression + " = " + jsresult.getValue() : expression + " = " + DebuggerSupport.getVarValue((JPDADebugger)d, (Variable)result);
        }
        catch (InvalidExpressionException ex) {
            toolTipText = expression + " = >" + ex.getMessage() + "<";
        }
        return Pair.of((Object)toolTipText, (Object)jsresult);
    }
}

