/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal;

import com.oracle.bmc.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class StreamHelper {
    private static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out) throws IOException {
        try {
            byte[] buffer = new byte[8192];
            long bytesWritten = 0L;
            int bytesRead = 0;
            while (-1 != (bytesRead = in.read(buffer))) {
                out.write(buffer, 0, bytesRead);
                bytesWritten += (long)bytesRead;
            }
            long l = bytesWritten;
            return l;
        }
        finally {
            StreamUtils.closeQuietly((InputStream)in);
        }
    }

    public static String base64EncodeMd5Digest(byte[] buffer) {
        return StreamHelper.toBase64(StreamHelper.md5(buffer));
    }

    public static DigestOutputStream createMd5MessageOutputStream(OutputStream stream) {
        return new DigestOutputStream(stream, StreamHelper.getMd5MessageDigest());
    }

    public static String base64Encode(MessageDigest messageDigest) {
        return StreamHelper.toBase64(messageDigest.digest());
    }

    private static String toBase64(byte[] bytes) {
        return new String(Base64.getEncoder().encode(bytes));
    }

    private static byte[] md5(byte[] bytes) {
        MessageDigest md = StreamHelper.getMd5MessageDigest();
        md.update(bytes);
        return md.digest();
    }

    private static MessageDigest getMd5MessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not get MD5 digest", e);
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }
    }
}

