/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.newproject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.gradle.spi.newproject.BaseGradleWizardIterator;
import org.netbeans.modules.gradle.spi.newproject.TemplateOperation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class GradleProjectFromTemplateHandler
extends CreateFromTemplateHandler {
    private static BiFunction<BaseGradleWizardIterator, Map<String, Object>, TemplateOperation> COLLECT_OPERATIONS;

    public static void register(BiFunction<BaseGradleWizardIterator, Map<String, Object>, TemplateOperation> c) {
        if (COLLECT_OPERATIONS != null) {
            throw new IllegalStateException();
        }
        COLLECT_OPERATIONS = c;
    }

    protected boolean accept(CreateDescriptor desc) {
        return GradleProjectFromTemplateHandler.extractGradleIterator(desc) != null;
    }

    protected List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
        BaseGradleWizardIterator p = GradleProjectFromTemplateHandler.extractGradleIterator(desc);
        HashMap<String, Object> copyParams = new HashMap<String, Object>(desc.getParameters());
        GradleProjectFromTemplateHandler.fillIfMissing(copyParams, "projdir", FileUtil.toFile((FileObject)desc.getTarget()));
        GradleProjectFromTemplateHandler.fillIfMissing(copyParams, "template", desc.getTemplate());
        TemplateOperation ops = COLLECT_OPERATIONS.apply(p, copyParams);
        ops.run();
        return GradleProjectFromTemplateHandler.sortByParentship(ops.getImportantFiles());
    }

    private static List<FileObject> sortByParentship(Collection<FileObject> fo) {
        ArrayList<FileObject> files = new ArrayList<FileObject>(fo);
        files.sort((a, b) -> {
            if (a.equals(b)) {
                return 0;
            }
            if (FileUtil.isParentOf((FileObject)a, (FileObject)b)) {
                return -1;
            }
            if (FileUtil.isParentOf((FileObject)b, (FileObject)a)) {
                return 1;
            }
            return 0;
        });
        return files;
    }

    private static BaseGradleWizardIterator extractGradleIterator(CreateDescriptor desc) {
        Object it = desc.getTemplate().getAttribute("instantiatingIterator");
        return it instanceof BaseGradleWizardIterator ? (BaseGradleWizardIterator)it : null;
    }

    private static void fillIfMissing(Map<String, Object> map, String prop, Object obj) {
        if (!map.containsKey(prop) && obj != null) {
            map.put(prop, obj);
        }
    }
}

