/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner.actions;

import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;
import org.openide.util.NbBundle;

public class AddGapsAction
extends AbstractGridAction {
    private String name = NbBundle.getMessage(AddGapsAction.class, (String)"AddGapsAction_Name");

    @Override
    public Object getValue(String key) {
        return key.equals("Name") ? this.name : null;
    }

    @Override
    public boolean isEnabled(DesignerContext context) {
        return !context.getGridInfo().hasGaps();
    }

    @Override
    public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
        GridInfoProvider gridInfo = gridManager.getGridInfo();
        int[] originalColumnBounds = gridInfo.getColumnBounds();
        int[] originalRowBounds = gridInfo.getRowBounds();
        int columnCount = Math.max(2 * originalColumnBounds.length - 3, 1);
        int rowCount = Math.max(2 * originalRowBounds.length - 3, 1);
        GridUtils.removePaddingComponents(gridManager);
        int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
        int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
        gridManager.addGaps(gapWidth, gapHeight);
        GridUtils.addPaddingComponents(gridManager, columnCount, rowCount);
        GridUtils.revalidateGrid(gridManager);
        int[] newColumnBounds = gridInfo.getColumnBounds();
        int[] newRowBounds = gridInfo.getRowBounds();
        int[] columnBounds = new int[newColumnBounds.length];
        columnBounds[0] = originalColumnBounds[0];
        for (int i = 1; i < originalColumnBounds.length - 1; ++i) {
            int n = originalColumnBounds[i];
            columnBounds[2 * i - 1] = n;
            columnBounds[2 * i] = n;
        }
        columnBounds[newColumnBounds.length - 1] = originalColumnBounds[originalColumnBounds.length - 1];
        int[] rowBounds = new int[newRowBounds.length];
        rowBounds[0] = originalRowBounds[0];
        for (int j = 1; j < originalRowBounds.length - 1; ++j) {
            int n = originalRowBounds[j];
            rowBounds[2 * j - 1] = n;
            rowBounds[2 * j] = n;
        }
        rowBounds[newRowBounds.length - 1] = originalRowBounds[originalRowBounds.length - 1];
        return new GridBoundsChange(columnBounds, rowBounds, newColumnBounds, newRowBounds);
    }
}

