/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.ModelReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.Project;
import org.netbeans.modules.fish.payara.micro.plugin.TemplateUtil;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Activation;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.DependencyContainer;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.IdPOMComponent;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.model.pom.RepositoryPolicy;
import org.netbeans.modules.maven.model.pom.Resource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class POMManager {
    private Project project;
    private FileObject pomFileObject;
    private POMModel pomModel;
    private NbMavenProject mavenProject;
    private Model sourceModel;
    private List<ModelOperation<POMModel>> operations;
    private static final RequestProcessor RP = new RequestProcessor(POMManager.class);
    private BiFunction<Xpp3Dom, POMExtensibilityElement, Boolean> extensionOverrideFilter;

    public POMManager(Project project) {
        this(project, false);
    }

    public POMManager(Project project, boolean readonly) {
        this.project = project;
        this.mavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        this.pomFileObject = FileUtil.toFileObject((File)this.mavenProject.getMavenProject().getFile());
        this.pomModel = (POMModel)POMModelFactory.getDefault().createFreshModel(Utilities.createModelSource((FileObject)this.pomFileObject));
        this.operations = new ArrayList<ModelOperation<POMModel>>();
        if (!readonly) {
            this.pomModel.startTransaction();
        }
    }

    public POMManager(String inputResource, Project project) {
        this(project, false);
        try {
            ModelReader reader = (ModelReader)EmbedderFactory.getProjectEmbedder().lookupComponent(ModelReader.class);
            this.sourceModel = reader.read(TemplateUtil.loadResource(inputResource), Collections.singletonMap("org.apache.maven.model.io.isStrict", false));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public POMManager(Reader inputResource, Project project) {
        this(project, false);
        try {
            ModelReader reader = (ModelReader)EmbedderFactory.getProjectEmbedder().lookupComponent(ModelReader.class);
            this.sourceModel = reader.read(inputResource, Collections.singletonMap("org.apache.maven.model.io.isStrict", false));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void fixDistributionProperties() {
        org.netbeans.modules.maven.model.pom.Project pomProject = this.getPOMProject();
        if (pomProject.getGroupId() != null) {
            pomProject.setGroupId(pomProject.getGroupId().toLowerCase());
        }
        if (pomProject.getArtifactId() != null) {
            pomProject.setArtifactId(pomProject.getArtifactId().toLowerCase());
        }
        if (pomProject.getVersion() != null) {
            pomProject.setVersion(pomProject.getVersion().toLowerCase());
        }
    }

    private org.netbeans.modules.maven.model.pom.Project getPOMProject() {
        return this.pomModel.getProject();
    }

    public String getGroupId() {
        return this.getPOMProject().getGroupId();
    }

    public String getArtifactId() {
        return this.getPOMProject().getArtifactId();
    }

    public String getVersion() {
        return this.getPOMProject().getVersion();
    }

    public void addProperties(Properties prop) {
        this.addProperties(null, prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(String profile, Properties prop) {
        boolean tx = this.pomModel.isIntransaction();
        try {
            if (!tx) {
                this.pomModel.startTransaction();
            }
            org.netbeans.modules.maven.model.pom.Project pomProject = this.getPOMProject();
            if (profile != null) {
                Profile targetProfile = pomProject.findProfileById(profile);
                if (targetProfile == null) {
                    throw new IllegalArgumentException(String.format("Profile[%s] not exist", profile));
                }
                if (targetProfile.getProperties() == null) {
                    targetProfile.setProperties(this.pomModel.getFactory().createProperties());
                }
                this.registerProperties(prop, targetProfile.getProperties());
            } else {
                this.registerProperties(prop, pomProject.getProperties());
            }
        }
        finally {
            if (!tx) {
                this.pomModel.endTransaction();
            }
        }
    }

    public void setExtensionOverrideFilter(BiFunction<Xpp3Dom, POMExtensibilityElement, Boolean> extensionOverrideFilter) {
        this.extensionOverrideFilter = extensionOverrideFilter;
    }

    public static boolean isMavenProject(Project project) {
        return project.getLookup().lookup(NbMavenProject.class) != null;
    }

    public void reload() {
        POMManager.reload(this.project);
    }

    public static void reload(Project project) {
        NbMavenProject mavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        try {
            FileObject pomFileObject = FileUtil.toFileObject((File)mavenProject.getMavenProject().getFile());
            POMModel model = POMModelFactory.getDefault().getModel(Utilities.createModelSource((FileObject)pomFileObject));
            Utilities.saveChanges((AbstractDocumentModel)model);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        RP.post(() -> mavenProject.triggerDependencyDownload());
        SwingUtilities.invokeLater(() -> NbMavenProject.fireMavenProjectReload((Project)project));
    }

    private void execute() {
        if (this.sourceModel != null) {
            org.netbeans.modules.maven.model.pom.Project pomProject = this.getPOMProject();
            if (pomProject.getProperties() == null) {
                pomProject.setProperties(this.pomModel.getFactory().createProperties());
            }
            this.registerProperties(this.sourceModel.getProperties(), pomProject.getProperties());
            pomProject.setDependencyManagement(this.registerDependencyManagement(this.sourceModel.getDependencyManagement(), pomProject.getDependencyManagement()));
            this.registerDependency(this.sourceModel.getDependencies(), (DependencyContainer)pomProject);
            this.registerRepository();
            this.registerBuild();
            this.registerProfile();
        }
    }

    private org.netbeans.modules.maven.model.pom.Properties registerProperties(Properties source, org.netbeans.modules.maven.model.pom.Properties target) {
        if (source != null && !source.isEmpty()) {
            if (target == null) {
                target = this.pomModel.getFactory().createProperties();
            }
            for (String sourceKey : source.stringPropertyNames()) {
                String sourceValue = source.getProperty(sourceKey);
                target.setProperty(sourceKey, sourceValue);
            }
        }
        return target;
    }

    private void registerBuild() {
        if (this.sourceModel.getBuild() != null) {
            this.registerBuildBase((BuildBase)this.sourceModel.getBuild(), (org.netbeans.modules.maven.model.pom.BuildBase)this.getPOMProject().getBuild());
        }
    }

    private org.netbeans.modules.maven.model.pom.BuildBase registerBuildBase(BuildBase sourceBuild, org.netbeans.modules.maven.model.pom.BuildBase targetBuild) {
        if (sourceBuild == null) {
            return targetBuild;
        }
        if (targetBuild == null) {
            targetBuild = this.pomModel.getFactory().createBuild();
        }
        if (sourceBuild.getFinalName() != null) {
            targetBuild.setFinalName(sourceBuild.getFinalName());
        }
        if (sourceBuild.getResources() != null && !sourceBuild.getResources().isEmpty()) {
            for (org.apache.maven.model.Resource sourceResource : sourceBuild.getResources()) {
                Resource targetResource = this.pomModel.getFactory().createResource();
                targetResource.setFiltering(Boolean.valueOf(Boolean.parseBoolean(sourceResource.getFiltering())));
                targetResource.setDirectory(sourceResource.getDirectory());
                targetBuild.addResource(targetResource);
            }
        }
        if (sourceBuild.getPlugins() != null && !sourceBuild.getPlugins().isEmpty()) {
            for (Plugin sourcePlugin : sourceBuild.getPlugins()) {
                org.netbeans.modules.maven.model.pom.Plugin targetPlugin = targetBuild.findPluginById(sourcePlugin.getGroupId(), sourcePlugin.getArtifactId());
                if (targetPlugin == null) {
                    targetPlugin = this.pomModel.getFactory().createPlugin();
                    targetPlugin.setGroupId(sourcePlugin.getGroupId());
                    targetPlugin.setArtifactId(sourcePlugin.getArtifactId());
                    targetBuild.addPlugin(targetPlugin);
                }
                if (sourcePlugin.getExtensions() != null) {
                    targetPlugin.setExtensions(Boolean.TRUE);
                }
                this.registerDependency(sourcePlugin.getDependencies(), (DependencyContainer)targetPlugin);
                targetPlugin.setConfiguration(this.registerConfiguration(sourcePlugin.getConfiguration(), targetPlugin.getConfiguration()));
                if (sourcePlugin.getExecutions() != null && !sourcePlugin.getExecutions().isEmpty()) {
                    for (PluginExecution sourceExecution : sourcePlugin.getExecutions()) {
                        org.netbeans.modules.maven.model.pom.PluginExecution targetExecution = targetPlugin.findExecutionById(sourceExecution.getId());
                        if (targetExecution == null) {
                            targetExecution = this.pomModel.getFactory().createExecution();
                            targetExecution.setId(sourceExecution.getId());
                            sourceExecution.getGoals().forEach(arg_0 -> ((org.netbeans.modules.maven.model.pom.PluginExecution)targetExecution).addGoal(arg_0));
                            targetPlugin.addExecution(targetExecution);
                        }
                        targetExecution.setPhase(sourceExecution.getPhase());
                        targetExecution.setConfiguration(this.registerConfiguration(sourceExecution.getConfiguration(), targetExecution.getConfiguration()));
                    }
                }
                targetPlugin.setVersion(sourcePlugin.getVersion());
            }
        }
        return targetBuild;
    }

    private Configuration registerConfiguration(Object sourceConfig, Configuration targetConfig) {
        if (sourceConfig != null) {
            Xpp3Dom parentDOM = (Xpp3Dom)sourceConfig;
            if (targetConfig == null) {
                targetConfig = this.pomModel.getFactory().createConfiguration();
            }
            this.loadDom(parentDOM, (POMComponent)targetConfig);
        }
        return targetConfig;
    }

    private void loadDom(Xpp3Dom source, POMComponent target) {
        for (Xpp3Dom childDOM : source.getChildren()) {
            POMExtensibilityElement element;
            if (childDOM.getValue() != null) {
                if (target instanceof Configuration) {
                    ((Configuration)target).setSimpleParameter(childDOM.getName(), childDOM.getValue());
                    continue;
                }
                if (target instanceof POMExtensibilityElement) {
                    Optional<POMComponent> targetComponentOptioal = ((POMExtensibilityElement)target).getChildren().stream().filter(targetElement -> {
                        String nodeName = targetElement.getPeer().getNodeName();
                        nodeName = nodeName.substring(nodeName.lastIndexOf(58) + 1);
                        String nodeValue = targetElement.getPeer().getChildNodes().item(0).getNodeValue();
                        return nodeName != null && nodeName.equals(childDOM.getName()) && nodeValue != null && nodeValue.equals(childDOM.getValue());
                    }).findAny();
                    if (targetComponentOptioal.isPresent()) continue;
                    element = this.pomModel.getFactory().createPOMExtensibilityElement(new QName(childDOM.getName()));
                    element.setElementText(childDOM.getValue());
                    target.addExtensibilityElement(element);
                    continue;
                }
                target.setChildElementText("propertyName", childDOM.getValue(), new QName(childDOM.getName()));
                continue;
            }
            Optional<POMExtensibilityElement> targetElementOptioal = target.getExtensibilityElements().stream().filter(targetElement -> targetElement.getQName().getLocalPart().equals(childDOM.getName())).filter(targetElement -> this.extensionOverrideFilter == null || this.extensionOverrideFilter.apply(childDOM, (POMExtensibilityElement)targetElement) != false).findAny();
            if (targetElementOptioal.isPresent()) {
                element = targetElementOptioal.get();
            } else {
                element = this.pomModel.getFactory().createPOMExtensibilityElement(new QName(childDOM.getName()));
                target.addExtensibilityElement(element);
            }
            this.loadDom(childDOM, (POMComponent)element);
        }
    }

    private void registerProfile() {
        if (!this.sourceModel.getProfiles().isEmpty()) {
            org.netbeans.modules.maven.model.pom.Project pomProject = this.getPOMProject();
            for (org.apache.maven.model.Profile sourceProfile : this.sourceModel.getProfiles()) {
                Profile targetProfile = pomProject.findProfileById(sourceProfile.getId());
                if (targetProfile == null) {
                    targetProfile = this.pomModel.getFactory().createProfile();
                    pomProject.addProfile(targetProfile);
                    targetProfile.setId(sourceProfile.getId());
                    targetProfile.setProperties(this.registerProperties(sourceProfile.getProperties(), targetProfile.getProperties()));
                    if (sourceProfile.getActivation() != null) {
                        Activation activation = this.pomModel.getFactory().createActivation();
                        targetProfile.setActivation(activation);
                        if (sourceProfile.getActivation().getProperty() != null) {
                            ActivationProperty sourceProperty = sourceProfile.getActivation().getProperty();
                            org.netbeans.modules.maven.model.pom.ActivationProperty targetProperty = this.pomModel.getFactory().createActivationProperty();
                            activation.setActivationProperty(targetProperty);
                            targetProperty.setName(sourceProperty.getName());
                            targetProperty.setValue(sourceProperty.getValue());
                        } else {
                            activation.setChildElementText("activeByDefault", Boolean.toString(sourceProfile.getActivation().isActiveByDefault()), new QName("activeByDefault"));
                        }
                    }
                }
                targetProfile.setDependencyManagement(this.registerDependencyManagement(sourceProfile.getDependencyManagement(), targetProfile.getDependencyManagement()));
                this.registerDependency(sourceProfile.getDependencies(), (DependencyContainer)targetProfile);
                targetProfile.setBuildBase(this.registerBuildBase(sourceProfile.getBuild(), targetProfile.getBuildBase()));
            }
        }
    }

    private DependencyManagement registerDependencyManagement(org.apache.maven.model.DependencyManagement source, DependencyManagement target) {
        if (source != null) {
            if (target == null) {
                target = this.pomModel.getFactory().createDependencyManagement();
            }
            this.registerDependency(source.getDependencies(), (DependencyContainer)target);
        }
        return target;
    }

    private void registerDependency(List<Dependency> source, DependencyContainer target) {
        source.forEach(sourceDependency -> {
            org.netbeans.modules.maven.model.pom.Dependency targetDependency = target.findDependencyById(sourceDependency.getGroupId(), sourceDependency.getArtifactId(), null);
            if (targetDependency == null) {
                targetDependency = this.createDependency((Dependency)sourceDependency);
                target.addDependency(targetDependency);
            }
            this.updateDependency((Dependency)sourceDependency, targetDependency);
        });
    }

    public void registerDependency(String groupId, String artifactId, String version, String type, String classifier, String scope) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setType(type);
        dependency.setClassifier(classifier);
        dependency.setScope(scope);
        this.registerDependency(Collections.singletonList(dependency), (DependencyContainer)this.getPOMProject());
    }

    private org.netbeans.modules.maven.model.pom.Dependency createDependency(Dependency source) {
        org.netbeans.modules.maven.model.pom.Dependency target = this.pomModel.getFactory().createDependency();
        target.setGroupId(source.getGroupId());
        target.setArtifactId(source.getArtifactId());
        target.setClassifier(source.getClassifier());
        if (!"jar".equals(source.getType())) {
            target.setType(source.getType());
        }
        target.setScope(source.getScope());
        return target;
    }

    private void updateDependency(Dependency source, org.netbeans.modules.maven.model.pom.Dependency target) {
        target.setVersion(source.getVersion());
        if (source.getExclusions() != null && !source.getExclusions().isEmpty()) {
            for (Exclusion sourceExclusion : source.getExclusions()) {
                org.netbeans.modules.maven.model.pom.Exclusion targetExclusion = target.findExclusionById(sourceExclusion.getGroupId(), sourceExclusion.getArtifactId());
                if (targetExclusion != null) continue;
                targetExclusion = this.pomModel.getFactory().createExclusion();
                targetExclusion.setGroupId(sourceExclusion.getGroupId());
                targetExclusion.setArtifactId(sourceExclusion.getArtifactId());
                target.addExclusion(targetExclusion);
            }
        }
    }

    private void registerRepository() {
        if (this.sourceModel.getRepositories().size() > 0) {
            this.operations.add((ModelOperation<POMModel>)((ModelOperation)pomModel -> {
                Set existingRepositories = this.getPOMProject().getRepositories() != null ? this.getPOMProject().getRepositories().stream().map(IdPOMComponent::getId).collect(Collectors.toSet()) : Collections.emptySet();
                for (org.apache.maven.model.Repository repository : this.sourceModel.getRepositories()) {
                    if (existingRepositories.contains(repository.getId())) continue;
                    Repository repo = pomModel.getFactory().createRepository();
                    repo.setId(repository.getId());
                    repo.setName(repository.getName());
                    repo.setLayout(repository.getLayout());
                    repo.setUrl(repository.getUrl());
                    if (repository.getSnapshots() != null) {
                        RepositoryPolicy policy = pomModel.getFactory().createReleaseRepositoryPolicy();
                        policy.setEnabled(Boolean.valueOf(repository.getSnapshots().getEnabled()));
                        repo.setReleases(policy);
                    }
                    this.getPOMProject().addRepository(repo);
                }
            }));
        }
    }

    public void setSourceVersion(String version) {
        this.operations.add((ModelOperation<POMModel>)((ModelOperation)pomModel -> ModelUtils.setSourceLevel((POMModel)pomModel, (String)version)));
    }

    public void commit() {
        this.execute();
        if (this.operations.size() > 0) {
            Utilities.performPOMModelOperations((FileObject)this.pomFileObject, this.operations);
        }
        this.pomModel.endTransaction();
    }
}

