/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class IntroPanel
extends JPanel {
    private final IntroWizardPanel wiz;
    private JCheckBox customizeCheck;
    private JTextArea hintsArea;
    private JCheckBox keyboardCheck;
    private JCheckBox menuCheck;
    private JCheckBox toolbarCheck;

    public IntroPanel(IntroWizardPanel wiz) {
        this.wiz = wiz;
        this.initComponents();
        this.initAccessibility();
        this.setName(NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_cfg_basic_opts"));
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.customizeCheck.requestFocus();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"IP_TEXT_select_how_to_install_shortcut"));
        this.menuCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_menu_item"));
        this.toolbarCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_toolbar_button"));
        this.keyboardCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_add_kbd_shortcut"));
        this.customizeCheck.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroPanel.class, (String)"ACS_IP_LBL_cust_code_checkbox"));
    }

    private void initComponents() {
        this.hintsArea = new JTextArea();
        this.menuCheck = new JCheckBox();
        this.toolbarCheck = new JCheckBox();
        this.keyboardCheck = new JCheckBox();
        this.customizeCheck = new JCheckBox();
        this.hintsArea.setEditable(false);
        this.hintsArea.setFont(UIManager.getFont("Label.font"));
        this.hintsArea.setLineWrap(true);
        this.hintsArea.setText(NbBundle.getMessage(IntroPanel.class, (String)"IP_TEXT_select_how_to_install_shortcut"));
        this.hintsArea.setWrapStyleWord(true);
        this.hintsArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.hintsArea.setEnabled(false);
        this.hintsArea.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)this.menuCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_menu_item"));
        this.menuCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroPanel.this.someCheckboxClicked(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.toolbarCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_toolbar_button"));
        this.toolbarCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroPanel.this.someCheckboxClicked(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.keyboardCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_add_kbd_shortcut"));
        this.keyboardCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroPanel.this.someCheckboxClicked(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.customizeCheck, (String)NbBundle.getMessage(IntroPanel.class, (String)"IP_LBL_cust_code_checkbox"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hintsArea).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.menuCheck).addComponent(this.toolbarCheck).addComponent(this.keyboardCheck).addComponent(this.customizeCheck)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hintsArea, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.menuCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolbarCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keyboardCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customizeCheck).addContainerGap(50, Short.MAX_VALUE)));
    }

    private void someCheckboxClicked(ActionEvent evt) {
        this.wiz.fireChangeEvent();
    }

    public static class IntroWizardPanel
    implements WizardDescriptor.Panel<ShortcutWizard> {
        private IntroPanel panel = null;
        private ShortcutWizard wiz = null;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public void initialize(ShortcutWizard wiz) {
            this.wiz = wiz;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        private IntroPanel getPanel() {
            if (this.panel == null) {
                this.panel = new IntroPanel(this);
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public boolean isValid() {
            return this.getPanel().menuCheck.isSelected() || this.getPanel().toolbarCheck.isSelected() || this.getPanel().keyboardCheck.isSelected();
        }

        public final void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public final void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        protected final void fireChangeEvent() {
            this.storeSettings(this.wiz);
            this.cs.fireChange();
        }

        public void readSettings(ShortcutWizard wiz) {
            this.getPanel().customizeCheck.setSelected(this.flag("wizdata.show.cust"));
            this.getPanel().menuCheck.setSelected(this.flag("wizdata.show.menu"));
            this.getPanel().toolbarCheck.setSelected(this.flag("wizdata.show.tool"));
            this.getPanel().keyboardCheck.setSelected(this.flag("wizdata.show.keyb"));
        }

        private boolean flag(String prop) {
            Boolean val = (Boolean)this.wiz.getProperty(prop);
            return val != null ? val : false;
        }

        public void storeSettings(ShortcutWizard wiz) {
            wiz.putProperty("wizdata.show.cust", this.getPanel().customizeCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            wiz.putProperty("wizdata.show.menu", this.getPanel().menuCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            wiz.putProperty("wizdata.show.tool", this.getPanel().toolbarCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
            wiz.putProperty("wizdata.show.keyb", this.getPanel().keyboardCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
    }
}

