/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInternetGatewayRequest
extends BmcRequest<Void> {
    private String igId;

    public String getIgId() {
        return this.igId;
    }

    public Builder toBuilder() {
        return new Builder().igId(this.igId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",igId=").append(String.valueOf(this.igId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInternetGatewayRequest)) {
            return false;
        }
        GetInternetGatewayRequest other = (GetInternetGatewayRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.igId, other.igId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.igId == null ? 43 : this.igId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInternetGatewayRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String igId = null;

        public Builder igId(String igId) {
            this.igId = igId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInternetGatewayRequest o) {
            this.igId(o.getIgId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInternetGatewayRequest build() {
            GetInternetGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInternetGatewayRequest buildWithoutInvocationCallback() {
            GetInternetGatewayRequest request = new GetInternetGatewayRequest();
            request.igId = this.igId;
            return request;
        }
    }
}

