/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VnicAttachment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="nicIndex")
    private final Integer nicIndex;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="vlanId")
    private final String vlanId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="vlanTag")
    private final Integer vlanTag;
    @JsonProperty(value="vnicId")
    private final String vnicId;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "compartmentId", "displayName", "id", "instanceId", "lifecycleState", "nicIndex", "subnetId", "vlanId", "timeCreated", "vlanTag", "vnicId"})
    public VnicAttachment(String availabilityDomain, String compartmentId, String displayName, String id, String instanceId, LifecycleState lifecycleState, Integer nicIndex, String subnetId, String vlanId, Date timeCreated, Integer vlanTag, String vnicId) {
        this.availabilityDomain = availabilityDomain;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.id = id;
        this.instanceId = instanceId;
        this.lifecycleState = lifecycleState;
        this.nicIndex = nicIndex;
        this.subnetId = subnetId;
        this.vlanId = vlanId;
        this.timeCreated = timeCreated;
        this.vlanTag = vlanTag;
        this.vnicId = vnicId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getNicIndex() {
        return this.nicIndex;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getVlanId() {
        return this.vlanId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Integer getVlanTag() {
        return this.vlanTag;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VnicAttachment(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", nicIndex=").append(String.valueOf(this.nicIndex));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", vlanId=").append(String.valueOf(this.vlanId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", vlanTag=").append(String.valueOf(this.vlanTag));
        sb.append(", vnicId=").append(String.valueOf(this.vnicId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VnicAttachment)) {
            return false;
        }
        VnicAttachment other = (VnicAttachment)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.nicIndex, other.nicIndex) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.vlanId, other.vlanId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.vlanTag, other.vlanTag) && Objects.equals(this.vnicId, other.vnicId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.nicIndex == null ? 43 : this.nicIndex.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.vlanId == null ? 43 : this.vlanId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.vlanTag == null ? 43 : this.vlanTag.hashCode());
        result = result * 59 + (this.vnicId == null ? 43 : this.vnicId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Attaching("ATTACHING"),
        Attached("ATTACHED"),
        Detaching("DETACHING"),
        Detached("DETACHED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="nicIndex")
        private Integer nicIndex;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="vlanId")
        private String vlanId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="vlanTag")
        private Integer vlanTag;
        @JsonProperty(value="vnicId")
        private String vnicId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder nicIndex(Integer nicIndex) {
            this.nicIndex = nicIndex;
            this.__explicitlySet__.add("nicIndex");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder vlanId(String vlanId) {
            this.vlanId = vlanId;
            this.__explicitlySet__.add("vlanId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder vlanTag(Integer vlanTag) {
            this.vlanTag = vlanTag;
            this.__explicitlySet__.add("vlanTag");
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            this.__explicitlySet__.add("vnicId");
            return this;
        }

        public VnicAttachment build() {
            VnicAttachment model = new VnicAttachment(this.availabilityDomain, this.compartmentId, this.displayName, this.id, this.instanceId, this.lifecycleState, this.nicIndex, this.subnetId, this.vlanId, this.timeCreated, this.vlanTag, this.vnicId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VnicAttachment model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("nicIndex")) {
                this.nicIndex(model.getNicIndex());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("vlanId")) {
                this.vlanId(model.getVlanId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("vlanTag")) {
                this.vlanTag(model.getVlanTag());
            }
            if (model.wasPropertyExplicitlySet("vnicId")) {
                this.vnicId(model.getVnicId());
            }
            return this;
        }
    }
}

