/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AppCatalogListingSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="listingId")
    private final String listingId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="publisherName")
    private final String publisherName;

    @Deprecated
    @ConstructorProperties(value={"listingId", "displayName", "summary", "publisherName"})
    public AppCatalogListingSummary(String listingId, String displayName, String summary, String publisherName) {
        this.listingId = listingId;
        this.displayName = displayName;
        this.summary = summary;
        this.publisherName = publisherName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppCatalogListingSummary(");
        sb.append("super=").append(super.toString());
        sb.append("listingId=").append(String.valueOf(this.listingId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(", publisherName=").append(String.valueOf(this.publisherName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppCatalogListingSummary)) {
            return false;
        }
        AppCatalogListingSummary other = (AppCatalogListingSummary)((Object)o);
        return Objects.equals(this.listingId, other.listingId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.summary, other.summary) && Objects.equals(this.publisherName, other.publisherName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.publisherName == null ? 43 : this.publisherName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="listingId")
        private String listingId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="publisherName")
        private String publisherName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            this.__explicitlySet__.add("listingId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.__explicitlySet__.add("publisherName");
            return this;
        }

        public AppCatalogListingSummary build() {
            AppCatalogListingSummary model = new AppCatalogListingSummary(this.listingId, this.displayName, this.summary, this.publisherName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AppCatalogListingSummary model) {
            if (model.wasPropertyExplicitlySet("listingId")) {
                this.listingId(model.getListingId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("publisherName")) {
                this.publisherName(model.getPublisherName());
            }
            return this;
        }
    }
}

