/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.ultimate.hprof.utils.BBUtils;
import com.intellij.util.io.ByteBufferUtil;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class PagedByteBuffer {
    private static final Logger LOG = Logger.getInstance(PagedByteBuffer.class);
    private Path myPath;
    private final Page myPage;
    private final long mySize;
    private final int myRecordSize;

    public PagedByteBuffer(long totalSize, int recordSize, Path path, StandardOpenOption ... options) throws IOException {
        this.myPath = null;
        this.mySize = totalSize;
        this.myRecordSize = recordSize;
        this.myPath = path;
        int bufferSize = (int)Math.min(this.mySize, Integer.MAX_VALUE) / recordSize * recordSize;
        int count = (int)Math.ceil((double)this.mySize * 1.0 / (double)bufferSize);
        ByteBuffer[] pages = new ByteBuffer[count];
        boolean isReadOnly = options.length == 1 && options[0] == StandardOpenOption.READ;
        try (FileChannel channel = FileChannel.open(path, options.length == 0 ? BBUtils.READ_WRITE : options);){
            FileChannel.MapMode mode = isReadOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            for (int i = 0; i < count; ++i) {
                pages[i] = channel.map(mode, (long)i * (long)bufferSize, Math.min((long)bufferSize, this.mySize - (long)bufferSize * (long)i));
            }
        }
        this.myPage = pages.length == 1 ? new SingePage(pages[0]) : new MultiplePage(pages, bufferSize);
    }

    public PagedByteBuffer(long totalSize, int recordSize) {
        this.myPath = null;
        this.mySize = totalSize;
        this.myRecordSize = recordSize;
        int bufferSize = (int)Math.min(this.mySize, Integer.MAX_VALUE) / recordSize * recordSize;
        int count = (int)Math.ceil((double)this.mySize * 1.0 / (double)bufferSize);
        ByteBuffer[] pages = new ByteBuffer[count];
        for (int i = 0; i < count; ++i) {
            pages[i] = ByteBuffer.allocateDirect((int)Math.min((long)bufferSize, this.mySize - (long)bufferSize * (long)i));
        }
        this.myPage = pages.length == 1 ? new SingePage(pages[0]) : new MultiplePage(pages, bufferSize);
    }

    @TestOnly
    public PagedByteBuffer(int recordSize, ByteBuffer @NotNull [] pages) {
        if (pages == null) {
            PagedByteBuffer.$$$reportNull$$$0(0);
        }
        this.myPath = null;
        this.myPage = new MultiplePage(pages, Arrays.stream(pages).mapToInt(Buffer::limit).max().orElse(0));
        this.myRecordSize = recordSize;
        this.mySize = Arrays.stream(pages).mapToLong(Buffer::limit).sum();
    }

    public void get(long position, byte[] bytes) {
        this.myPage.get(position, bytes);
    }

    public int getInt(long position) {
        return this.myPage.getInt(position);
    }

    public void putInt(long position, int value) {
        this.myPage.putInt(position, value);
    }

    public long getLong(long position) {
        return this.myPage.getLong(position);
    }

    public void putLong(long position, long value) {
        this.myPage.putLong(position, value);
    }

    public long getSize() {
        return this.mySize;
    }

    public void close() {
        try {
            this.myPage.close();
        }
        catch (Exception e) {
            LOG.error("Cannot close byte buffer for file '" + this.myPath.toString() + "'", (Throwable)e);
        }
    }

    public int getRecordSize() {
        return this.myRecordSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pages", "com/intellij/profiler/ultimate/hprof/utils/PagedByteBuffer", "<init>"));
    }

    private static final class SingePage
    implements Page {
        private final ByteBuffer myBuffer;

        private SingePage(ByteBuffer buffer) {
            this.myBuffer = buffer;
        }

        @Override
        public void get(long position, byte[] bytes) {
            this.myBuffer.position((int)position);
            this.myBuffer.get(bytes);
        }

        @Override
        public int getInt(long position) {
            return this.myBuffer.getInt((int)position);
        }

        @Override
        public void putInt(long position, int value) {
            this.myBuffer.putInt((int)position, value);
        }

        @Override
        public long getLong(long position) {
            return this.myBuffer.getLong((int)position);
        }

        @Override
        public void putLong(long position, long value) {
            this.myBuffer.putLong((int)position, value);
        }

        @Override
        public void close() {
            ByteBufferUtil.cleanBuffer((ByteBuffer)this.myBuffer);
        }
    }

    private static final class MultiplePage
    implements Page {
        private final ByteBuffer[] myPages;
        private final int myBufferSize;

        private MultiplePage(ByteBuffer[] pages, int size) {
            this.myPages = pages;
            this.myBufferSize = size;
        }

        @Override
        public void get(long position, byte[] bytes) {
            if (this.myBufferSize == 0) {
                return;
            }
            int page = (int)(position / (long)this.myBufferSize);
            int ptr = (int)(position - (long)(page * this.myBufferSize));
            this.myPages[page].position(ptr);
            int remaining = bytes.length;
            int start2 = 0;
            while (remaining > 0) {
                if (page >= this.myPages.length) {
                    throw new BufferUnderflowException();
                }
                int toReadInCurrentPage = Math.min(remaining, this.myPages[page].remaining());
                this.myPages[page].get(bytes, start2, toReadInCurrentPage);
                start2 += toReadInCurrentPage;
                remaining -= toReadInCurrentPage;
                ++page;
            }
        }

        @Override
        public int getInt(long position) {
            int page = (int)(position / (long)this.myBufferSize);
            int ptr = (int)(position - (long)(page * this.myBufferSize));
            return this.myPages[page].getInt(ptr);
        }

        @Override
        public void putInt(long position, int value) {
            int page = (int)(position / (long)this.myBufferSize);
            int ptr = (int)(position - (long)(page * this.myBufferSize));
            this.myPages[page].putInt(ptr, value);
        }

        @Override
        public long getLong(long position) {
            int page = (int)(position / (long)this.myBufferSize);
            int ptr = (int)(position - (long)(page * this.myBufferSize));
            return this.myPages[page].getLong(ptr);
        }

        @Override
        public void putLong(long position, long value) {
            int page = (int)(position / (long)this.myBufferSize);
            int ptr = (int)(position - (long)(page * this.myBufferSize));
            this.myPages[page].putLong(ptr, value);
        }

        @Override
        public void close() {
            for (ByteBuffer page : this.myPages) {
                ByteBufferUtil.cleanBuffer((ByteBuffer)page);
            }
        }
    }

    private static interface Page
    extends AutoCloseable {
        public void get(long var1, byte[] var3);

        public int getInt(long var1);

        public void putInt(long var1, int var3);

        public long getLong(long var1);

        public void putLong(long var1, long var3);
    }
}

