/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.client;

import com.intellij.station.comms.common.StationHttpException;
import com.intellij.station.comms.common.StationUnknownEndpointException;
import com.intellij.station.comms.common.api.ServiceMetaInfo;
import com.intellij.station.comms.common.api.StationServicesClient;
import com.intellij.station.comms.common.api.TypedWebsocketClient;
import com.intellij.station.comms.common.netty.client.StationServicesClientBase;
import com.intellij.station.comms.common.netty.util.ExtensionsKt;
import com.intellij.station.comms.common.netty.util.SingleMessageFutureChannelInboundHandler;
import com.intellij.station.comms.common.netty.websocket.WebSocketClientImpl;
import com.intellij.station.comms.common.utils.Logging;
import com.intellij.station.comms.common.utils.StationConstants;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnixDomainSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 #2\u00020\u0001:\u0001#B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J>\u0010\u0017\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0019*\u00020\u001a\"\b\b\u0001\u0010\u0018*\u00020\u001a2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00180\u00112\u0006\u0010\u0017\u001a\u0002H\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001bJB\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001d\"\b\b\u0000\u0010\u0019*\u00020\u001a\"\b\b\u0001\u0010\u0018*\u00020\u001a2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H\u00180\u0011H\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/intellij/station/comms/common/netty/client/StationServicesClientBase;", "Lcom/intellij/station/comms/common/api/StationServicesClient;", "remoteEndpointMain", "Ljava/net/UnixDomainSocketAddress;", "group", "Lio/netty/channel/EventLoopGroup;", "additionalEndpoint", "<init>", "(Ljava/net/UnixDomainSocketAddress;Lio/netty/channel/EventLoopGroup;Ljava/net/UnixDomainSocketAddress;)V", "extraHeaders", "", "", "getExtraHeaders", "()Ljava/util/Map;", "buildUri", "Ljava/net/URI;", "metaInfo", "Lcom/intellij/station/comms/common/api/ServiceMetaInfo;", "protocol", "getEndpointToUse", "checkSocketPermissions", "", "endpoint", "request", "Response", "Request", "", "(Lcom/intellij/station/comms/common/api/ServiceMetaInfo;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "websocket", "Lcom/intellij/station/comms/common/api/TypedWebsocketClient;", "(Lcom/intellij/station/comms/common/api/ServiceMetaInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "throwOnBadResponse", "requestURI", "response", "Lio/netty/handler/codec/http/HttpResponse;", "Companion", "intellij.station.comms.common"})
@SourceDebugExtension(value={"SMAP\nStationServicesClientBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StationServicesClientBase.kt\ncom/intellij/station/comms/common/netty/client/StationServicesClientBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 SingleMessageFutureChannelInboundHandler.kt\ncom/intellij/station/comms/common/netty/util/SingleMessageFutureChannelInboundHandlerKt\n+ 5 Logging.kt\ncom/intellij/station/comms/common/utils/Logging\n*L\n1#1,206:1\n1761#2,3:207\n216#3,2:210\n216#3,2:213\n7#4:212\n7#4:215\n7#5:216\n*S KotlinDebug\n*F\n+ 1 StationServicesClientBase.kt\ncom/intellij/station/comms/common/netty/client/StationServicesClientBase\n*L\n68#1:207,3\n100#1:210,2\n143#1:213,2\n104#1:212\n151#1:215\n44#1:216\n*E\n"})
public abstract class StationServicesClientBase
implements StationServicesClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnixDomainSocketAddress remoteEndpointMain;
    @NotNull
    private final EventLoopGroup group;
    @Nullable
    private final UnixDomainSocketAddress additionalEndpoint;
    @NotNull
    private static final Logger logger;
    private static final int maximumBodySize;

    public StationServicesClientBase(@NotNull UnixDomainSocketAddress remoteEndpointMain, @NotNull EventLoopGroup group, @Nullable UnixDomainSocketAddress additionalEndpoint) {
        Intrinsics.checkNotNullParameter((Object)remoteEndpointMain, (String)"remoteEndpointMain");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.remoteEndpointMain = remoteEndpointMain;
        this.group = group;
        this.additionalEndpoint = additionalEndpoint;
    }

    public /* synthetic */ StationServicesClientBase(UnixDomainSocketAddress unixDomainSocketAddress, EventLoopGroup eventLoopGroup, UnixDomainSocketAddress unixDomainSocketAddress2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            unixDomainSocketAddress2 = null;
        }
        this(unixDomainSocketAddress, eventLoopGroup, unixDomainSocketAddress2);
    }

    @NotNull
    public abstract Map<String, String> getExtraHeaders();

    private final URI buildUri(ServiceMetaInfo<?, ?> metaInfo, String protocol) {
        URI uRI = URI.create(protocol + "://remote" + metaInfo.getEndpoint());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    private final UnixDomainSocketAddress getEndpointToUse() {
        if (Files.exists(this.remoteEndpointMain.getPath(), new LinkOption[0])) {
            return this.remoteEndpointMain;
        }
        if (this.additionalEndpoint != null && Files.exists(this.additionalEndpoint.getPath(), new LinkOption[0])) {
            return this.additionalEndpoint;
        }
        return this.remoteEndpointMain;
    }

    private final void checkSocketPermissions(UnixDomainSocketAddress endpoint) {
        if (!StationConstants.INSTANCE.isLinux()) {
            return;
        }
        try {
            boolean bl;
            block7: {
                Set<PosixFilePermission> set = Files.getPosixFilePermissions(endpoint.getPath(), new LinkOption[0]);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getPosixFilePermissions(...)");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PosixFilePermission permission = (PosixFilePermission)((Object)element$iv);
                        boolean bl2 = false;
                        if (!(permission == PosixFilePermission.OTHERS_WRITE || permission == PosixFilePermission.GROUP_WRITE)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalStateException("Unexpected too-wide permissions on station socket, will not proceed".toString());
            }
        }
        catch (UnsupportedOperationException ex) {
            logger.trace("POSIX permissions not supported for station socket", (Throwable)ex);
        }
    }

    @Override
    @Nullable
    public <Request, Response> Object request(@NotNull ServiceMetaInfo<Request, Response> metaInfo, @NotNull Request request2, @NotNull Continuation<? super Response> $completion) {
        return StationServicesClientBase.request$suspendImpl(this, metaInfo, request2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* synthetic */ <Request, Response> Object request$suspendImpl(StationServicesClientBase $this, ServiceMetaInfo<Request, Response> metaInfo, Request request, Continuation<? super Response> $completion) {
        if (!($completion instanceof request.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                /* synthetic */ Object result;
                final /* synthetic */ StationServicesClientBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StationServicesClientBase.request$suspendImpl(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                remoteEndpoint = $this.getEndpointToUse();
                $this.checkSocketPermissions(remoteEndpoint);
                data = metaInfo.getCodec().encodeRequest(request /* !! */ );
                bootstrap = new Bootstrap();
                ((Bootstrap)bootstrap.group($this.group)).channel(NioDomainSocketChannel.class);
                uri = $this.buildUri(metaInfo, "http");
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri.toString(), Unpooled.wrappedBuffer((byte[])data));
                request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Boxing.boxInt((int)request.content().readableBytes()));
                $this$forEach$iv = $this.getExtraHeaders();
                $i$f$forEach = false;
                var11_27 = $this$forEach$iv.entrySet().iterator();
                while (var11_27.hasNext()) {
                    it = element$iv = var11_27.next();
                    $i$a$-forEach-StationServicesClientBase$request$2 = false;
                    request.headers().add(it.getKey(), (Object)it.getValue());
                }
                $i$f$SingleMessageFutureChannelInboundHandler = false;
                responseFutureHandler = new SingleMessageFutureChannelInboundHandler<FullHttpResponse>(FullHttpResponse.class);
                bootstrap.handler((ChannelHandler)new ChannelInitializer<NioDomainSocketChannel>(responseFutureHandler){
                    final /* synthetic */ SingleMessageFutureChannelInboundHandler<FullHttpResponse> $responseFutureHandler;
                    {
                        this.$responseFutureHandler = $responseFutureHandler;
                    }

                    protected void initChannel(NioDomainSocketChannel ch) {
                        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                        ChannelPipeline p = ch.pipeline();
                        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(StationServicesClientBase.access$getMaximumBodySize$cp()), this.$responseFutureHandler};
                        p.addLast(channelHandlerArray);
                    }
                });
                v0 = bootstrap.connect((SocketAddress)remoteEndpoint);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"connect(...)");
                $continuation.L$0 = $this;
                $continuation.L$1 = metaInfo;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                $continuation.L$6 = uri;
                $continuation.L$7 = request;
                $continuation.L$8 = responseFutureHandler;
                $continuation.label = 1;
                v1 = ExtensionsKt.awaitSuspend(v0, $continuation);
                if (v1 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl64
            }
            case 1: {
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler<FullHttpResponse>)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl64:
                // 2 sources

                channel = (Channel)v1;
                v2 = channel.writeAndFlush((Object)request);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"writeAndFlush(...)");
                $continuation.L$0 = $this;
                $continuation.L$1 = metaInfo;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                $continuation.L$6 = uri;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$8 = responseFutureHandler;
                $continuation.L$9 = channel;
                $continuation.label = 2;
                v3 = ExtensionsKt.awaitSuspend(v2, $continuation);
                ** if (v3 != var17_6) goto lbl83
lbl82:
                // 1 sources

                return var17_6;
lbl83:
                // 1 sources

                ** GOTO lbl99
            }
            case 2: {
                channel = (Channel)$continuation.L$9;
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl99:
                // 2 sources

                $continuation.L$0 = $this;
                $continuation.L$1 = metaInfo;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                $continuation.L$6 = uri;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$8 = responseFutureHandler;
                $continuation.L$9 = channel;
                $continuation.label = 3;
                v4 = FutureKt.await((CompletionStage)responseFutureHandler.getFuture(), $continuation);
                ** if (v4 != var17_6) goto lbl113
lbl112:
                // 1 sources

                return var17_6;
lbl113:
                // 1 sources

                ** GOTO lbl129
            }
            case 3: {
                channel = (Channel)$continuation.L$9;
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl129:
                // 2 sources

                response = (FullHttpResponse)v4;
                Intrinsics.checkNotNull((Object)response);
                $this.throwOnBadResponse(uri, (HttpResponse)response);
                v5 = metaInfo.getCodec();
                v6 = response.content();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"content(...)");
                var12_29 = v5.decodeResponse(ExtensionsKt.readAllToArray(v6));
                v7 = channel.close();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"close(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)metaInfo);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$8 = responseFutureHandler;
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)channel);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$11 = var12_29;
                $continuation.label = 4;
                v8 = ExtensionsKt.awaitSuspend(v7, $continuation);
                if (v8 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl170
            }
            case 4: {
                var12_29 = $continuation.L$11;
                response = (FullHttpResponse)$continuation.L$10;
                channel = (Channel)$continuation.L$9;
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl170:
                // 2 sources

                responseFutureHandler.close();
                return var12_29;
            }
        }
        catch (Throwable var12_30) {
            v9 = channel.close();
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"close(...)");
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)metaInfo);
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable(request /* !! */ );
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)remoteEndpoint);
            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)data);
            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)bootstrap);
            $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)uri);
            $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)request);
            $continuation.L$8 = responseFutureHandler;
            $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)channel);
            $continuation.L$10 = var12_30;
            $continuation.label = 5;
            v10 = ExtensionsKt.awaitSuspend(v9, $continuation);
            if (v10 == var17_6) {
                return var17_6;
            }
            ** GOTO lbl205
        }
        {
            case 5: {
                var12_31 = (Throwable)$continuation.L$10;
                channel = (Channel)$continuation.L$9;
                responseFutureHandler = (SingleMessageFutureChannelInboundHandler)$continuation.L$8;
                request = (DefaultFullHttpRequest)$continuation.L$7;
                uri = (URI)$continuation.L$6;
                bootstrap = (Bootstrap)$continuation.L$5;
                data = (byte[])$continuation.L$4;
                remoteEndpoint = (UnixDomainSocketAddress)$continuation.L$3;
                request /* !! */  = $continuation.L$2;
                metaInfo = (ServiceMetaInfo)$continuation.L$1;
                $this = (StationServicesClientBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl205:
                // 2 sources

                responseFutureHandler.close();
                throw var12_31;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public <Request, Response> Object websocket(@NotNull ServiceMetaInfo<Request, Response> metaInfo, @NotNull Continuation<? super TypedWebsocketClient<Response, Request>> $completion) {
        return StationServicesClientBase.websocket$suspendImpl(this, metaInfo, $completion);
    }

    static /* synthetic */ <Request, Response> Object websocket$suspendImpl(StationServicesClientBase $this, ServiceMetaInfo<Request, Response> metaInfo, Continuation<? super TypedWebsocketClient<Response, Request>> $completion) {
        UnixDomainSocketAddress remoteEndpoint = $this.getEndpointToUse();
        $this.checkSocketPermissions(remoteEndpoint);
        Bootstrap bootstrap2 = new Bootstrap();
        ((Bootstrap)bootstrap2.group($this.group)).channel(NioDomainSocketChannel.class);
        URI uri = $this.buildUri(metaInfo, "ws");
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        Map<String, String> $this$forEach$iv = $this.getExtraHeaders();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            headers.add(it.getKey(), (Object)it.getValue());
        }
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)((HttpHeaders)headers), (int)maximumBodySize);
        boolean $i$f$SingleMessageFutureChannelInboundHandler = false;
        SingleMessageFutureChannelInboundHandler<FullHttpResponse> responseFutureHandler = new SingleMessageFutureChannelInboundHandler<FullHttpResponse>(FullHttpResponse.class);
        bootstrap2.handler((ChannelHandler)new ChannelInitializer<NioDomainSocketChannel>(responseFutureHandler){
            final /* synthetic */ SingleMessageFutureChannelInboundHandler<FullHttpResponse> $responseFutureHandler;
            {
                this.$responseFutureHandler = $responseFutureHandler;
            }

            protected void initChannel(NioDomainSocketChannel ch) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                ChannelPipeline p = ch.pipeline();
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), this.$responseFutureHandler};
                p.addLast(channelHandlerArray);
            }
        });
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), (Function2)new Function2<CoroutineScope, Continuation<? super WebSocketClientImpl<Response, Request>>, Object>(bootstrap2, remoteEndpoint, responseFutureHandler, uri, metaInfo, handshaker, $this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int I$0;
            int label;
            final /* synthetic */ Bootstrap $bootstrap;
            final /* synthetic */ UnixDomainSocketAddress $remoteEndpoint;
            final /* synthetic */ SingleMessageFutureChannelInboundHandler<FullHttpResponse> $responseFutureHandler;
            final /* synthetic */ URI $uri;
            final /* synthetic */ ServiceMetaInfo<Request, Response> $metaInfo;
            final /* synthetic */ WebSocketClientHandshaker $handshaker;
            final /* synthetic */ StationServicesClientBase this$0;
            {
                this.$bootstrap = $bootstrap;
                this.$remoteEndpoint = $remoteEndpoint;
                this.$responseFutureHandler = $responseFutureHandler;
                this.$uri = $uri;
                this.$metaInfo = $metaInfo;
                this.$handshaker = $handshaker;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.$bootstrap.connect((SocketAddress)this.$remoteEndpoint);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"connect(...)");
                        this.label = 1;
                        v1 = ExtensionsKt.awaitSuspend(v0, (Continuation<? super Channel>)((Continuation)this));
                        if (v1 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        channel = (Channel)v1;
                        var3_4 = this.$responseFutureHandler;
                        var4_5 = this.$handshaker;
                        var5_6 = this.$responseFutureHandler;
                        var6_7 = this.this$0;
                        var7_8 = this.$uri;
                        var8_9 = null;
                        it = (SingleMessageFutureChannelInboundHandler)var3_4;
                        $i$a$-use-StationServicesClientBase$websocket$4$1 = 0;
                        v2 = var4_5.handshake(channel);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"handshake(...)");
                        this.L$0 = channel;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.L$3 = var5_6;
                        this.L$4 = var6_7;
                        this.L$5 = var7_8;
                        this.L$6 = SpillingKt.nullOutSpilledVariable((Object)it);
                        this.I$0 = $i$a$-use-StationServicesClientBase$websocket$4$1;
                        this.label = 2;
                        v3 = ExtensionsKt.awaitSuspend(v2, (Continuation<? super Channel>)this);
                        ** if (v3 != var13_2) goto lbl40
lbl39:
                        // 1 sources

                        return var13_2;
lbl40:
                        // 1 sources

                        ** GOTO lbl55
                    }
                    case 2: {
                        $i$a$-use-StationServicesClientBase$websocket$4$1 = this.I$0;
                        it = (SingleMessageFutureChannelInboundHandler)this.L$6;
                        var8_9 = null;
                        var7_8 = (URI)this.L$5;
                        var6_7 = (StationServicesClientBase)this.L$4;
                        var5_6 = (SingleMessageFutureChannelInboundHandler)this.L$3;
                        var4_5 = (WebSocketClientHandshaker)this.L$2;
                        var3_4 = (AutoCloseable)this.L$1;
                        channel = (Channel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl55:
                        // 2 sources

                        this.L$0 = channel;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.L$3 = var6_7;
                        this.L$4 = var7_8;
                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)it);
                        this.L$6 = null;
                        this.I$0 = $i$a$-use-StationServicesClientBase$websocket$4$1;
                        this.label = 3;
                        v4 = FutureKt.await((CompletionStage)var5_6.getFuture(), (Continuation)this);
                        ** if (v4 != var13_2) goto lbl67
lbl66:
                        // 1 sources

                        return var13_2;
lbl67:
                        // 1 sources

                        ** GOTO lbl81
                    }
                    case 3: {
                        $i$a$-use-StationServicesClientBase$websocket$4$1 = this.I$0;
                        it = (SingleMessageFutureChannelInboundHandler)this.L$5;
                        var8_9 = null;
                        var7_8 = (URI)this.L$4;
                        var6_7 = (StationServicesClientBase)this.L$3;
                        var4_5 = (WebSocketClientHandshaker)this.L$2;
                        var3_4 = (AutoCloseable)this.L$1;
                        channel = (Channel)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl81:
                            // 2 sources

                            httpResponse = (FullHttpResponse)v4;
                            Intrinsics.checkNotNull((Object)httpResponse);
                            StationServicesClientBase.access$throwOnBadResponse(var6_7, var7_8, (HttpResponse)httpResponse);
                            var4_5.finishHandshake(channel, httpResponse);
                            if (!var4_5.isHandshakeComplete()) {
                                channel.close();
                                statusCode = httpResponse.status().code();
                                throw new StationHttpException(statusCode, "Websocket handshake failed: " + httpResponse.status().reasonPhrase(), null, 4, null);
                            }
                            var9_10 = Unit.INSTANCE;
                            ** GOTO lbl100
                        }
                        catch (Throwable var10_12) {
                            var8_9 = var10_12;
                            throw var10_12;
                        }
                    }
                    catch (Throwable var10_13) {
                        throw var10_13;
                    }
                    {
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)var3_4, (Throwable)var8_9);
                        }
lbl100:
                        // 1 sources

                        baseWebSocketClient = new WebSocketClientImpl<Response, Request>("ws client to " + this.$uri, channel, this.$metaInfo.getCodec().flip());
                        var4_5 = new ChannelHandler[]{baseWebSocketClient};
                        channel.pipeline().addLast(var4_5);
                        return baseWebSocketClient;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super WebSocketClientImpl<Response, Request>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final void throwOnBadResponse(URI requestURI, HttpResponse response) {
        int code = response.status().code();
        switch (code) {
            case 100: 
            case 101: 
            case 200: {
                return;
            }
        }
        if (code == 404 && Intrinsics.areEqual((Object)response.headers().get(StationConstants.INSTANCE.getStationFailureHeader()), (Object)StationConstants.INSTANCE.getUnknownEndpointValue())) {
            throw new StationUnknownEndpointException("Endpoint for " + requestURI + " not found", null, 2, null);
        }
        throw new StationHttpException(code, "HTTP error on " + requestURI + ": " + code + " " + response.status().reasonPhrase(), null, 4, null);
    }

    public static final /* synthetic */ int access$getMaximumBodySize$cp() {
        return maximumBodySize;
    }

    public static final /* synthetic */ void access$throwOnBadResponse(StationServicesClientBase $this, URI requestURI, HttpResponse response) {
        $this.throwOnBadResponse(requestURI, response);
    }

    static {
        Logging logging = Logging.INSTANCE;
        Companion $this$myLogger$iv = Companion;
        boolean $i$f$myLogger = false;
        Logger logger = LoggerFactory.getLogger(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        StationServicesClientBase.logger = logger;
        maximumBodySize = 0xA00000;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/station/comms/common/netty/client/StationServicesClientBase$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "maximumBodySize", "", "intellij.station.comms.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

