/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.cache;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.control.NonFatal$;
import xsbt.boot.internal.shaded.coursier.cache.ArtifactError;
import xsbt.boot.internal.shaded.coursier.cache.Cache;
import xsbt.boot.internal.shaded.coursier.cache.CacheChecksum$;
import xsbt.boot.internal.shaded.coursier.cache.CacheLogger;
import xsbt.boot.internal.shaded.coursier.cache.CachePolicy;
import xsbt.boot.internal.shaded.coursier.cache.FileCache$;
import xsbt.boot.internal.shaded.coursier.cache.internal.DownloadResult;
import xsbt.boot.internal.shaded.coursier.cache.internal.Downloader$;
import xsbt.boot.internal.shaded.coursier.cache.internal.Retry;
import xsbt.boot.internal.shaded.coursier.core.Authentication;
import xsbt.boot.internal.shaded.coursier.credentials.Credentials;
import xsbt.boot.internal.shaded.coursier.credentials.DirectCredentials;
import xsbt.boot.internal.shaded.coursier.util.Artifact;
import xsbt.boot.internal.shaded.coursier.util.EitherT;
import xsbt.boot.internal.shaded.coursier.util.Monad$ops$;
import xsbt.boot.internal.shaded.coursier.util.Sync;
import xsbt.boot.internal.shaded.coursier.util.WebPage$;

public final class FileCache<F>
extends Cache<F>
implements Serializable,
Product {
    private Seq<DirectCredentials> allCredentials0;
    private ExecutionContextExecutorService ec;
    private final File location;
    private final Seq<CachePolicy> cachePolicies;
    private final Seq<Option<String>> checksums;
    private final Seq<Credentials> credentials;
    private final CacheLogger logger;
    private final ExecutorService pool;
    private final Option<Duration> ttl;
    private final boolean localArtifactsShouldBeCached;
    private final boolean followHttpToHttpsRedirections;
    private final boolean followHttpsToHttpRedirections;
    private final Option<Object> maxRedirections;
    private final int sslRetry;
    private final Option<SSLSocketFactory> sslSocketFactoryOpt;
    private final Option<HostnameVerifier> hostnameVerifierOpt;
    private final int retry;
    private final int bufferSize;
    private final Seq<ClassLoader> classLoaders;
    private final Clock clock;
    private final FiniteDuration retryBackoffInitialDelay;
    private final double retryBackoffMultiplier;
    private final Sync<F> sync;
    private final Retry retry0;
    private final Seq<Option<String>> checksums0;
    private final Seq<String> actualChecksums;
    private volatile byte bitmap$0;

    @Override
    public final Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public final File location() {
        return this.location;
    }

    public final Seq<CachePolicy> cachePolicies() {
        return this.cachePolicies;
    }

    public final Seq<Option<String>> checksums() {
        return this.checksums;
    }

    public final Seq<Credentials> credentials() {
        return this.credentials;
    }

    public final CacheLogger logger() {
        return this.logger;
    }

    public final ExecutorService pool() {
        return this.pool;
    }

    public final Option<Duration> ttl() {
        return this.ttl;
    }

    public final boolean localArtifactsShouldBeCached() {
        return this.localArtifactsShouldBeCached;
    }

    public final boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public final boolean followHttpsToHttpRedirections() {
        return this.followHttpsToHttpRedirections;
    }

    public final Option<Object> maxRedirections() {
        return this.maxRedirections;
    }

    public final int sslRetry() {
        return this.sslRetry;
    }

    public final Option<SSLSocketFactory> sslSocketFactoryOpt() {
        return this.sslSocketFactoryOpt;
    }

    public final Option<HostnameVerifier> hostnameVerifierOpt() {
        return this.hostnameVerifierOpt;
    }

    public final int retry() {
        return this.retry;
    }

    public final int bufferSize() {
        return this.bufferSize;
    }

    public final Seq<ClassLoader> classLoaders() {
        return this.classLoaders;
    }

    public final Clock clock() {
        return this.clock;
    }

    public final FiniteDuration retryBackoffInitialDelay() {
        return this.retryBackoffInitialDelay;
    }

    public final double retryBackoffMultiplier() {
        return this.retryBackoffMultiplier;
    }

    public final Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private Retry retry0() {
        return this.retry0;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readAllBytes(Path path) {
        void var1_1;
        return (byte[])this.retry0().retry(() -> FileCache.$anonfun$readAllBytes$1((Path)var1_1), (PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(null){

            /*
             * WARNING - void declaration
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var1_1;
                void var2_2;
                A1 A1 = x1;
                if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)var2_2.apply(var1_1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
            }
        }));
    }

    private Seq<DirectCredentials> allCredentials0$lzycompute() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.allCredentials0 = (Seq)this.credentials().flatMap((Function1<Credentials, Seq> & Serializable)x$1 -> x$1.get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.allCredentials0;
    }

    private Seq<DirectCredentials> allCredentials0() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.allCredentials0$lzycompute();
        }
        return this.allCredentials0;
    }

    public final F allCredentials() {
        return this.S().delay((Function0<Seq> & Serializable)() -> this.allCredentials0());
    }

    public final FileCache<F> noCredentials() {
        return this.withCredentials(Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public final FileCache<F> addCredentials(Seq<Credentials> credentials) {
        void var1_1;
        FileCache fileCache = this;
        return fileCache.withCredentials((Seq)fileCache.credentials().$plus$plus(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final File localFile(String url, Option<String> user) {
        void var2_2;
        void var1_1;
        return FileCache$.MODULE$.localFile0((String)var1_1, this.location(), (Option<String>)var2_2, this.localArtifactsShouldBeCached());
    }

    public final Some<CacheLogger> loggerOpt() {
        return new Some<CacheLogger>(this.logger());
    }

    private Seq<Option<String>> checksums0() {
        return this.checksums0;
    }

    private Seq<String> actualChecksums() {
        return this.actualChecksums;
    }

    /*
     * WARNING - void declaration
     */
    private F download(Artifact artifact, CachePolicy cachePolicy) {
        void var2_2;
        void var1_1;
        return Downloader$.MODULE$.apply((Artifact)var1_1, (CachePolicy)var2_2, this.location(), this.actualChecksums(), this.allCredentials(), this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.retry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.bufferSize(), this.classLoaders(), this.clock(), this.sync()).download();
    }

    /*
     * WARNING - void declaration
     */
    public final EitherT<F, ArtifactError, BoxedUnit> validateChecksum(Artifact artifact, String sumType) {
        void var3_3;
        void var2_2;
        void var1_1;
        File localFile0 = this.localFile(artifact.url(), artifact.authentication().map((Function1<Authentication, String> & Serializable)x$3 -> x$3.user()));
        $colon$colon<Nothing$> headerSumFile = new $colon$colon<Nothing$>((Nothing$)((Object)FileCache$.MODULE$.auxiliaryFile(localFile0, sumType)), Nil$.MODULE$);
        Option downloadedSumFile = artifact.checksumUrls().get(sumType).map((Function1<String, File> & Serializable)sumUrl -> {
            void var1_1;
            void var2_2;
            return this.localFile((String)var2_2, var1_1.authentication().map((Function1<Authentication, String> & Serializable)x$4 -> x$4.user()));
        });
        return new EitherT(this.S().schedule(this.pool(), () -> FileCache.$anonfun$validateChecksum$4(this, headerSumFile, (Option)var1_1, (String)var2_2, (File)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    private EitherT<F, ArtifactError, File> filePerPolicy(Artifact artifact, CachePolicy policy, int retry) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object artifact0 = Monad$ops$.MODULE$.toAllMonadOps(this.allCredentials(), this.sync()).map((Function1<Seq, Artifact> & Serializable)allCredentials -> {
            Artifact artifact;
            if (artifact.authentication().isEmpty()) {
                void var1_1;
                Option authOpt = allCredentials.find((Function1<DirectCredentials, Object> & Serializable)x$6 -> {
                    void var1_1;
                    return BoxesRunTime.boxToBoolean(FileCache.$anonfun$filePerPolicy$2(artifact, (DirectCredentials)var1_1));
                }).map((Function1<DirectCredentials, Authentication> & Serializable)x$7 -> x$7.authentication());
                return artifact.withAuthentication((Option<Authentication>)var1_1);
            }
            return artifact;
        });
        return new EitherT(Monad$ops$.MODULE$.toAllMonadOps(var1_1, this.sync()).map((Function1<Artifact, Right> & Serializable)x$8 -> {
            Artifact artifact;
            return new Right(artifact);
        })).flatMap(arg_0 -> FileCache.$anonfun$filePerPolicy$5(this, (CachePolicy)var2_2, (int)var3_3, arg_0), this.sync());
    }

    /*
     * WARNING - void declaration
     */
    private EitherT<F, ArtifactError, File> filePerPolicy0(Artifact artifact, CachePolicy policy, int retry) {
        void var2_2;
        void var3_3;
        void var1_1;
        return new EitherT(Monad$ops$.MODULE$.toAllMonadOps(this.download(artifact, policy), this.sync()).map((Function1<Seq, Either> & Serializable)results -> {
            Seq seq;
            void var2_2;
            void var1_1;
            void var3_3;
            Map resultsMap = ((IterableOnceOps)results.map((Function1<DownloadResult, Tuple2> & Serializable)x0$1 -> {
                DownloadResult downloadResult = x0$1;
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(downloadResult.url()), downloadResult.errorOpt());
            })).toMap($less$colon$less$.MODULE$.refl());
            Seq checksumResults = (Seq)this.checksums0().map(arg_0 -> FileCache.$anonfun$filePerPolicy0$3(artifact, (Map)var3_3, arg_0));
            Option<Option<String>> checksum = checksumResults.collectFirst(new Serializable(null){

                /*
                 * WARNING - void declaration
                 */
                public final <A1 extends Option<Tuple3<String, String, Option<Option<ArtifactError>>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var1_1;
                    void var2_2;
                    Object object = x1;
                    if (None$.MODULE$.equals(object)) {
                        return (B1)None$.MODULE$;
                    }
                    if (object instanceof Some) {
                        object = (Some)object;
                        if ((object = (Tuple3)((Some)object).value()) != null) {
                            String c = (String)((Tuple3)object)._1();
                            if ((object = (Option)((Tuple3)object)._3()) instanceof Some) {
                                object = (Some)object;
                                if ((object = (Option)((Some)object).value()).isEmpty()) {
                                    return (B1)new Some<String>(c);
                                }
                            }
                        }
                    }
                    return (B1)var2_2.apply(var1_1);
                }

                public final boolean isDefinedAt(Option<Tuple3<String, String, Option<Option<ArtifactError>>>> x1) {
                    Product product = x1;
                    if (None$.MODULE$.equals(product)) {
                        return true;
                    }
                    if (product instanceof Some) {
                        product = (Some)product;
                        if ((product = (Tuple3)((Some)product).value()) != null && (product = (Option)((Tuple3)product)._3()) instanceof Some) {
                            product = (Some)product;
                            if (((Option)(product = (Option)((Some)product).value())).isEmpty()) {
                                return true;
                            }
                        }
                    }
                    return false;
                }
            });
            DownloadResult res = (DownloadResult)results.head();
            return res.errorOpt().toLeft(() -> {}).flatMap(arg_0 -> FileCache.$anonfun$filePerPolicy0$7((Option)var1_1, (DownloadResult)var2_2, seq, arg_0));
        })).flatMap((Function1<Tuple2, EitherT> & Serializable)x0$3 -> {
            void var2_2;
            Option option;
            File f;
            if (x0$3 != null) {
                f = (File)x0$3._1();
                option = (Option)x0$3._2();
                if (None$.MODULE$.equals(option)) {
                    return new EitherT(this.S().point(new Right(f)));
                }
            }
            if (x0$3 != null) {
                f = (File)x0$3._1();
                option = (Option)x0$3._2();
                if (option instanceof Some) {
                    FileCache fileCache;
                    void var3_3;
                    void var1_1;
                    x0$3 = (Some)option;
                    String c = (String)((Some)x0$3).value();
                    return this.validateChecksum((Artifact)var1_1, (String)var2_2).map(arg_0 -> FileCache.$anonfun$filePerPolicy0$9((File)var3_3, arg_0), fileCache.sync());
                }
            }
            throw new MatchError(var2_2);
        }, this.sync()).leftFlatMap(arg_0 -> FileCache.$anonfun$filePerPolicy0$10(this, (Artifact)var1_1, (int)var3_3, (CachePolicy)var2_2, arg_0), this.sync());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final EitherT<F, ArtifactError, File> file(Artifact artifact) {
        void var1_1;
        return this.file((Artifact)var1_1, this.retry());
    }

    /*
     * WARNING - void declaration
     */
    public final EitherT<F, ArtifactError, File> file(Artifact artifact, int retry) {
        void var2_2;
        void var1_1;
        return ((IterableOnceOps)((IterableOps)this.cachePolicies().tail()).map((Function1<CachePolicy, EitherT> & Serializable)x$14 -> {
            void var2_2;
            void var3_3;
            void var1_1;
            return this.filePerPolicy((Artifact)var1_1, (CachePolicy)var3_3, (int)var2_2);
        })).foldLeft(this.filePerPolicy((Artifact)var1_1, (CachePolicy)this.cachePolicies().head(), (int)var2_2), (Function2<EitherT, EitherT, EitherT> & Serializable)(x$15, x$16) -> {
            FileCache fileCache;
            void var2_2;
            return x$15.orElse(() -> FileCache.$anonfun$file$3((EitherT)var2_2), fileCache.sync());
        });
    }

    private int filePerPolicy$default$3() {
        return this.retry();
    }

    /*
     * WARNING - void declaration
     */
    private EitherT<F, String, String> fetchPerPolicy(Artifact artifact, CachePolicy policy) {
        void var3_6;
        void var1_4;
        void var2_5;
        artifact = ((Artifact)artifact).url().endsWith("/.links") ? new Tuple2<Artifact, Boolean>(((Artifact)artifact).withUrl(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((Artifact)artifact).url()), ".links")), BoxesRunTime.boxToBoolean(true)) : new Tuple2<Artifact, Boolean>((Artifact)artifact, BoxesRunTime.boxToBoolean(false));
        Artifact artifact0 = (Artifact)((Tuple2)artifact)._1();
        boolean links22 = ((Tuple2)artifact)._2$mcZ$sp();
        Tuple2<Artifact, Boolean> links22 = new Tuple2<Artifact, Boolean>(artifact0, BoxesRunTime.boxToBoolean(links22));
        artifact0 = links22._1();
        boolean links = links22._2$mcZ$sp();
        return this.filePerPolicy(artifact0, (CachePolicy)var2_5, this.filePerPolicy$default$3()).leftMap((Function1<ArtifactError, String> & Serializable)x$18 -> x$18.describe(), this.sync()).flatMap(arg_0 -> FileCache.$anonfun$fetchPerPolicy$2(this, (boolean)var1_4, (Artifact)var3_6, arg_0), this.sync());
    }

    @Override
    public final Function1<Artifact, EitherT<F, String, String>> fetch() {
        return (Function1<Artifact, EitherT> & Serializable)a -> {
            void var1_1;
            FileCache fileCache;
            return ((IterableOnceOps)this.cachePolicies().tail()).foldLeft(this.fetchPerPolicy((Artifact)a, (CachePolicy)this.cachePolicies().head()), (arg_0, arg_1) -> FileCache.$anonfun$fetch$2(fileCache, (Artifact)var1_1, arg_0, arg_1));
        };
    }

    @Override
    public final Seq<Function1<Artifact, EitherT<F, String, String>>> fetchs() {
        return (Seq)this.cachePolicies().map((Function1<CachePolicy, Function1> & Serializable)p -> {
            void var1_1;
            return arg_0 -> FileCache.$anonfun$fetchs$2(this, (CachePolicy)var1_1, arg_0);
        });
    }

    private ExecutionContextExecutorService ec$lzycompute() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(this.pool());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.ec;
    }

    @Override
    public final ExecutionContextExecutorService ec() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.ec$lzycompute();
        }
        return this.ec;
    }

    /*
     * WARNING - void declaration
     */
    public final FileCache<F> withCredentials(Seq<Credentials> credentials) {
        void var1_1;
        return new FileCache<F>(this.location(), this.cachePolicies(), this.checksums(), (Seq<Credentials>)var1_1, this.logger(), this.pool(), this.ttl(), this.localArtifactsShouldBeCached(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.maxRedirections(), this.sslRetry(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.retry(), this.bufferSize(), this.classLoaders(), this.clock(), this.retryBackoffInitialDelay(), this.retryBackoffMultiplier(), this.sync());
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder b = new StringBuilder("FileCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cachePolicies()));
        b.append(", ");
        b.append(String.valueOf(this.checksums()));
        b.append(", ");
        b.append(String.valueOf(this.credentials()));
        b.append(", ");
        b.append(String.valueOf(this.logger()));
        b.append(", ");
        b.append(String.valueOf(this.pool()));
        b.append(", ");
        b.append(String.valueOf(this.ttl()));
        b.append(", ");
        b.append(String.valueOf(this.localArtifactsShouldBeCached()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpToHttpsRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpsToHttpRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.maxRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.sslRetry()));
        b.append(", ");
        b.append(String.valueOf(this.sslSocketFactoryOpt()));
        b.append(", ");
        b.append(String.valueOf(this.hostnameVerifierOpt()));
        b.append(", ");
        b.append(String.valueOf(this.retry()));
        b.append(", ");
        b.append(String.valueOf(this.bufferSize()));
        b.append(", ");
        b.append(String.valueOf(this.classLoaders()));
        b.append(", ");
        b.append(String.valueOf(this.clock()));
        b.append(", ");
        b.append(String.valueOf(this.retryBackoffInitialDelay()));
        b.append(", ");
        b.append(String.valueOf(this.retryBackoffMultiplier()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canEqual(Object obj) {
        void var1_1;
        return obj != null && var1_1 instanceof FileCache;
    }

    public final boolean equals(Object obj) {
        block3: {
            block2: {
                Sync<F> sync;
                if (this == obj) break block2;
                if (!this.canEqual(obj)) break block3;
                FileCache other = (FileCache)obj;
                File file = this.location();
                Object object = other.location();
                if (file != null ? !((Object)file).equals(object) : object != null) break block3;
                Seq<CachePolicy> seq = this.cachePolicies();
                object = other.cachePolicies();
                if (seq != null ? !seq.equals(object) : object != null) break block3;
                Seq<Option<String>> seq2 = this.checksums();
                object = other.checksums();
                if (seq2 != null ? !seq2.equals(object) : object != null) break block3;
                Seq<Credentials> seq3 = this.credentials();
                object = other.credentials();
                if (seq3 != null ? !seq3.equals(object) : object != null) break block3;
                CacheLogger cacheLogger = this.logger();
                object = other.logger();
                if (cacheLogger != null ? !cacheLogger.equals(object) : object != null) break block3;
                ExecutorService executorService = this.pool();
                object = other.pool();
                if (executorService != null ? !executorService.equals(object) : object != null) break block3;
                Option<Duration> option = this.ttl();
                object = other.ttl();
                if (option != null ? !option.equals(object) : object != null) break block3;
                if (this.localArtifactsShouldBeCached() != other.localArtifactsShouldBeCached() || this.followHttpToHttpsRedirections() != other.followHttpToHttpsRedirections() || this.followHttpsToHttpRedirections() != other.followHttpsToHttpRedirections()) break block3;
                Option<Object> option2 = this.maxRedirections();
                object = other.maxRedirections();
                if ((option2 != null ? !option2.equals(object) : object != null) || this.sslRetry() != other.sslRetry()) break block3;
                Option<SSLSocketFactory> option3 = this.sslSocketFactoryOpt();
                object = other.sslSocketFactoryOpt();
                if (option3 != null ? !option3.equals(object) : object != null) break block3;
                Option<HostnameVerifier> option4 = this.hostnameVerifierOpt();
                object = other.hostnameVerifierOpt();
                if (option4 != null ? !option4.equals(object) : object != null) break block3;
                if (this.retry() != other.retry() || this.bufferSize() != other.bufferSize()) break block3;
                Seq<ClassLoader> seq4 = this.classLoaders();
                object = other.classLoaders();
                if (seq4 != null ? !seq4.equals(object) : object != null) break block3;
                Clock clock = this.clock();
                object = other.clock();
                if (clock != null ? !((Object)clock).equals(object) : object != null) break block3;
                FiniteDuration finiteDuration = this.retryBackoffInitialDelay();
                object = other.retryBackoffInitialDelay();
                if ((finiteDuration != null ? !((Object)finiteDuration).equals(object) : object != null) || this.retryBackoffMultiplier() != other.retryBackoffMultiplier()) break block3;
                Sync<F> sync2 = this.sync();
                sync = ((FileCache)((Object)sync)).sync();
                if (sync2 != null ? !sync2.equals(sync) : sync != null) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int code = 17 + Statics.anyHash("FileCache");
        code = code * 37 + Statics.anyHash(this.location());
        code = code * 37 + Statics.anyHash(this.cachePolicies());
        code = code * 37 + Statics.anyHash(this.checksums());
        code = code * 37 + Statics.anyHash(this.credentials());
        code = code * 37 + Statics.anyHash(this.logger());
        code = code * 37 + Statics.anyHash(this.pool());
        code = code * 37 + Statics.anyHash(this.ttl());
        code = code * 37 + (this.localArtifactsShouldBeCached() ? 1231 : 1237);
        code = code * 37 + (this.followHttpToHttpsRedirections() ? 1231 : 1237);
        code = code * 37 + (this.followHttpsToHttpRedirections() ? 1231 : 1237);
        code = code * 37 + Statics.anyHash(this.maxRedirections());
        code = code * 37 + this.sslRetry();
        code = code * 37 + Statics.anyHash(this.sslSocketFactoryOpt());
        code = code * 37 + Statics.anyHash(this.hostnameVerifierOpt());
        code = code * 37 + this.retry();
        code = code * 37 + this.bufferSize();
        code = code * 37 + Statics.anyHash(this.classLoaders());
        code = code * 37 + Statics.anyHash(this.clock());
        code = code * 37 + Statics.anyHash(this.retryBackoffInitialDelay());
        code = code * 37 + Statics.doubleHash(this.retryBackoffMultiplier());
        code = code * 37 + Statics.anyHash(this.sync());
        return (int)(var1_1 * 37);
    }

    @Override
    public final String productPrefix() {
        return "FileCache";
    }

    @Override
    public final int productArity() {
        return 21;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object productElement(int n) {
        void var1_1;
        switch (n) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cachePolicies();
            }
            case 2: {
                return this.checksums();
            }
            case 3: {
                return this.credentials();
            }
            case 4: {
                return this.logger();
            }
            case 5: {
                return this.pool();
            }
            case 6: {
                return this.ttl();
            }
            case 7: {
                return BoxesRunTime.boxToBoolean(this.localArtifactsShouldBeCached());
            }
            case 8: {
                return BoxesRunTime.boxToBoolean(this.followHttpToHttpsRedirections());
            }
            case 9: {
                return BoxesRunTime.boxToBoolean(this.followHttpsToHttpRedirections());
            }
            case 10: {
                return this.maxRedirections();
            }
            case 11: {
                return BoxesRunTime.boxToInteger(this.sslRetry());
            }
            case 12: {
                return this.sslSocketFactoryOpt();
            }
            case 13: {
                return this.hostnameVerifierOpt();
            }
            case 14: {
                return BoxesRunTime.boxToInteger(this.retry());
            }
            case 15: {
                return BoxesRunTime.boxToInteger(this.bufferSize());
            }
            case 16: {
                return this.classLoaders();
            }
            case 17: {
                return this.clock();
            }
            case 18: {
                return this.retryBackoffInitialDelay();
            }
            case 19: {
                return BoxesRunTime.boxToDouble(this.retryBackoffMultiplier());
            }
            case 20: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString((int)var1_1));
    }

    public static final /* synthetic */ byte[] $anonfun$readAllBytes$1(Path path$1) {
        return Files.readAllBytes(path$1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$validateChecksum$4(FileCache $this, Seq headerSumFile$1, Option downloadedSumFile$1, String sumType$1, File localFile0$1) {
        void var1_1;
        if ((headerSumFile$1 = ((IterableOnceOps)headerSumFile$1.$plus$plus(Option$.MODULE$.option2Iterable(downloadedSumFile$1).toSeq())).find((Function1<File, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.exists()))) instanceof Some) {
            void var2_2;
            headerSumFile$1 = (Some)headerSumFile$1;
            File sumFile = (File)((Some)headerSumFile$1).value();
            downloadedSumFile$1 = CacheChecksum$.MODULE$.parseRawChecksum($this.readAllBytes(sumFile.toPath()));
            if (None$.MODULE$.equals(downloadedSumFile$1)) {
                return new Left(new ArtifactError.ChecksumFormatError(sumType$1, sumFile.getPath()));
            }
            if (downloadedSumFile$1 instanceof Some) {
                Serializable calculatedSum;
                BigInteger sum = (BigInteger)(downloadedSumFile$1 = (Some)downloadedSumFile$1).value();
                if (BoxesRunTime.equalsNumNum(sum, (Number)(calculatedSum = FileCache$.MODULE$.coursier$cache$FileCache$$persistedDigest($this.location(), sumType$1, localFile0$1, $this.retry0())))) {
                    return new Right(BoxedUnit.UNIT);
                }
                return new Left(new ArtifactError.WrongChecksum(sumType$1, ((BigInteger)calculatedSum).toString(16), var2_2.toString(16), localFile0$1.getPath(), var1_1.getPath()));
            }
            throw new MatchError(var2_2);
        }
        if (None$.MODULE$.equals(var1_1)) {
            Serializable serializable;
            void var3_3;
            Serializable err = new ArtifactError.ChecksumNotFound((String)var3_3, localFile0$1.getPath());
            return new Left((FileCache)serializable);
        }
        throw new MatchError(var1_1);
    }

    public static final /* synthetic */ boolean $anonfun$filePerPolicy$2(Artifact artifact$2, DirectCredentials x$6) {
        Artifact artifact;
        return x$6.autoMatches(artifact.url(), None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$filePerPolicy$5(FileCache $this, CachePolicy policy$1, int retry$1, Artifact a) {
        void var2_2;
        void var1_1;
        void var3_3;
        return $this.filePerPolicy0((Artifact)var3_3, (CachePolicy)var1_1, (int)var2_2);
    }

    public static final /* synthetic */ boolean $anonfun$filePerPolicy0$5(char x$9) {
        return x$9 != '-';
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$filePerPolicy0$3(Artifact artifact$3, Map resultsMap$1, Option x0$2) {
        void var2_2;
        if (None$.MODULE$.equals(x0$2)) {
            return None$.MODULE$;
        }
        if (x0$2 instanceof Some) {
            String string;
            void var1_1;
            x0$2 = (Some)x0$2;
            String c = (String)((Some)x0$2).value();
            String url = (String)artifact$3.checksumUrls().getOrElse(c, (Function0<String> & Serializable)() -> {
                void var1_1;
                Artifact artifact;
                return new StringBuilder(1).append(artifact.url()).append(".").append(StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(var1_1.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(FileCache.$anonfun$filePerPolicy0$5(BoxesRunTime.unboxToChar(x$9))))).toString();
            });
            return new Some(new Tuple3(var2_2, url, var1_1.get(string)));
        }
        throw new MatchError(var2_2);
    }

    private static final Seq checksumErrors$1(Seq checksumResults$1) {
        return (Seq)checksumResults$1.collect(new Serializable(null){

            /*
             * WARNING - void declaration
             */
            public final <A1 extends Option<Tuple3<String, String, Option<Option<ArtifactError>>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var2_2;
                void var1_1;
                Product product;
                boolean bl = false;
                Some some = null;
                Object object = x1;
                if (object instanceof Some) {
                    bl = true;
                    some = (Some)object;
                    if ((object = (Tuple3)some.value()) != null) {
                        String c = (String)((Tuple3)object)._1();
                        String url = (String)((Tuple3)object)._2();
                        if (None$.MODULE$.equals(object = (Option)((Tuple3)object)._3())) {
                            return (B1)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), new StringBuilder(15).append(url).append(" not downloaded").toString());
                        }
                    }
                }
                if (bl && (product = (Tuple3)some.value()) != null) {
                    String c = (String)product._1();
                    if ((product = (Option)product._3()) instanceof Some) {
                        product = (Some)product;
                        if ((product = (Option)((Some)product).value()) instanceof Some) {
                            x1 = (Some)product;
                            ArtifactError e = (ArtifactError)((Some)x1).value();
                            return (B1)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(c), var1_1.describe());
                        }
                    }
                }
                return (B1)var2_2.apply(var1_1);
            }

            public final boolean isDefinedAt(Option<Tuple3<String, String, Option<Option<ArtifactError>>>> x1) {
                Product product;
                boolean bl = false;
                Some some = null;
                if (product instanceof Some) {
                    bl = true;
                    some = (Some)product;
                    if ((product = (Tuple3)some.value()) != null && None$.MODULE$.equals(product = (Option)product._3())) {
                        return true;
                    }
                }
                if (bl && (product = (Tuple3)some.value()) != null && (product = (Option)product._3()) instanceof Some) {
                    product = (Some)product;
                    if ((product = (Option)((Some)product).value()) instanceof Some) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$filePerPolicy0$7(Option checksum$1, DownloadResult res$1, Seq checksumResults$1, BoxedUnit x$10) {
        Option option;
        if (None$.MODULE$.equals(checksum$1)) {
            void var2_2;
            return new Left(new ArtifactError.ChecksumErrors(FileCache.checksumErrors$1((Seq)var2_2)));
        }
        if (checksum$1 instanceof Some) {
            void var1_1;
            checksum$1 = (Some)checksum$1;
            Option c = (Option)((Some)checksum$1).value();
            return new Right(new Tuple2<File, Option>(var1_1.file(), option));
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ File $anonfun$filePerPolicy0$9(File f$1, BoxedUnit x$11) {
        return f$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Right $anonfun$filePerPolicy0$12(FileCache $this, boolean foundBadFileInCache$1, File badFile$1, File badChecksumFile$1, Artifact artifact$3, ArtifactError.WrongChecksum x2$1) {
        FileCache fileCache;
        void var2_2;
        void var3_3;
        void var1_1;
        Predef$.MODULE$.assert((boolean)var1_1);
        badFile$1.delete();
        var3_3.delete();
        FileCache$.MODULE$.clearAuxiliaryFiles((File)var2_2);
        fileCache.logger().removedCorruptFile(artifact$3.url(), new Some<String>(x2$1.describe()));
        return new Right(BoxedUnit.UNIT);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$filePerPolicy0$10(FileCache $this, Artifact artifact$3, int retry$2, CachePolicy policy$2, ArtifactError x0$4) {
        FileCache fileCache;
        ArtifactError artifactError = x0$4;
        if (artifactError instanceof ArtifactError.WrongChecksum) {
            boolean foundBadFileInCache;
            artifactError = (ArtifactError.WrongChecksum)artifactError;
            File badFile = $this.localFile(artifact$3.url(), artifact$3.authentication().map((Function1<Authentication, String> & Serializable)x$12 -> x$12.user()));
            File badChecksumFile = new File(((ArtifactError.WrongChecksum)artifactError).sumFile());
            String location0 = new StringBuilder(0).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString($this.location().getCanonicalPath()), File.separator)).append(File.separator).toString();
            boolean bl = foundBadFileInCache = badFile.getCanonicalPath().startsWith(location0) && badChecksumFile.getCanonicalPath().startsWith(location0);
            if (retry$2 <= 0 || !foundBadFileInCache) {
                return new EitherT($this.S().point(new Left(artifactError)));
            }
            return new EitherT($this.S().schedule($this.pool(), () -> FileCache.$anonfun$filePerPolicy0$12($this, true, badFile, badChecksumFile, artifact$3, (ArtifactError.WrongChecksum)artifactError))).flatMap((Function1<BoxedUnit, EitherT> & Serializable)x$13 -> {
                void var3_3;
                void var2_2;
                void var1_1;
                return $this.filePerPolicy0((Artifact)var1_1, (CachePolicy)var2_2, (int)(var3_3 - true));
            }, $this.sync());
        }
        if (artifactError instanceof ArtifactError.ChecksumNotFound) {
            void var2_2;
            void var3_3;
            void var1_1;
            artifactError = (ArtifactError.ChecksumNotFound)artifactError;
            if (retry$2 <= 0) {
                return new EitherT($this.S().point(new Left(artifactError)));
            }
            return $this.filePerPolicy0((Artifact)var1_1, (CachePolicy)var3_3, (int)(var2_2 - true));
        }
        return new EitherT(fileCache.S().point(new Left(artifactError)));
    }

    public static final /* synthetic */ EitherT $anonfun$file$3(EitherT x$16$1) {
        return x$16$1;
    }

    private static final Left notFound$1(File f) {
        File file;
        return new Left(new StringBuilder(10).append(file.getCanonicalPath()).append(" not found").toString());
    }

    /*
     * WARNING - void declaration
     */
    private final Either read$1(File f, boolean links$1, Artifact artifact0$1) {
        Throwable throwable;
        try {
            void var2_3;
            String string;
            if (links$1) {
                File linkFile = FileCache$.MODULE$.auxiliaryFile(f, "links");
                String string2 = f.getName();
                String string3 = ".directory";
                string = string2 != null && string2.equals(string3) && linkFile.isFile() ? new String(this.readAllBytes(linkFile.toPath()), StandardCharsets.UTF_8) : WebPage$.MODULE$.listElements(((Artifact)((Object)throwable)).url(), new String(this.readAllBytes(f.toPath()), StandardCharsets.UTF_8)).mkString("\n");
            } else {
                string = new String(this.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
            }
            String content = string;
            return new Right(var2_3);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throwable = throwable2;
            if (NonFatal$.MODULE$.apply(throwable)) {
                void var1_1;
                return new Left(new StringBuilder(24).append("Could not read (file:").append(var1_1.getCanonicalPath()).append("): ").append(throwable.getMessage()).toString());
            }
            throw throwable3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$fetchPerPolicy$2(FileCache $this, boolean links$1, Artifact artifact0$1, File f) {
        void var1_2;
        FileCache fileCache;
        Either either;
        if (f.exists()) {
            void content2;
            if (f.isDirectory()) {
                if (artifact0$1.url().startsWith("file:")) {
                    String string;
                    if (links$1) {
                        string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(f.listFiles()), (Function1<File, String> & Serializable)c -> {
                            void var1_1;
                            File file;
                            String name = c.getName();
                            if (file.isDirectory()) {
                                return new StringBuilder(1).append(name).append("/").toString();
                            }
                            return var1_1;
                        }, ClassTag$.MODULE$.apply(String.class))), Ordering$String$.MODULE$)).mkString("\n");
                    } else {
                        String elements = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(f.listFiles()), (Function1<File, String> & Serializable)c -> {
                            void var1_1;
                            File file;
                            String name = c.getName();
                            if (file.isDirectory()) {
                                return new StringBuilder(1).append(name).append("/").toString();
                            }
                            return var1_1;
                        }, ClassTag$.MODULE$.apply(String.class))), Ordering$String$.MODULE$)), (Function1<String, String> & Serializable)name0 -> {
                            String string;
                            return new StringBuilder(24).append("<li><a href=\"").append((String)name0).append("\">").append(string).append("</a></li>").toString();
                        }, ClassTag$.MODULE$.apply(String.class))).mkString();
                        string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(265).append("<!DOCTYPE html>\n                     |<html>\n                     |<head></head>\n                     |<body>\n                     |<ul>\n                     |").append(elements).append("\n                     |</ul>\n                     |</body>\n                     |</html>\n                 ").toString()));
                    }
                    String content2 = string;
                    either = new Right(content2);
                } else {
                    File f0 = new File(f, ".directory");
                    either = f0.exists() ? (f0.isDirectory() ? new Left(new StringBuilder(22).append("Woops: ").append(f.getCanonicalPath()).append(" is a directory").toString()) : $this.read$1(f0, (boolean)content2, artifact0$1)) : FileCache.notFound$1(f0);
                }
            } else {
                void var2_3;
                either = $this.read$1(f, (boolean)content2, (Artifact)var2_3);
            }
        } else {
            void var3_4;
            either = FileCache.notFound$1((File)var3_4);
        }
        Left res = either;
        return new EitherT(fileCache.S().point(var1_2));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$fetch$3(FileCache $this, Artifact a$1, CachePolicy x$20$1) {
        void var2_2;
        void var1_1;
        return $this.fetchPerPolicy((Artifact)var1_1, (CachePolicy)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$fetch$2(FileCache $this, Artifact a$1, EitherT x$19, CachePolicy x$20) {
        FileCache fileCache;
        void var3_3;
        void var1_1;
        return x$19.orElse(() -> FileCache.$anonfun$fetch$3($this, (Artifact)var1_1, (CachePolicy)var3_3), fileCache.sync());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ EitherT $anonfun$fetchs$2(FileCache $this, CachePolicy p$1, Artifact a) {
        void var1_1;
        void var2_2;
        return $this.fetchPerPolicy((Artifact)var2_2, (CachePolicy)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public FileCache(File location, Seq<CachePolicy> cachePolicies, Seq<Option<String>> checksums, Seq<Credentials> credentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int retry, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, FiniteDuration retryBackoffInitialDelay2, double retryBackoffMultiplier, Sync<F> sync) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.location = var1_1;
        this.cachePolicies = var2_2;
        this.checksums = checksums;
        this.credentials = credentials;
        this.logger = logger;
        this.pool = pool;
        this.ttl = ttl;
        this.localArtifactsShouldBeCached = localArtifactsShouldBeCached;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.followHttpsToHttpRedirections = followHttpsToHttpRedirections;
        this.maxRedirections = maxRedirections;
        this.sslRetry = sslRetry;
        this.sslSocketFactoryOpt = sslSocketFactoryOpt;
        this.hostnameVerifierOpt = hostnameVerifierOpt;
        this.retry = retry;
        this.bufferSize = bufferSize;
        this.classLoaders = classLoaders;
        this.clock = clock;
        this.retryBackoffInitialDelay = retryBackoffInitialDelay2;
        this.retryBackoffMultiplier = retryBackoffMultiplier;
        this.sync = sync;
        Product.$init$(this);
        this.retry0 = new Retry(retry, retryBackoffInitialDelay2, retryBackoffMultiplier);
        this.checksums0 = checksums.isEmpty() ? new $colon$colon<Nothing$>((Nothing$)((Object)None$.MODULE$), Nil$.MODULE$) : var3_3;
        this.actualChecksums = (Seq)((SeqOps)this.checksums0().flatMap((Function1<Option, Seq> & Serializable)x$2 -> {
            Option option;
            return Option$.MODULE$.option2Iterable(option).toSeq();
        })).distinct();
    }
}

