/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.AnyDiscriminatorSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.PathHelper;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class AnyMappingSqmPathSource<J>
extends AbstractSqmPathSource<J> {
    private final SqmPathSource<?> keyPathSource;
    private final AnyDiscriminatorSqmPathSource<?> discriminatorPathSource;

    public AnyMappingSqmPathSource(String localPathName, SqmPathSource<J> pathModel, AnyMappingDomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        super(localPathName, pathModel, domainType, jpaBindableType);
        this.keyPathSource = new BasicSqmPathSource("{key}", null, (BasicDomainType)domainType.getKeyType(), domainType.getKeyType().getExpressibleJavaType(), Bindable.BindableType.SINGULAR_ATTRIBUTE, false);
        this.discriminatorPathSource = new AnyDiscriminatorSqmPathSource(localPathName, null, domainType.getDiscriminatorType(), jpaBindableType);
    }

    @Override
    public AnyMappingDomainType<J> getSqmPathType() {
        return (AnyMappingDomainType)super.getSqmPathType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        switch (name) {
            case "id": 
            case "{key}": {
                return this.keyPathSource;
            }
            case "class": 
            case "{discriminator}": {
                return this.discriminatorPathSource;
            }
        }
        throw new UnsupportedMappingException("Only the key and discriminator parts of an '@Any' mapping may be dereferenced");
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        return new SqmAnyValuedSimplePath(PathHelper.append(lhs, this, intermediatePathSource), this.pathModel, lhs, lhs.nodeBuilder());
    }
}

