/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.si.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jxmpp.util.XmppDateTime;

public class StreamInitiationProvider
extends IQProvider<StreamInitiation> {
    private static final Logger LOGGER = Logger.getLogger(StreamInitiationProvider.class.getName());

    @Override
    public StreamInitiation parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        String id = parser2.getAttributeValue("", "id");
        String mimeType = parser2.getAttributeValue("", "mime-type");
        StreamInitiation initiation = new StreamInitiation();
        String name = null;
        String size = null;
        String hash = null;
        String date = null;
        String desc = null;
        boolean isRanged = false;
        DataForm form = null;
        DataFormProvider dataFormProvider = new DataFormProvider();
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser2.next()) == XmlPullParser.Event.START_ELEMENT) {
                String elementName = parser2.getName();
                String namespace = parser2.getNamespace();
                if (elementName.equals("file")) {
                    name = parser2.getAttributeValue("", "name");
                    size = parser2.getAttributeValue("", "size");
                    hash = parser2.getAttributeValue("", "hash");
                    date = parser2.getAttributeValue("", "date");
                    continue;
                }
                if (elementName.equals("desc")) {
                    desc = parser2.nextText();
                    continue;
                }
                if (elementName.equals("range")) {
                    isRanged = true;
                    continue;
                }
                if (!elementName.equals("x") || !namespace.equals("jabber:x:data")) continue;
                form = (DataForm)dataFormProvider.parse(parser2);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT) continue;
            if (parser2.getDepth() == initialDepth) break;
            if (!parser2.getName().equals("file")) continue;
            long fileSize = 0L;
            if (size != null && size.trim().length() != 0) {
                try {
                    fileSize = Long.parseLong(size);
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.SEVERE, "Failed to parse file size from " + fileSize, e);
                }
            }
            Date fileDate = new Date();
            if (date != null) {
                try {
                    fileDate = XmppDateTime.parseDate(date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            StreamInitiation.File file = new StreamInitiation.File(name, fileSize);
            file.setHash(hash);
            file.setDate(fileDate);
            file.setDesc(desc);
            file.setRanged(isRanged);
            initiation.setFile(file);
        }
        initiation.setSessionID(id);
        initiation.setMimeType(mimeType);
        initiation.setFeatureNegotiationForm(form);
        return initiation;
    }
}

