/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingle;

import java.io.IOException;
import java.util.List;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class GroupPacketExtension
extends AbstractPacketExtension {
    public static final String ELEMENT = "group";
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:grouping:0";
    public static final String SEMANTICS_ATTR_NAME = "semantics";
    public static final String SEMANTICS_BUNDLE = "BUNDLE";

    public GroupPacketExtension() {
        super(NAMESPACE, ELEMENT);
    }

    public static GroupPacketExtension createBundleGroup(List<ContentPacketExtension> contents) {
        GroupPacketExtension group = new GroupPacketExtension();
        group.setSemantics(SEMANTICS_BUNDLE);
        group.addContents(contents);
        return group;
    }

    public String getSemantics() {
        return this.getAttributeAsString(SEMANTICS_ATTR_NAME);
    }

    public void setSemantics(String semantics) {
        this.setAttribute(SEMANTICS_ATTR_NAME, semantics);
    }

    public List<ContentPacketExtension> getContents() {
        return this.getChildExtensionsOfType(ContentPacketExtension.class);
    }

    public void addContents(List<ContentPacketExtension> contents) {
        for (ContentPacketExtension content2 : contents) {
            ContentPacketExtension copy2 = new ContentPacketExtension();
            copy2.setName(content2.getName());
            this.addChildExtension(copy2);
        }
    }

    public static GroupPacketExtension parseExtension(XmlPullParser parser, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        GroupPacketExtension group = new GroupPacketExtension();
        String semantics = parser.getAttributeValue("", SEMANTICS_ATTR_NAME);
        if (semantics != null) {
            group.setSemantics(semantics);
        }
        boolean done = false;
        DefaultPacketExtensionProvider<ContentPacketExtension> contentProvider = new DefaultPacketExtensionProvider<ContentPacketExtension>(ContentPacketExtension.class);
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String elementName = parser.getName();
            if (elementName.equals("content")) {
                ContentPacketExtension content2 = (ContentPacketExtension)contentProvider.parse(parser, xmlEnvironment);
                group.addChildExtension(content2);
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals(ELEMENT)) continue;
            done = true;
        }
        return group;
    }
}

