/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.debugger.impl.shared.actions;

import com.intellij.java.debugger.impl.shared.rpc.JavaThreadDumpItemDto;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.unscramble.DumpItem;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001Bf\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0011\u0010\t\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\u0005\u0012\u0011\u0010\f\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\u0005\u0012\u0013\u0010\r\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000e0\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0014\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0013\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0019\u0010\u0018\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u001b\u0010\u001a\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006/"}, d2={"Lcom/intellij/java/debugger/impl/shared/actions/FrontendDumpItem;", "Lcom/intellij/unscramble/DumpItem;", "itemDto", "Lcom/intellij/java/debugger/impl/shared/rpc/JavaThreadDumpItemDto;", "iconsCache", "", "Ljavax/swing/Icon;", "attributesCache", "Lcom/intellij/ui/SimpleTextAttributes;", "stackTracesCache", "", "Lcom/intellij/openapi/util/NlsSafe;", "stateDescriptionsCache", "iconToolTipsCache", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/java/debugger/impl/shared/rpc/JavaThreadDumpItemDto;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "internalAwaitingItems", "", "name", "getName", "()Ljava/lang/String;", "stateDesc", "getStateDesc", "stackTrace", "getStackTrace", "iconToolTip", "getIconToolTip", "interestLevel", "", "getInterestLevel", "()I", "icon", "getIcon", "()Ljavax/swing/Icon;", "attributes", "getAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "isDeadLocked", "", "()Z", "awaitingDumpItems", "getAwaitingDumpItems", "()Ljava/util/Set;", "setAwaitingItems", "", "items", "intellij.java.debugger.impl.shared"})
final class FrontendDumpItem
implements DumpItem {
    @NotNull
    private final JavaThreadDumpItemDto itemDto;
    @NotNull
    private final List<Icon> iconsCache;
    @NotNull
    private final List<SimpleTextAttributes> attributesCache;
    @NotNull
    private final List<String> stackTracesCache;
    @NotNull
    private final List<String> stateDescriptionsCache;
    @NotNull
    private final List<String> iconToolTipsCache;
    @NotNull
    private Set<? extends DumpItem> internalAwaitingItems;

    public FrontendDumpItem(@NotNull JavaThreadDumpItemDto itemDto, @NotNull List<? extends Icon> iconsCache, @NotNull List<SimpleTextAttributes> attributesCache, @NotNull List<String> stackTracesCache, @NotNull List<String> stateDescriptionsCache, @NotNull List<String> iconToolTipsCache) {
        Intrinsics.checkNotNullParameter((Object)itemDto, (String)"itemDto");
        Intrinsics.checkNotNullParameter(iconsCache, (String)"iconsCache");
        Intrinsics.checkNotNullParameter(attributesCache, (String)"attributesCache");
        Intrinsics.checkNotNullParameter(stackTracesCache, (String)"stackTracesCache");
        Intrinsics.checkNotNullParameter(stateDescriptionsCache, (String)"stateDescriptionsCache");
        Intrinsics.checkNotNullParameter(iconToolTipsCache, (String)"iconToolTipsCache");
        this.itemDto = itemDto;
        this.iconsCache = iconsCache;
        this.attributesCache = attributesCache;
        this.stackTracesCache = stackTracesCache;
        this.stateDescriptionsCache = stateDescriptionsCache;
        this.iconToolTipsCache = iconToolTipsCache;
        this.internalAwaitingItems = SetsKt.emptySet();
    }

    @Override
    @NotNull
    public String getName() {
        return this.itemDto.getName();
    }

    @Override
    @NotNull
    public String getStateDesc() {
        return this.stateDescriptionsCache.get(this.itemDto.getStateDescriptionIndex());
    }

    @Override
    @NotNull
    public String getStackTrace() {
        return this.itemDto.getFirstLine() + "\n" + this.stackTracesCache.get(this.itemDto.getStackTraceIndex());
    }

    @Override
    @Nullable
    public String getIconToolTip() {
        return this.iconToolTipsCache.get(UInt.constructor-impl((int)this.itemDto.getIconToolTipIndex()));
    }

    @Override
    public int getInterestLevel() {
        return this.itemDto.getInterestLevel();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.iconsCache.get(UInt.constructor-impl((int)this.itemDto.getIconIndex()));
    }

    @Override
    @NotNull
    public SimpleTextAttributes getAttributes() {
        return this.attributesCache.get(UInt.constructor-impl((int)this.itemDto.getAttributesIndex()));
    }

    @Override
    public boolean isDeadLocked() {
        return this.itemDto.isDeadLocked();
    }

    @Override
    @NotNull
    public Set<DumpItem> getAwaitingDumpItems() {
        return this.internalAwaitingItems;
    }

    public final void setAwaitingItems(@NotNull Set<? extends DumpItem> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.internalAwaitingItems = items;
    }
}

