/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.AfterSemicolonEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingMethodBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            MissingMethodBodyFixer.$$$reportNull$$$0(0);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_FIELD)) {
            if (BasicJavaAstTreeUtil.getInitializer(astNode) != null) {
                return;
            }
            ASTNode lastChild = astNode.getLastChildNode();
            PsiElement psiElement = BasicJavaAstTreeUtil.toPsi(lastChild);
            if (!(psiElement instanceof PsiErrorElement)) {
                return;
            }
            if (!((PsiErrorElement)psiElement).getErrorDescription().equals(JavaPsiBundle.message("expected.semicolon", new Object[0]))) {
                return;
            }
            if (BasicJavaAstTreeUtil.hasModifierProperty(astNode, JavaTokenType.TRANSIENT_KEYWORD) || BasicJavaAstTreeUtil.hasModifierProperty(astNode, JavaTokenType.VOLATILE_KEYWORD)) {
                return;
            }
            ASTNode typeElement = BasicJavaAstTreeUtil.getTypeElement(astNode);
            if (typeElement == null || !typeElement.getText().equals("void")) {
                return;
            }
            int endOffset = astNode.getTextRange().getEndOffset();
            editor.getDocument().insertString(endOffset, (CharSequence)"()");
            editor.getDocument().insertString(endOffset + 2, (CharSequence)"{}");
            editor.getCaretModel().moveToOffset(endOffset + 1);
            processor.registerUnresolvedError(endOffset + 1);
            processor.setSkipEnter(true);
            return;
        }
        if (!BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_METHOD)) {
            return;
        }
        if (!MissingMethodBodyFixer.shouldMethodHaveBody(BasicJavaAstTreeUtil.toPsi(astNode))) {
            return;
        }
        ASTNode body = BasicJavaAstTreeUtil.getCodeBlock(astNode);
        Document doc = editor.getDocument();
        if (body != null) {
            ASTNode containingClass;
            PsiElement psiElement;
            ASTNode statement;
            String bodyText = body.getText();
            if (bodyText.startsWith("{") && (statement = BasicJavaAstTreeUtil.findChildByType(body, BasicJavaElementType.STATEMENT_SET)) != null && BasicJavaAstTreeUtil.is(statement, BasicJavaElementType.BASIC_DECLARATION_STATEMENT) && (psiElement = BasicJavaAstTreeUtil.toPsi(statement)) != null && PsiTreeUtil.getDeepestLast((PsiElement)psiElement) instanceof PsiErrorElement && (containingClass = BasicJavaAstTreeUtil.getParentOfType(astNode, BasicJavaElementType.CLASS_SET)) != null && BasicJavaAstTreeUtil.getRBrace(containingClass) == null) {
                doc.insertString(body.getTextRange().getStartOffset() + 1, (CharSequence)"\n}");
            }
            return;
        }
        ASTNode throwList = BasicJavaAstTreeUtil.findChildByType(astNode, BasicJavaElementType.BASIC_THROWS_LIST);
        if (throwList != null) {
            int endOffset = throwList.getTextRange().getEndOffset();
            if (endOffset < doc.getTextLength() && doc.getCharsSequence().charAt(endOffset) == ';') {
                doc.deleteString(endOffset, endOffset + 1);
            }
            processor.insertBracesWithNewLine(editor, endOffset);
        }
    }

    private static boolean shouldMethodHaveBody(@Nullable PsiElement method) {
        return AfterSemicolonEnterProcessor.shouldHaveBody(BasicJavaAstTreeUtil.toNode(method));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/MissingMethodBodyFixer", "apply"));
    }
}

