/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RescaleOp;
import javax.swing.JComponent;

public class ImageUtils {
    public static BufferedImage createBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        BufferedImage result = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return result;
    }

    public static BufferedImage createGrayscaleImage(Image image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage result = new BufferedImage(width, height, 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        ColorConvertOp filter = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        return filter.filter(result, null);
    }

    public static BufferedImage createHalvedImage(Image image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int w = (width + 1) / 2;
        int h = (height + 1) / 2;
        BufferedImage result = new BufferedImage(w, h, 2);
        Graphics2D g2d = result.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(image, 0, 0, w, h, null);
        g2d.dispose();
        return result;
    }

    public static BufferedImage createMirroredImage(Image image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage result = new BufferedImage(width, height, 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(image, width, 0, -width, height, null);
        g2d.dispose();
        return result;
    }

    public static BufferedImage createResizedImage(Image image, int width, int height) {
        return ImageUtils.createResizedImage(image, width, height, false);
    }

    public static BufferedImage createResizedImage(Image image, int width, int height, boolean interpolation) {
        BufferedImage result = new BufferedImage(width, height, 2);
        Graphics2D g2d = result.createGraphics();
        if (interpolation) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        g2d.drawImage(image, 0, 0, width, height, null);
        g2d.dispose();
        return result;
    }

    public static void drawTiledImage(BufferedImage image, Graphics g, JComponent c, Insets insets) {
        int ymin;
        int xmin;
        int width = c.getWidth();
        int height = c.getHeight();
        if (insets == null) {
            xmin = 0;
            ymin = 0;
        } else {
            xmin = insets.left;
            ymin = insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (image != null) {
            int dx = image.getWidth();
            int dy = image.getHeight();
            int xmax = xmin + width;
            int ymax = ymin + height;
            for (int x = xmin; x < xmax; x += dx) {
                for (int y = ymin; y < ymax; y += dy) {
                    g.drawImage(image, x, y, null);
                }
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(xmin, ymin, width, height);
        }
    }

    public static void fillTexture(Graphics2D g2d, BufferedImage img, int x, int y, int width, int height) {
        Rectangle anchor = new Rectangle(x, y, img.getWidth(), img.getHeight());
        TexturePaint paint = new TexturePaint(img, anchor);
        g2d.setPaint(paint);
        g2d.fillRect(x, y, width, height);
    }

    public static BufferedImage createCenteredImage(BufferedImage image, Dimension size) {
        return ImageUtils.createCenteredImage(image, size.width, size.height);
    }

    public static BufferedImage createCenteredImage(BufferedImage image, int width, int height) {
        int x = (width - image.getWidth(null)) / 2;
        int y = (height - image.getHeight(null)) / 2;
        BufferedImage centeredImage = new BufferedImage(width, height, 2);
        Graphics2D g = centeredImage.createGraphics();
        g.drawImage((Image)image, x, y, null);
        g.dispose();
        return centeredImage;
    }

    public static Dimension wildcardDimension(Dimension d, Dimension nominal) {
        int w = nominal.width;
        int h = nominal.height;
        int wNew = d.width;
        int hNew = d.height;
        if (wNew <= 0 && hNew <= 0) {
            return nominal;
        }
        if (wNew <= 0 || hNew > 0 && wNew * h > hNew * w) {
            wNew = (2 * w * hNew + (h + 1)) / (2 * h);
        } else if (hNew <= 0 || wNew * h < hNew * w) {
            hNew = (2 * h * wNew + (w + 1)) / (2 * w);
        }
        return new Dimension(wNew, hNew);
    }

    public static BufferedImage fadeImage(Image img, float fade, float target) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        float offset = target * (1.0f - fade);
        float[] scales = new float[]{fade, fade, fade, 1.0f};
        float[] offsets = new float[]{offset, offset, offset, 0.0f};
        RescaleOp rop = new RescaleOp(scales, offsets, null);
        g.drawImage(bi, rop, 0, 0);
        g.dispose();
        return bi;
    }

    public static BufferedImage imageWithAlphaFromMask(BufferedImage image, BufferedImage mask) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(6, 1.0f));
        g2d.drawImage((Image)mask, 0, 0, null);
        g2d.dispose();
        return result;
    }
}

