/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RangeMerge {
    private final Path optExclusiveStart;
    private final Path optInclusiveEnd;
    private final Node snap;

    public RangeMerge(Path optExclusiveStart, Path optInclusiveEnd, Node snap) {
        this.optExclusiveStart = optExclusiveStart;
        this.optInclusiveEnd = optInclusiveEnd;
        this.snap = snap;
    }

    public RangeMerge(com.google.firebase.database.connection.RangeMerge rangeMerge) {
        List<String> optStartPathList = rangeMerge.getOptExclusiveStart();
        this.optExclusiveStart = optStartPathList != null ? new Path(optStartPathList) : null;
        List<String> optEndPathList = rangeMerge.getOptInclusiveEnd();
        this.optInclusiveEnd = optEndPathList != null ? new Path(optEndPathList) : null;
        this.snap = NodeUtilities.NodeFromJSON(rangeMerge.getSnap());
    }

    public Node applyTo(Node node) {
        return this.updateRangeInNode(Path.getEmptyPath(), node, this.snap);
    }

    Path getStart() {
        return this.optExclusiveStart;
    }

    Path getEnd() {
        return this.optInclusiveEnd;
    }

    private Node updateRangeInNode(Path currentPath, Node node, Node updateNode) {
        boolean endInNode;
        int startComparison = this.optExclusiveStart == null ? 1 : currentPath.compareTo(this.optExclusiveStart);
        int endComparison = this.optInclusiveEnd == null ? -1 : currentPath.compareTo(this.optInclusiveEnd);
        boolean startInNode = this.optExclusiveStart != null && currentPath.contains(this.optExclusiveStart);
        boolean bl = endInNode = this.optInclusiveEnd != null && currentPath.contains(this.optInclusiveEnd);
        if (startComparison > 0 && endComparison < 0 && !endInNode) {
            return updateNode;
        }
        if (startComparison > 0 && endInNode && updateNode.isLeafNode()) {
            return updateNode;
        }
        if (startComparison > 0 && endComparison == 0) {
            assert (endInNode);
            assert (!updateNode.isLeafNode());
            if (node.isLeafNode()) {
                return EmptyNode.Empty();
            }
            return node;
        }
        if (startInNode || endInNode) {
            HashSet<ChildKey> allChildren = new HashSet<ChildKey>();
            for (NamedNode child : node) {
                allChildren.add(child.getName());
            }
            for (NamedNode child : updateNode) {
                allChildren.add(child.getName());
            }
            ArrayList<ChildKey> inOrder = new ArrayList<ChildKey>(allChildren.size() + 1);
            inOrder.addAll(allChildren);
            if (!updateNode.getPriority().isEmpty() || !node.getPriority().isEmpty()) {
                inOrder.add(ChildKey.getPriorityKey());
            }
            Node newNode = node;
            for (ChildKey key : inOrder) {
                Node currentChild = node.getImmediateChild(key);
                Node updatedChild = this.updateRangeInNode(currentPath.child(key), node.getImmediateChild(key), updateNode.getImmediateChild(key));
                if (updatedChild == currentChild) continue;
                newNode = newNode.updateImmediateChild(key, updatedChild);
            }
            return newNode;
        }
        assert (endComparison > 0 || startComparison <= 0);
        return node;
    }

    public String toString() {
        return "RangeMerge{optExclusiveStart=" + this.optExclusiveStart + ", optInclusiveEnd=" + this.optInclusiveEnd + ", snap=" + this.snap + '}';
    }
}

