/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.core;

import com.codahale.metrics.Metric;
import java.util.regex.Matcher;
import org.apache.solr.common.SolrException;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.core.PrometheusCoreFormatterInfo;

public abstract class SolrCoreMetric
extends SolrMetric {
    public String coreName;

    public SolrCoreMetric(Metric dropwizardMetric, String coreName, String metricName, boolean cloudMode) {
        super(dropwizardMetric, metricName);
        this.coreName = coreName;
        this.labels.put("core", coreName);
        if (cloudMode) {
            this.appendCloudModeLabels();
        }
    }

    private void appendCloudModeLabels() {
        Matcher m = PrometheusCoreFormatterInfo.CLOUD_CORE_PATTERN.matcher(this.coreName);
        if (!m.find()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core name does not match pattern for parsing " + this.coreName);
        }
        this.labels.put("collection", m.group(1));
        this.labels.put("shard", m.group(2));
        this.labels.put("replica", m.group(3));
    }
}

