/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.manager.consumer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.solr.crossdc.common.MirroredSolrRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final ConcurrentHashMap<TopicPartition, PartitionWork> partitionWorkMap = new ConcurrentHashMap();
    private final KafkaConsumer<String, MirroredSolrRequest<?>> consumer;

    PartitionManager(KafkaConsumer<String, MirroredSolrRequest<?>> consumer) {
        this.consumer = consumer;
    }

    public PartitionWork getPartitionWork(TopicPartition partition) {
        return this.partitionWorkMap.compute(partition, (k, v) -> {
            if (v == null) {
                return new PartitionWork();
            }
            return v;
        });
    }

    public void checkOffsetUpdates() throws Throwable {
        for (TopicPartition partition : this.partitionWorkMap.keySet()) {
            this.checkForOffsetUpdates(partition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForOffsetUpdates(TopicPartition partition) throws Throwable {
        TopicPartition topicPartition = partition;
        synchronized (topicPartition) {
            WorkUnit workUnit;
            PartitionWork work = this.partitionWorkMap.get(partition);
            if (work != null && (workUnit = work.partitionQueue.peek()) != null) {
                boolean allFuturesDone = true;
                for (Future<?> future : workUnit.workItems) {
                    if (!future.isDone()) {
                        if (log.isTraceEnabled()) {
                            log.trace("Future for update is not done topic={}", (Object)partition.topic());
                        }
                        allFuturesDone = false;
                        break;
                    }
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        log.error("Error updating offset for partition: {}", (Object)partition, (Object)e);
                        throw e;
                    }
                    catch (ExecutionException e) {
                        log.error("Error updating offset for partition: {}", (Object)partition, (Object)e);
                        throw e.getCause();
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Future for update is done topic={}", (Object)partition.topic());
                }
                if (allFuturesDone) {
                    work.partitionQueue.poll();
                    this.updateOffset(partition, workUnit.nextOffset);
                }
            }
        }
    }

    private void resetOffsetForPartition(TopicPartition partition, List<ConsumerRecord<String, MirroredSolrRequest<?>>> partitionRecords) {
        if (log.isTraceEnabled()) {
            log.trace("Resetting offset to: {}", (Object)partitionRecords.get(0).offset());
        }
        long resetOffset = partitionRecords.get(0).offset();
        this.consumer.seek(partition, resetOffset);
    }

    private void updateOffset(TopicPartition partition, long nextOffset) {
        if (log.isTraceEnabled()) {
            log.trace("Updated offset for topic={} partition={} to offset={}", new Object[]{partition.topic(), partition.partition(), nextOffset});
        }
        this.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(nextOffset)));
    }

    static long getOffsetForPartition(List<ConsumerRecord<String, MirroredSolrRequest<?>>> partitionRecords) {
        return partitionRecords.get(partitionRecords.size() - 1).offset() + 1L;
    }

    static class WorkUnit {
        final TopicPartition partition;
        Set<Future<?>> workItems = new HashSet();
        long nextOffset;

        public WorkUnit(TopicPartition partition) {
            this.partition = partition;
        }
    }

    static class PartitionWork {
        final Queue<WorkUnit> partitionQueue = new ArrayDeque<WorkUnit>();

        PartitionWork() {
        }
    }
}

