/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.dafny.conversion;

import dafny.Array;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public class ToDafny {

    public static class Aggregate {
        public static <T, R> DafnySequence<? extends R> GenericToSequence(List<T> nativeValues, Function<T, R> converter, TypeDescriptor<R> typeDescriptor) {
            return DafnySequence.Create(typeDescriptor, (BigInteger)BigInteger.valueOf(nativeValues.size()), index -> converter.apply(nativeValues.get(index.intValue())));
        }

        public static <T, R> DafnySet<R> GenericToSet(Set<T> nativeValues, Function<T, R> converter) {
            HashSet hashSet = new HashSet(nativeValues.size(), 1.0f);
            nativeValues.forEach(v -> hashSet.add(converter.apply(v)));
            return new DafnySet(hashSet);
        }

        public static <IN_KEY, IN_VALUE, OUT_KEY, OUT_VALUE> DafnyMap<OUT_KEY, OUT_VALUE> GenericToMap(Map<IN_KEY, IN_VALUE> nativeValues, Function<IN_KEY, OUT_KEY> keyConverter, Function<IN_VALUE, OUT_VALUE> valueConverter) {
            Tuple2[] tuples = new Tuple2[nativeValues.size()];
            AtomicInteger counter = new AtomicInteger(0);
            nativeValues.forEach((k, v) -> {
                tuples[counter.getAndIncrement()] = new Tuple2(keyConverter.apply(k), valueConverter.apply(v));
            });
            return DafnyMap.fromElements((Tuple2[])tuples);
        }
    }

    public static class Simple {
        public static DafnySequence<Byte> ByteSequence(byte[] blob) {
            return DafnySequence.fromArray((TypeDescriptor)TypeDescriptor.BYTE, (Array)Array.wrap((byte[])blob));
        }

        public static DafnySequence<Byte> ByteSequence(ByteBuffer byteBuffer, int start, int limit) {
            byte[] rawArray = new byte[limit - start];
            for (int i = 0; i < rawArray.length; ++i) {
                rawArray[i] = byteBuffer.get(start + i);
            }
            return Simple.ByteSequence(rawArray);
        }

        public static DafnySequence<Byte> ByteSequence(ByteBuffer byteBuffer) {
            return Simple.ByteSequence(byteBuffer, 0, byteBuffer.limit());
        }

        public static DafnySequence<Byte> Double(Double aDouble) {
            ByteBuffer doubleBytes = ByteBuffer.allocate(8).putDouble(aDouble);
            return Simple.ByteSequence(doubleBytes, 0, 8);
        }

        public static DafnySequence<Character> CharacterSequence(String aString) {
            return DafnySequence.asString((String)aString);
        }

        public static DafnySequence<Character> CharacterSequence(Date timestamp) {
            return Simple.CharacterSequence(String.format("%d", timestamp.getTime() / 1000L));
        }

        public static DafnySequence<Character> CharacterSequence(Instant timestamp) {
            return Simple.CharacterSequence(String.format("%d", timestamp.getEpochSecond()));
        }

        public static DafnySequence<Byte> DafnyUtf8Bytes(String aString) {
            Charset utf8 = StandardCharsets.UTF_8;
            CharsetEncoder coder = utf8.newEncoder();
            CharBuffer inBuffer = CharBuffer.wrap(aString);
            inBuffer.position(0);
            try {
                ByteBuffer outBuffer = coder.encode(inBuffer);
                return Simple.ByteSequence(outBuffer, 0, outBuffer.limit());
            }
            catch (CharacterCodingException ex) {
                throw new RuntimeException("Could not encode input to Dafny Bytes.", ex);
            }
        }
    }
}

