/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import lombok.Generated;
import org.opensearch.sql.lang.LangSpec;

public final class SystemIndexUtils {
    public static final String TABLE_NAME_FOR_TABLES_INFO = "tables";
    private static final String SYS_TABLES_SUFFIX = "ODFE_SYS_TABLE";
    private static final String SYS_META_SUFFIX = "META_ODFE_SYS_TABLE";
    private static final String SYS_MAPPINGS_SUFFIX = "MAPPINGS_ODFE_SYS_TABLE";
    public static final String TABLE_INFO = "ALL.META_ODFE_SYS_TABLE";
    public static final String DATASOURCES_TABLE_NAME = ".DATASOURCES";

    public static Boolean isSystemIndex(String indexName) {
        return indexName.endsWith(SYS_TABLES_SUFFIX);
    }

    public static String mappingTable(String indexName) {
        return SystemIndexUtils.mappingTable(indexName, LangSpec.SQL_SPEC);
    }

    public static String mappingTable(String indexName, LangSpec langSpec) {
        return String.join((CharSequence)".", indexName, SystemIndexUtils.encodeLangSpec(langSpec));
    }

    public static String encodeLangSpec(LangSpec spec) {
        return spec.language().name() + "_MAPPINGS_ODFE_SYS_TABLE";
    }

    public static LangSpec extractLangSpec(String systemMappingsSuffix) {
        int underscoreIndex = systemMappingsSuffix.indexOf(95);
        if (underscoreIndex <= 0) {
            return LangSpec.SQL_SPEC;
        }
        String langName = systemMappingsSuffix.substring(0, underscoreIndex);
        return LangSpec.fromLanguage(langName);
    }

    public static SystemTable systemTable(String indexName) {
        int lastDot = indexName.lastIndexOf(".");
        String suffix = indexName.substring(lastDot + 1);
        String tableName = indexName.substring(0, lastDot).replace("%", "*");
        if (suffix.endsWith(SYS_META_SUFFIX)) {
            return new SystemInfoTable(tableName);
        }
        if (suffix.endsWith(SYS_MAPPINGS_SUFFIX)) {
            return new MetaInfoTable(tableName, SystemIndexUtils.extractLangSpec(suffix));
        }
        throw new IllegalStateException("Invalid system index name: " + indexName);
    }

    @Generated
    private SystemIndexUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class SystemInfoTable
    implements SystemTable {
        private final String tableName;

        @Override
        public boolean isSystemInfoTable() {
            return true;
        }

        @Override
        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public SystemInfoTable(String tableName) {
            this.tableName = tableName;
        }
    }

    public static class MetaInfoTable
    implements SystemTable {
        private final String tableName;
        private final LangSpec langSpec;

        @Override
        public boolean isMetaInfoTable() {
            return true;
        }

        @Override
        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Override
        @Generated
        public LangSpec getLangSpec() {
            return this.langSpec;
        }

        @Generated
        public MetaInfoTable(String tableName, LangSpec langSpec) {
            this.tableName = tableName;
            this.langSpec = langSpec;
        }
    }

    public static interface SystemTable {
        public String getTableName();

        default public LangSpec getLangSpec() {
            return LangSpec.SQL_SPEC;
        }

        default public boolean isSystemInfoTable() {
            return false;
        }

        default public boolean isMetaInfoTable() {
            return false;
        }
    }
}

