/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.spi.resources.sharing;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.security.spi.resources.sharing.CreatedBy;
import org.opensearch.security.spi.resources.sharing.Recipient;
import org.opensearch.security.spi.resources.sharing.Recipients;
import org.opensearch.security.spi.resources.sharing.ShareWith;

public class ResourceSharing
implements ToXContentFragment,
NamedWriteable {
    private final Logger log = LogManager.getLogger(this.getClass());
    private String resourceId;
    private final CreatedBy createdBy;
    private ShareWith shareWith;

    public ResourceSharing(String resourceId, CreatedBy createdBy, ShareWith shareWith) {
        this.resourceId = resourceId;
        this.createdBy = createdBy;
        this.shareWith = shareWith;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    public ShareWith getShareWith() {
        return this.shareWith;
    }

    public void share(String accessLevel, Recipients target) {
        if (this.shareWith == null) {
            this.shareWith = new ShareWith(Map.of(accessLevel, target));
            return;
        }
        Recipients sharedWith = this.shareWith.atAccessLevel(accessLevel);
        if (sharedWith == null) {
            this.shareWith = this.shareWith.updateSharingInfo(accessLevel, target);
        } else {
            sharedWith.share(target);
        }
    }

    public void revoke(String accessLevel, Recipients target) {
        if (this.shareWith == null) {
            this.log.warn("Cannot revoke access as resource {} is not shared with anyone", (Object)this.resourceId);
            return;
        }
        Recipients sharedWith = this.shareWith.atAccessLevel(accessLevel);
        if (sharedWith == null) {
            this.log.warn("Cannot revoke access to {} for {} as the resource is not shared at accessLevel {}", (Object)this.resourceId, (Object)accessLevel, (Object)target);
        } else {
            sharedWith.revoke(target);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSharing resourceSharing = (ResourceSharing)o;
        return Objects.equals(this.getResourceId(), resourceSharing.getResourceId()) && Objects.equals(this.getCreatedBy(), resourceSharing.getCreatedBy()) && Objects.equals(this.getShareWith(), resourceSharing.getShareWith());
    }

    public int hashCode() {
        return Objects.hash(this.getResourceId(), this.getCreatedBy(), this.getShareWith());
    }

    public String toString() {
        return "ResourceSharing {resourceId='" + this.resourceId + "', createdBy=" + String.valueOf(this.createdBy) + ", sharedWith=" + String.valueOf(this.shareWith) + "}";
    }

    public String getWriteableName() {
        return "resource_sharing";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.resourceId);
        this.createdBy.writeTo(out);
        if (this.shareWith != null) {
            out.writeBoolean(true);
            this.shareWith.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("resource_id", this.resourceId).field("created_by");
        this.createdBy.toXContent(builder, params);
        if (this.shareWith != null) {
            builder.field("share_with");
            this.shareWith.toXContent(builder, params);
        }
        return builder.endObject();
    }

    public static ResourceSharing fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String resourceId = null;
        CreatedBy createdBy = null;
        ShareWith shareWith = null;
        String currentFieldName = null;
        block10: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            switch (Objects.requireNonNull(currentFieldName)) {
                case "resource_id": {
                    resourceId = parser.text();
                    continue block10;
                }
                case "created_by": {
                    createdBy = CreatedBy.fromXContent(parser);
                    continue block10;
                }
                case "share_with": {
                    shareWith = ShareWith.fromXContent(parser);
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        ResourceSharing.validateRequiredField("resource_id", resourceId);
        ResourceSharing.validateRequiredField("created_by", createdBy);
        return new ResourceSharing(resourceId, createdBy, shareWith);
    }

    private static <T> void validateRequiredField(String field, T value) {
        if (value == null) {
            throw new IllegalArgumentException(field + " is required");
        }
    }

    public boolean isCreatedBy(String userName) {
        return this.createdBy != null && this.createdBy.getUsername().equals(userName);
    }

    public boolean isSharedWithEveryone() {
        return this.shareWith != null && this.shareWith.isPublic();
    }

    public boolean isSharedWithEntity(Recipient recipientType, Set<String> targets, String accessLevel) {
        if (this.shareWith == null || this.shareWith.atAccessLevel(accessLevel) == null) {
            return false;
        }
        return this.shareWith.atAccessLevel(accessLevel).isSharedWithAny(recipientType, targets);
    }

    public Set<String> fetchAccessLevels(Recipient recipientType, Set<String> entities) {
        if (this.shareWith == null) {
            return Collections.emptySet();
        }
        HashSet<String> matchingGroups = new HashSet<String>();
        for (Map.Entry<String, Recipients> entry : this.shareWith.getSharingInfo().entrySet()) {
            boolean intersects;
            String accessLevel = entry.getKey();
            Recipients recipients = entry.getValue();
            HashSet sharingRecipients = new HashSet(recipients.getRecipients().getOrDefault((Object)recipientType, Set.of()));
            boolean matchesWildcard = sharingRecipients.contains("*");
            boolean bl = intersects = !Collections.disjoint(sharingRecipients, entities);
            if (!matchesWildcard && !intersects) continue;
            matchingGroups.add(accessLevel);
        }
        return matchingGroups;
    }
}

