/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.experiment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.executors.ExperimentTaskManager;
import org.opensearch.searchrelevance.experiment.ExperimentOptionsFactory;
import org.opensearch.searchrelevance.experiment.ExperimentOptionsForHybridSearch;
import org.opensearch.searchrelevance.experiment.ExperimentVariantHybridSearchDTO;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.ExperimentType;
import org.opensearch.searchrelevance.model.ExperimentVariant;
import org.opensearch.searchrelevance.model.SearchConfigurationDetails;
import org.opensearch.searchrelevance.utils.TimeUtils;

public class HybridOptimizerExperimentProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridOptimizerExperimentProcessor.class);
    private final JudgmentDao judgmentDao;
    private final ExperimentTaskManager taskManager;

    public void processHybridOptimizerExperiment(String experimentId, String queryText, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> judgmentList, int size, AtomicBoolean hasFailure, ActionListener<Map<String, Object>> listener) {
        Map<String, Object> defaultParametersForHybridSearch = ExperimentOptionsFactory.createDefaultExperimentParametersForHybridSearch();
        ExperimentOptionsForHybridSearch experimentOptionForHybridSearch = (ExperimentOptionsForHybridSearch)ExperimentOptionsFactory.createExperimentOptions("HYBRID_SEARCH_EXPERIMENT_OPTIONS", defaultParametersForHybridSearch);
        List<ExperimentVariantHybridSearchDTO> experimentVariantDTOs = experimentOptionForHybridSearch.getParameterCombinations(true);
        ArrayList<ExperimentVariant> experimentVariants = new ArrayList<ExperimentVariant>();
        log.info("Starting hybrid optimizer experiment {} with {} parameter combinations for query: {}", (Object)experimentId, (Object)experimentVariantDTOs.size(), (Object)queryText);
        for (ExperimentVariantHybridSearchDTO experimentVariantDTO : experimentVariantDTOs) {
            HashMap<String, float[]> parameters = new HashMap<String, float[]>(Map.of("normalization", experimentVariantDTO.getNormalizationTechnique(), "combination", experimentVariantDTO.getCombinationTechnique(), "weights", experimentVariantDTO.getQueryWeightsForCombination()));
            String experimentVariantId = UUID.randomUUID().toString();
            ExperimentVariant experimentVariant = new ExperimentVariant(experimentVariantId, TimeUtils.getTimestamp(), ExperimentType.HYBRID_OPTIMIZER, AsyncStatus.PROCESSING, experimentId, parameters, Map.of());
            experimentVariants.add(experimentVariant);
        }
        log.info("Experiment {}: Created {} experiment variants, proceeding to judgment processing", (Object)experimentId, (Object)experimentVariants.size());
        ((CompletableFuture)this.processJudgmentsAsync(queryText, judgmentList).thenAccept(docIdToScores -> {
            log.info("Processing search configurations for query '{}' with {} document ratings", (Object)queryText, (Object)docIdToScores.size());
            this.processSearchConfigurationsAsync(experimentId, queryText, searchConfigurations, judgmentList, size, (List<ExperimentVariant>)experimentVariants, (Map<String, String>)docIdToScores, hasFailure, listener);
        })).exceptionally(e -> {
            if (hasFailure.compareAndSet(false, true)) {
                listener.onFailure(new Exception("Failed to process judgments", (Throwable)e));
            }
            return null;
        });
    }

    private CompletableFuture<Map<String, String>> processJudgmentsAsync(String queryText, List<String> judgmentList) {
        log.info("Processing {} judgments for query: {}", (Object)judgmentList.size(), (Object)queryText);
        List<CompletableFuture> judgmentFutures = judgmentList.stream().map(judgmentId -> {
            CompletableFuture future = new CompletableFuture();
            this.judgmentDao.getJudgment((String)judgmentId, (ActionListener<SearchResponse>)ActionListener.wrap(future::complete, future::completeExceptionally));
            return future;
        }).toList();
        return CompletableFuture.allOf(judgmentFutures.toArray(new CompletableFuture[0])).thenApply(v -> {
            HashMap<String, String> docIdToScores = new HashMap<String, String>();
            for (CompletableFuture future : judgmentFutures) {
                try {
                    SearchResponse response = (SearchResponse)future.join();
                    this.extractJudgmentScores(queryText, response, docIdToScores);
                }
                catch (Exception e) {
                    log.error("Failed to process judgment response: {}", (Object)e.getMessage());
                }
            }
            if (docIdToScores.isEmpty()) {
                log.warn("No ratings found for query: {} in any judgment responses", (Object)queryText);
            } else {
                log.info("Found {} document ratings for query: {}", (Object)docIdToScores.size(), (Object)queryText);
            }
            return docIdToScores;
        });
    }

    private void extractJudgmentScores(String queryText, SearchResponse response, Map<String, String> docIdToScores) {
        if (response.getHits().getTotalHits().value() == 0L) {
            log.warn("No judgment found in response");
            return;
        }
        Map sourceAsMap = response.getHits().getHits()[0].getSourceAsMap();
        List judgmentRatings = sourceAsMap.getOrDefault("judgmentRatings", Collections.emptyList());
        for (Map rating : judgmentRatings) {
            if (!queryText.equals(rating.get("query"))) continue;
            List docScoreRatings = (List)rating.get("ratings");
            if (docScoreRatings == null) break;
            docScoreRatings.forEach(docScoreRating -> docIdToScores.put((String)docScoreRating.get("docId"), (String)docScoreRating.get("rating")));
            break;
        }
    }

    private void processSearchConfigurationsAsync(String experimentId, String queryText, Map<String, SearchConfigurationDetails> searchConfigurations, List<String> judgmentList, int size, List<ExperimentVariant> experimentVariants, Map<String, String> docIdToScores, AtomicBoolean hasFailure, ActionListener<Map<String, Object>> finalListener) {
        ConcurrentHashMap<String, Object> hydratedResults = new ConcurrentHashMap<String, Object>();
        List queryResults = Collections.synchronizedList(new ArrayList());
        ArrayList<CompletionStage> configFutures = new ArrayList<CompletionStage>();
        for (Map.Entry<String, SearchConfigurationDetails> entry : searchConfigurations.entrySet()) {
            String searchConfigId = entry.getKey();
            SearchConfigurationDetails configDetails = entry.getValue();
            String index = configDetails.getIndex();
            String query = configDetails.getQuery();
            CompletableFuture<Map<String, Object>> configFuture = this.taskManager.scheduleTasksAsync(ExperimentType.HYBRID_OPTIMIZER, experimentId, searchConfigId, index, query, queryText, size, experimentVariants, judgmentList, docIdToScores, hydratedResults, hasFailure);
            CompletionStage transformedFuture = configFuture.thenApply(results -> {
                List evaluationResults = (List)results.get("evaluationResults");
                if (evaluationResults != null && !evaluationResults.isEmpty()) {
                    HashMap<String, Object> searchConfigResult = new HashMap<String, Object>();
                    searchConfigResult.put("searchConfigurationId", searchConfigId);
                    searchConfigResult.put("evaluationResults", new ArrayList(evaluationResults));
                    queryResults.add(searchConfigResult);
                }
                return results;
            });
            configFutures.add(transformedFuture);
        }
        ((CompletableFuture)CompletableFuture.allOf(configFutures.toArray(new CompletableFuture[0])).thenAccept(v -> {
            HashMap queryResponse = new HashMap();
            queryResponse.put("searchConfigurationResults", new ArrayList(queryResults));
            finalListener.onResponse(queryResponse);
        })).exceptionally(e -> {
            if (hasFailure.compareAndSet(false, true)) {
                finalListener.onFailure(new Exception("Failed to process search configurations", (Throwable)e));
            }
            return null;
        });
    }

    @Generated
    public HybridOptimizerExperimentProcessor(JudgmentDao judgmentDao, ExperimentTaskManager taskManager) {
        this.judgmentDao = judgmentDao;
        this.taskManager = taskManager;
    }
}

