/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.listener;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.NotifyOnceListener;
import org.opensearch.index.shard.SearchOperationListener;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics.RTFMetrics;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.util.Util;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.listener.NoOpSearchListener;
import org.opensearch.performanceanalyzer.listener.SearchListener;
import org.opensearch.performanceanalyzer.util.Utils;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.tasks.Task;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public class RTFPerformanceAnalyzerSearchListener
implements SearchOperationListener,
SearchListener {
    private static final Logger LOG = LogManager.getLogger(RTFPerformanceAnalyzerSearchListener.class);
    private static final String SHARD_FETCH_PHASE = "shard_fetch";
    private static final String SHARD_QUERY_PHASE = "shard_query";
    public static final String QUERY_START_TIME = "query_start_time";
    public static final String FETCH_START_TIME = "fetch_start_time";
    public static final String QUERY_TASK_ID = "query_task_id";
    private final ThreadLocal<Map<String, Long>> threadLocal;
    private static final SearchListener NO_OP_SEARCH_LISTENER = new NoOpSearchListener();
    private final PerformanceAnalyzerController controller;
    private final Histogram cpuUtilizationHistogram;
    private final Histogram heapUsedHistogram;
    private final int numProcessors;

    public RTFPerformanceAnalyzerSearchListener(PerformanceAnalyzerController controller) {
        this.controller = controller;
        this.cpuUtilizationHistogram = this.createCPUUtilizationHistogram(OpenSearchResources.INSTANCE.getMetricsRegistry());
        this.heapUsedHistogram = this.createHeapUsedHistogram(OpenSearchResources.INSTANCE.getMetricsRegistry());
        this.threadLocal = ThreadLocal.withInitial(() -> new HashMap());
        this.numProcessors = Runtime.getRuntime().availableProcessors();
    }

    private Histogram createCPUUtilizationHistogram(MetricsRegistry metricsRegistry) {
        if (metricsRegistry != null) {
            return metricsRegistry.createHistogram(RTFMetrics.OSMetrics.CPU_UTILIZATION.toString(), "CPU Utilization per shard for a search phase", RTFMetrics.MetricUnits.RATE.toString());
        }
        LOG.debug("MetricsRegistry is null");
        return null;
    }

    private Histogram createHeapUsedHistogram(MetricsRegistry metricsRegistry) {
        if (metricsRegistry != null) {
            return metricsRegistry.createHistogram(RTFMetrics.OSMetrics.HEAP_ALLOCATED.toString(), "Heap used per shard for a search phase", RTFMetrics.MetricUnits.BYTE.toString());
        }
        LOG.debug("MetricsRegistry is null");
        return null;
    }

    public String toString() {
        return RTFPerformanceAnalyzerSearchListener.class.getSimpleName();
    }

    @VisibleForTesting
    SearchListener getSearchListener() {
        return this.isSearchListenerEnabled() ? this : NO_OP_SEARCH_LISTENER;
    }

    private boolean isSearchListenerEnabled() {
        return OpenSearchResources.INSTANCE.getMetricsRegistry() != null && this.controller.isPerformanceAnalyzerEnabled() && (this.controller.getCollectorsRunModeValue() == Util.CollectorMode.DUAL.getValue() || this.controller.getCollectorsRunModeValue() == Util.CollectorMode.TELEMETRY.getValue());
    }

    public void onPreQueryPhase(SearchContext searchContext) {
        try {
            this.getSearchListener().preQueryPhase(searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
    }

    public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
        try {
            this.getSearchListener().queryPhase(searchContext, tookInNanos);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
    }

    public void onFailedQueryPhase(SearchContext searchContext) {
        try {
            this.getSearchListener().failedQueryPhase(searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
    }

    public void onPreFetchPhase(SearchContext searchContext) {
        try {
            this.getSearchListener().preFetchPhase(searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
    }

    public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
        try {
            this.getSearchListener().fetchPhase(searchContext, tookInNanos);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
    }

    public void onFailedFetchPhase(SearchContext searchContext) {
        try {
            this.getSearchListener().failedFetchPhase(searchContext);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            StatsCollector.instance().logException(StatExceptionCode.OPENSEARCH_REQUEST_INTERCEPTOR_ERROR);
        }
    }

    @Override
    public void preQueryPhase(SearchContext searchContext) {
        this.threadLocal.get().put(QUERY_START_TIME, System.nanoTime());
        this.threadLocal.get().put(QUERY_TASK_ID, searchContext.getTask().getId());
    }

    @Override
    public void queryPhase(SearchContext searchContext, long tookInNanos) {
        long queryStartTime = this.threadLocal.get().getOrDefault(QUERY_START_TIME, System.nanoTime());
        long queryTime = System.nanoTime() - queryStartTime;
        this.addResourceTrackingCompletionListener(searchContext, queryStartTime, queryTime, SHARD_QUERY_PHASE, false);
    }

    @Override
    public void failedQueryPhase(SearchContext searchContext) {
        long queryStartTime = this.threadLocal.get().getOrDefault(QUERY_START_TIME, System.nanoTime());
        long queryTime = System.nanoTime() - queryStartTime;
        this.addResourceTrackingCompletionListener(searchContext, queryStartTime, queryTime, SHARD_QUERY_PHASE, true);
    }

    @Override
    public void preFetchPhase(SearchContext searchContext) {
        this.threadLocal.get().put(FETCH_START_TIME, System.nanoTime());
    }

    @Override
    public void fetchPhase(SearchContext searchContext, long tookInNanos) {
        long fetchStartTime = this.threadLocal.get().getOrDefault(FETCH_START_TIME, System.nanoTime());
        long fetchTime = System.nanoTime() - fetchStartTime;
        this.addResourceTrackingCompletionListenerForFetchPhase(searchContext, fetchStartTime, fetchTime, SHARD_FETCH_PHASE, false);
    }

    @Override
    public void failedFetchPhase(SearchContext searchContext) {
        long fetchStartTime = this.threadLocal.get().getOrDefault(FETCH_START_TIME, System.nanoTime());
        long fetchTime = System.nanoTime() - fetchStartTime;
        this.addResourceTrackingCompletionListenerForFetchPhase(searchContext, fetchStartTime, fetchTime, SHARD_FETCH_PHASE, true);
    }

    private void addResourceTrackingCompletionListener(SearchContext searchContext, long startTime, long queryTime, String phase, boolean isFailed) {
        this.addCompletionListener(searchContext, startTime, queryTime, phase, isFailed);
    }

    private void addResourceTrackingCompletionListenerForFetchPhase(SearchContext searchContext, long fetchStartTime, long fetchTime, String phase, boolean isFailed) {
        long startTime = fetchStartTime;
        long queryTaskId = this.threadLocal.get().getOrDefault(QUERY_TASK_ID, -1L);
        if (queryTaskId == searchContext.getTask().getId()) {
            startTime = this.threadLocal.get().getOrDefault(QUERY_START_TIME, System.nanoTime());
        }
        this.addCompletionListener(searchContext, startTime, fetchTime, phase, isFailed);
    }

    private void addCompletionListener(SearchContext searchContext, long startTime, long phaseTookTime, String phase, boolean isFailed) {
        searchContext.getTask().addResourceTrackingCompletionListener(this.createListener(searchContext, startTime, phaseTookTime, phase, isFailed));
    }

    @VisibleForTesting
    NotifyOnceListener<Task> createListener(final SearchContext searchContext, final long startTime, final long phaseTookTime, final String phase, final boolean isFailed) {
        return new NotifyOnceListener<Task>(this){
            final /* synthetic */ RTFPerformanceAnalyzerSearchListener this$0;
            {
                this.this$0 = this$0;
            }

            protected void innerOnResponse(Task task) {
                LOG.debug("Updating the counter for task {}", (Object)task.getId());
                long totalTime = System.nanoTime() - startTime;
                double shareFactor = RTFPerformanceAnalyzerSearchListener.computeShareFactor(phaseTookTime, totalTime);
                this.this$0.cpuUtilizationHistogram.record(Utils.calculateCPUUtilization(this.this$0.numProcessors, totalTime, task.getTotalResourceStats().getCpuTimeInNanos(), shareFactor), this.createTags());
                this.this$0.heapUsedHistogram.record(Math.max(0.0, (double)task.getTotalResourceStats().getMemoryInBytes() * shareFactor), this.createTags());
            }

            private Tags createTags() {
                return Tags.create().addTag(RTFMetrics.CommonDimension.INDEX_NAME.toString(), searchContext.request().shardId().getIndex().getName()).addTag(RTFMetrics.CommonDimension.INDEX_UUID.toString(), searchContext.request().shardId().getIndex().getUUID()).addTag(RTFMetrics.CommonDimension.SHARD_ID.toString(), (long)searchContext.request().shardId().getId()).addTag(RTFMetrics.CommonDimension.OPERATION.toString(), phase).addTag(RTFMetrics.CommonDimension.FAILED.toString(), isFailed);
            }

            protected void innerOnFailure(Exception e) {
                LOG.error("Error is executing the the listener", (Throwable)e);
            }
        };
    }

    @VisibleForTesting
    static double computeShareFactor(long phaseTookTime, long totalTime) {
        return Math.min(1.0, (double)phaseTookTime / Math.max(1.0, (double)totalTime));
    }
}

