/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.engine.Engine;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.ModelZoo;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModelZoo
extends ModelZoo {
    public static final String GROUP_ID = "ai.djl.localmodelzoo";
    private static final Logger logger = LoggerFactory.getLogger(DefaultModelZoo.class);

    public DefaultModelZoo() {
        String locations = System.getProperty("ai.djl.repository.zoo.location");
        if (locations != null) {
            this.parseLocation(locations);
        }
    }

    public DefaultModelZoo(String locations) {
        this.parseLocation(locations);
    }

    @Override
    public String getGroupId() {
        return GROUP_ID;
    }

    @Override
    public Set<String> getSupportedEngines() {
        return Engine.getAllEngines();
    }

    private void parseLocation(String locations) {
        String[] urls;
        for (String url : urls = locations.split("\\s*,\\s*")) {
            if (!url.isEmpty()) {
                Repository repo = Repository.newInstance(url, url);
                logger.debug("Scanning models in repo: {}, {}", repo.getClass(), (Object)url);
                for (MRL mrl : repo.getResources()) {
                    this.addModel(mrl);
                }
                continue;
            }
            logger.warn("Model location is empty.");
        }
    }
}

