/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tribuo.FeatureMap;
import org.tribuo.VariableIDInfo;
import org.tribuo.VariableInfo;

public class ImmutableFeatureMap
extends FeatureMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<Integer, VariableIDInfo> idMap = new HashMap<Integer, VariableIDInfo>();
    protected int size;

    public ImmutableFeatureMap(FeatureMap map) {
        this(ImmutableFeatureMap.generateIDs(map));
    }

    public ImmutableFeatureMap(List<VariableInfo> infoList) {
        this(ImmutableFeatureMap.generateIDs(infoList));
    }

    private ImmutableFeatureMap(Map<String, VariableIDInfo> map) {
        super(map);
        for (Map.Entry e : this.m.entrySet()) {
            VariableIDInfo idInfo = (VariableIDInfo)e.getValue();
            this.idMap.put(idInfo.getID(), idInfo);
        }
        this.size = this.m.size();
    }

    protected ImmutableFeatureMap() {
    }

    public VariableIDInfo get(int id) {
        return this.idMap.get(id);
    }

    @Override
    public VariableIDInfo get(String name) {
        return (VariableIDInfo)super.get(name);
    }

    public int getID(String name) {
        VariableIDInfo info = this.get(name);
        if (info != null) {
            return info.getID();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    public static Map<String, VariableIDInfo> generateIDs(FeatureMap map) {
        TreeMap<String, VariableInfo> sortedMap = new TreeMap<String, VariableInfo>(map.m);
        return ImmutableFeatureMap.generateIDs(sortedMap);
    }

    public static Map<String, VariableIDInfo> generateIDs(List<? extends VariableInfo> list) {
        TreeMap<String, VariableInfo> sortedMap = new TreeMap<String, VariableInfo>();
        for (VariableInfo variableInfo : list) {
            sortedMap.put(variableInfo.getName(), variableInfo);
        }
        return ImmutableFeatureMap.generateIDs(sortedMap);
    }

    private static Map<String, VariableIDInfo> generateIDs(TreeMap<String, VariableInfo> sortedMap) {
        HashMap<String, VariableIDInfo> outputMap = new HashMap<String, VariableIDInfo>();
        int counter = 0;
        for (Map.Entry<String, VariableInfo> e : sortedMap.entrySet()) {
            VariableIDInfo newInfo = e.getValue().makeIDInfo(counter);
            outputMap.put(e.getKey(), newInfo);
            ++counter;
        }
        return outputMap;
    }
}

