/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharSubSequence
extends BasedSequenceImpl {
    private final char[] baseChars;
    private final CharSubSequence base;
    private final int startOffset;
    private final int endOffset;

    private CharSubSequence(char[] chars, int hash) {
        super(hash);
        int iMax = chars.length;
        this.base = this;
        this.baseChars = chars;
        this.startOffset = 0;
        this.endOffset = this.baseChars.length;
    }

    private CharSubSequence(CharSubSequence baseSeq, int startIndex, int endIndex) {
        super(0);
        assert (startIndex >= 0 && endIndex >= startIndex && endIndex <= baseSeq.baseChars.length) : String.format("CharSubSequence must have (startIndex > 0 || endIndex < %d) && endIndex >= startIndex, got startIndex:%d, endIndex: %d", baseSeq.baseChars.length, startIndex, endIndex);
        assert (startIndex > 0 || endIndex < baseSeq.baseChars.length) : String.format("CharSubSequence must be proper subsequences [1, %d) got startIndex:%d, endIndex: %d", Math.max(0, baseSeq.baseChars.length - 1), startIndex, endIndex);
        this.base = baseSeq;
        this.baseChars = baseSeq.baseChars;
        this.startOffset = this.base.startOffset + startIndex;
        this.endOffset = this.base.startOffset + endIndex;
    }

    @Override
    public int getOptionFlags() {
        return 0;
    }

    @Override
    public boolean allOptions(int options) {
        return false;
    }

    @Override
    public boolean anyOptions(int options) {
        return false;
    }

    @Override
    public <T> T getOption(DataKeyBase<T> dataKey) {
        return dataKey.get(null);
    }

    @Override
    @Nullable
    public DataHolder getOptions() {
        return null;
    }

    @Override
    @NotNull
    public CharSubSequence getBaseSequence() {
        return this.base;
    }

    @NotNull
    public char[] getBase() {
        return this.baseChars;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    @NotNull
    public Range getSourceRange() {
        return Range.of(this.startOffset, this.endOffset);
    }

    @Override
    public int getIndexOffset(int index) {
        SequenceUtils.validateIndexInclusiveEnd(index, this.length());
        return this.startOffset + index;
    }

    @Override
    public char charAt(int index) {
        SequenceUtils.validateIndex(index, this.length());
        char c = this.baseChars[index + this.startOffset];
        return c == '\u0000' ? (char)'\ufffd' : c;
    }

    @Override
    @NotNull
    public CharSubSequence subSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.length());
        return this.base.baseSubSequence(this.startOffset + startIndex, this.startOffset + endIndex);
    }

    @Override
    @NotNull
    public CharSubSequence baseSubSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.baseChars.length);
        return startIndex == this.startOffset && endIndex == this.endOffset ? this : (this.base != this ? this.base.baseSubSequence(startIndex, endIndex) : new CharSubSequence(this.base, startIndex, endIndex));
    }

    public static CharSubSequence of(CharSequence charSequence) {
        return CharSubSequence.of(charSequence, 0, charSequence.length());
    }

    public static CharSubSequence of(CharSequence charSequence, int startIndex) {
        assert (startIndex <= charSequence.length());
        return CharSubSequence.of(charSequence, startIndex, charSequence.length());
    }

    @Deprecated
    public static CharSubSequence of(char[] chars, int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex <= endIndex && endIndex <= chars.length);
        char[] useChars = new char[chars.length];
        System.arraycopy(chars, 0, useChars, 0, chars.length);
        return startIndex == 0 && endIndex == chars.length ? new CharSubSequence(useChars, 0) : new CharSubSequence(useChars, 0).subSequence(startIndex, endIndex);
    }

    private static CharSubSequence of(CharSequence charSequence, int startIndex, int endIndex) {
        CharSubSequence charSubSequence;
        assert (startIndex >= 0 && startIndex <= endIndex && endIndex <= charSequence.length());
        if (charSequence instanceof CharSubSequence) {
            charSubSequence = (CharSubSequence)charSequence;
        } else if (charSequence instanceof String) {
            charSubSequence = new CharSubSequence(((String)charSequence).toCharArray(), ((String)charSequence).hashCode());
        } else if (charSequence instanceof StringBuilder) {
            char[] chars = new char[charSequence.length()];
            ((StringBuilder)charSequence).getChars(0, charSequence.length(), chars, 0);
            charSubSequence = new CharSubSequence(chars, 0);
        } else {
            charSubSequence = new CharSubSequence(charSequence.toString().toCharArray(), 0);
        }
        if (startIndex == 0 && endIndex == charSequence.length()) {
            return charSubSequence;
        }
        return charSubSequence.subSequence(startIndex, endIndex);
    }
}

