/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 112130858451958L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-2147319810 - -((char)-8492), 2147319810 - (char)-2520, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2147319810 - -((char)-8491), -2147319810 - -((char)-2183), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 68437170574218L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.s();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (!bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1161673410 + -13970, -1161673410 - -6407, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1161673410 + -13969, 1161673410 + 9456, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1161673410 + -13972, 1161673410 - 2076, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 113249289009247L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.s();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(408676260 - 16934, -408676260 - -14694, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(408676260 - 16935, -408676260 - -14802, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(408676260 - 16936, 408676260 - 23721, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (!bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(408676260 - 16945, 408676260 - 14629, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(408676260 - 16946, -408676260 - -8441, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(408676260 - 16947, -408676260 - -16576, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(408676260 - 16945, 408676260 - 14629, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(408676260 - 16948, -408676260 + -1148, (int)l2));
                            if (ActionTimestamp.Y() != null) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.Y(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 23737258338943L;
                    bl = SshAgentIpcService.s();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (!bl) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (!bl) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        boolean bl;
        long l2;
        block27: {
            block28: {
                l2 = 2978055701129L;
                boolean bl2 = SshAgentIpcService.s();
                this.assertConnectionThread();
                Object object3 = this.lock;
                bl = bl2;
                synchronized (object3) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl4 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1643355660 + -16979, 1643355660 + 7739, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1643355660 + -16975, -1643355660 + -19787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1643355660 + -16980, 1643355660 + 13875, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1643355660 + -16975, -1643355660 + -19787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1643355660 + -16977, 1643355660 + 16854, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1643355660 + -16979, 1643355660 + 7739, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1643355660 + -16975, -1643355660 + -19787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1643355660 + -16978, 1643355660 - 2768, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (!bl) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1643355660 + -16979, 1643355660 + 7739, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1643355660 + -16975, -1643355660 + -19787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1643355660 + -16951, -1643355660 + -10001, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1643355660 + -16975, -1643355660 + -19787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1643355660 + -16952, -1643355660 + -13782, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl9;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl10 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (!bl) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl9 = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl9) {
                boolean bl11 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1643355660 + -16975, -1643355660 + -19787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1643355660 + -16977, 1643355660 + 16854, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl12 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1643355660 + -16979, 1643355660 + 7739, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1643355660 + -16975, -1643355660 + -19787, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1643355660 + -16949, -1643355660 - -5578, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 25666813528212L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(88996530 - 21674, 88996530 - 12792, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 74666810203414L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1196275890 - -((char)-21443), 1196275890 - (char)-32202, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = ";\u0016\u00e1\u00ae\u00d4\u0015]\u00e6\u009d\u0000\u0014\u0080\u000f\u00a5\u00ca\u00e4\b\u00b5\u00dc\u0014s\u00ed\u00e8\u00d7\u00ee\u00f8g\u00deX\u0001itb\u00c2\u00a6\u0083h\u009f\u00d7\u00e1";
                        var4_3 = ";\u0016\u00e1\u00ae\u00d4\u0015]\u00e6\u009d\u0000\u0014\u0080\u000f\u00a5\u00ca\u00e4\b\u00b5\u00dc\u0014s\u00ed\u00e8\u00d7\u00ee\u00f8g\u00deX\u0001itb\u00c2\u00a6\u0083h\u009f\u00d7\u00e1".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 89;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 16;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 4;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 34;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 30;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 41;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 97;
                                        break;
                                    }
                                    default: {
                                        v11 = 70;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x2E9C) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 112;
                            case 1 -> 166;
                            case 2 -> 44;
                            case 3 -> 208;
                            case 4 -> 242;
                            case 5 -> 68;
                            case 6 -> 193;
                            case 7 -> 20;
                            case 8 -> 103;
                            case 9 -> 197;
                            case 10 -> 181;
                            case 11 -> 149;
                            case 12 -> 40;
                            case 13 -> 172;
                            case 14 -> 129;
                            case 15 -> 250;
                            case 16 -> 182;
                            case 17 -> 27;
                            case 18 -> 30;
                            case 19 -> 205;
                            case 20 -> 53;
                            case 21 -> 186;
                            case 22 -> 50;
                            case 23 -> 176;
                            case 24 -> 5;
                            case 25 -> 183;
                            case 26 -> 13;
                            case 27 -> 231;
                            case 28 -> 109;
                            case 29 -> 10;
                            case 30 -> 147;
                            case 31 -> 64;
                            case 32 -> 55;
                            case 33 -> 235;
                            case 34 -> 238;
                            case 35 -> 159;
                            case 36 -> 210;
                            case 37 -> 14;
                            case 38 -> 65;
                            case 39 -> 31;
                            case 40 -> 121;
                            case 41 -> 127;
                            case 42 -> 145;
                            case 43 -> 6;
                            case 44 -> 110;
                            case 45 -> 211;
                            case 46 -> 224;
                            case 47 -> 135;
                            case 48 -> 88;
                            case 49 -> 67;
                            case 50 -> 116;
                            case 51 -> 128;
                            case 52 -> 35;
                            case 53 -> 219;
                            case 54 -> 132;
                            case 55 -> 241;
                            case 56 -> 216;
                            case 57 -> 163;
                            case 58 -> 22;
                            case 59 -> 114;
                            case 60 -> 46;
                            case 61 -> 223;
                            case 62 -> 123;
                            case 63 -> 167;
                            case 64 -> 154;
                            case 65 -> 78;
                            case 66 -> 164;
                            case 67 -> 237;
                            case 68 -> 139;
                            case 69 -> 198;
                            case 70 -> 232;
                            case 71 -> 1;
                            case 72 -> 102;
                            case 73 -> 141;
                            case 74 -> 171;
                            case 75 -> 153;
                            case 76 -> 169;
                            case 77 -> 105;
                            case 78 -> 196;
                            case 79 -> 4;
                            case 80 -> 61;
                            case 81 -> 207;
                            case 82 -> 220;
                            case 83 -> 243;
                            case 84 -> 28;
                            case 85 -> 108;
                            case 86 -> 23;
                            case 87 -> 41;
                            case 88 -> 124;
                            case 89 -> 117;
                            case 90 -> 29;
                            case 91 -> 70;
                            case 92 -> 222;
                            case 93 -> 24;
                            case 94 -> 66;
                            case 95 -> 199;
                            case 96 -> 32;
                            case 97 -> 239;
                            case 98 -> 152;
                            case 99 -> 95;
                            case 100 -> 131;
                            case 101 -> 255;
                            case 102 -> 79;
                            case 103 -> 9;
                            case 104 -> 218;
                            case 105 -> 212;
                            case 106 -> 83;
                            case 107 -> 134;
                            case 108 -> 165;
                            case 109 -> 245;
                            case 110 -> 119;
                            case 111 -> 236;
                            case 112 -> 93;
                            case 113 -> 91;
                            case 114 -> 18;
                            case 115 -> 49;
                            case 116 -> 142;
                            case 117 -> 227;
                            case 118 -> 11;
                            case 119 -> 81;
                            case 120 -> 194;
                            case 121 -> 113;
                            case 122 -> 137;
                            case 123 -> 85;
                            case 124 -> 177;
                            case 125 -> 201;
                            case 126 -> 100;
                            case 127 -> 138;
                            case 128 -> 42;
                            case 129 -> 140;
                            case 130 -> 74;
                            case 131 -> 247;
                            case 132 -> 204;
                            case 133 -> 251;
                            case 134 -> 39;
                            case 135 -> 60;
                            case 136 -> 106;
                            case 137 -> 217;
                            case 138 -> 8;
                            case 139 -> 71;
                            case 140 -> 43;
                            case 141 -> 146;
                            case 142 -> 252;
                            case 143 -> 25;
                            case 144 -> 246;
                            case 145 -> 209;
                            case 146 -> 80;
                            case 147 -> 12;
                            case 148 -> 202;
                            case 149 -> 101;
                            case 150 -> 120;
                            case 151 -> 58;
                            case 152 -> 158;
                            case 153 -> 215;
                            case 154 -> 73;
                            case 155 -> 19;
                            case 156 -> 133;
                            case 157 -> 118;
                            case 158 -> 143;
                            case 159 -> 16;
                            case 160 -> 98;
                            case 161 -> 94;
                            case 162 -> 184;
                            case 163 -> 155;
                            case 164 -> 56;
                            case 165 -> 240;
                            case 166 -> 87;
                            case 167 -> 180;
                            case 168 -> 122;
                            case 169 -> 38;
                            case 170 -> 82;
                            case 171 -> 48;
                            case 172 -> 190;
                            case 173 -> 200;
                            case 174 -> 84;
                            case 175 -> 144;
                            case 176 -> 75;
                            case 177 -> 148;
                            case 178 -> 187;
                            case 179 -> 17;
                            case 180 -> 45;
                            case 181 -> 162;
                            case 182 -> 62;
                            case 183 -> 213;
                            case 184 -> 156;
                            case 185 -> 192;
                            case 186 -> 253;
                            case 187 -> 34;
                            case 188 -> 52;
                            case 189 -> 96;
                            case 190 -> 185;
                            case 191 -> 76;
                            case 192 -> 72;
                            case 193 -> 230;
                            case 194 -> 7;
                            case 195 -> 160;
                            case 196 -> 15;
                            case 197 -> 57;
                            case 198 -> 173;
                            case 199 -> 2;
                            case 200 -> 161;
                            case 201 -> 228;
                            case 202 -> 191;
                            case 203 -> 125;
                            case 204 -> 77;
                            case 205 -> 97;
                            case 206 -> 249;
                            case 207 -> 21;
                            case 208 -> 151;
                            case 209 -> 47;
                            case 210 -> 233;
                            case 211 -> 225;
                            case 212 -> 189;
                            case 213 -> 175;
                            case 214 -> 130;
                            case 215 -> 157;
                            case 216 -> 59;
                            case 217 -> 214;
                            case 218 -> 254;
                            case 219 -> 195;
                            case 220 -> 178;
                            case 221 -> 37;
                            case 222 -> 3;
                            case 223 -> 188;
                            case 224 -> 229;
                            case 225 -> 90;
                            case 226 -> 89;
                            case 227 -> 107;
                            case 228 -> 36;
                            case 229 -> 206;
                            case 230 -> 174;
                            case 231 -> 92;
                            case 232 -> 63;
                            case 233 -> 221;
                            case 234 -> 170;
                            case 235 -> 234;
                            case 236 -> 203;
                            case 237 -> 33;
                            case 238 -> 168;
                            case 239 -> 248;
                            case 240 -> 150;
                            case 241 -> 54;
                            case 242 -> 0;
                            case 243 -> 26;
                            case 244 -> 226;
                            case 245 -> 104;
                            case 246 -> 99;
                            case 247 -> 136;
                            case 248 -> 179;
                            case 249 -> 115;
                            case 250 -> 126;
                            case 251 -> 51;
                            case 252 -> 244;
                            case 253 -> 111;
                            case 254 -> 86;
                            default -> 69;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (!bl) {
                ActionTimestamp.Y(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 15671453778315L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.Y();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (bl2) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(881838960 + (char)-28365, -881838960 + -13643, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(881838960 + (char)-28361, 881838960 + (char)-29637, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(881838960 + (char)-28340, -881838960 + -26826, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(881838960 + (char)-28365, -881838960 + -13643, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(881838960 + (char)-28361, 881838960 + (char)-29637, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(881838960 + (char)-28341, -881838960 + -19749, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 18279963362858L;
                        boolean bl3 = SshAgentIpcService.Y();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-582606150 - -((char)-18335), 582606150 - (char)-28362, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-582606150 - -((char)-18338), -582606150 - -((char)-20478), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 105454415673881L;
                boolean bl2 = SshAgentIpcService.Y();
                this.assertConnectionThread();
                Object object2 = this.lock;
                bl = bl2;
                synchronized (object2) {
                    boolean bl3;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl4 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl5 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-83622660 + -24011, 83622660 + 2515, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-83622660 + -24007, -83622660 + -22723, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-83622660 + -24018, -83622660 + -8966, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl3 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl3) {
                        boolean bl6 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-83622660 + -24007, -83622660 + -22723, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-83622660 + -24009, 83622660 + 27758, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl7 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-83622660 + -24011, 83622660 + 2515, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-83622660 + -24007, -83622660 + -22723, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-83622660 + -24023, 83622660 + 3239, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl7 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-83622660 + -24011, 83622660 + 2515, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-83622660 + -24007, -83622660 + -22723, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-83622660 + -24024, 83622660 + 13542, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl8 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl9 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-83622660 + -24011, 83622660 + 2515, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-83622660 + -24007, -83622660 + -22723, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-83622660 + -24021, -83622660 + -17565, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 78952364653742L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                bl2 = SshAgentIpcService.Y();
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2019133350 + 23008, -2019133350 + -13818, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(2019133350 + 23004, 2019133350 + 25320, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2019133350 + 23019, 2019133350 + 1622, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(2019133350 + 23024, -2019133350 + -18318, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2019133350 + 23008, -2019133350 + -13818, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2019133350 + 23004, 2019133350 + 25320, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2019133350 + 23025, -2019133350 + -10774, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2019133350 + 23008, -2019133350 + -13818, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(2019133350 + 23004, 2019133350 + 25320, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2019133350 + 23022, 2019133350 - 11, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2019133350 + 23008, -2019133350 + -13818, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2019133350 + 23004, 2019133350 + 25320, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2019133350 + 23023, -2019133350 + -23698, (int)l2));
                    if (bl2) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2019133350 + 23008, -2019133350 + -13818, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2019133350 + 23004, 2019133350 + 25320, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2019133350 + 23044, 2019133350 + 25164, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2019133350 + 23045, -2019133350 + -2068, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00d5\u00c9.7\u00eb\u001d+\u00b2\u0014\u001a\u00b7\u00ef\u001f-\u0090\\\u0019\u00d1L\u001a\u00a4\u00dbe\u00d5\u00c9\u00d5\u00c6\u0086\u000b\u0006$\u00d8\u0010\u0015F\u0018\u0018\u0012N\u008e\u0010\u0083\u00b4\u008b]\u00e3\u00b9Sj\u0094Cn\u008f\u000bgs\u00a2\u00ab\n5/\t\u00f0\u00eeL\u00b5\u00b0\u009f\u00f5p\u0010\u0005\u00ad\u001f!\u00edz\b\u00a6\"@;t\u00ba\u00de\u00a4\u0014&\u0082\u0010\"\u00bf?;{S\u00dd\u00e1\"\u00ee\u0016\u00c8JdeI=\u0005\u008aJ\u00c5G\u00e6\u001e\u00e0\u00e2\u009d6p\u00b4W'\u00dd\u00e2\u00df\u0086I\u00few\\\u00c9\u008c\u00f9+V\u0014\u0086!\u00a7\u00ac8\u00be}\u00b6\u0010BE-\u00071\u00a0\u0089\\{?\u0086\u00c0dc}p\tr\u009b\u00ca\n3O\u00a3\u00f54\u0010\u0007\u00f2\u0085\u00f1$~+\u0087/D\f\u00af5\u008eW\u00cd?m0$lJ\u00f6\u0095\u0003\u00f4\u00b7\u00bf\u00d7\u00fa\"<\u00fee\u00bd\u0011\u00c8\u00c5:\u008f\u0082\u00960\u0013\u0099/\u0004\u00f8\u00f9\u00bd3\u00872\u00bc7\u00cb\u00c5\u00a5kJ\u00f6\u00b2\u00d2\u009a\u00de\u0089t\u00a8:P8\u00e4/r\u00a3\u0084'\u001e\u009f|\b\u00a4+\u0000\u001a|\u009e\u00df \fH\u0091\u008dV\u00d0u\u00a4Z\u00f7\u00b7E\u00d5F\u008a%\u00d5\u00c0\u00db\u00a7\u00c5\u0000\u00db\u00f0\u00ca\u00f9\u00c2\u00ef$a\u009a)\u00ee\u00f5(\u00cf1\u000ew\u008a\u00dc\u00c5i\u00a6\n\u0091\u00df\u0088\td\u00b7\u00b0\u0001\u00f1o\u00f8\u0098\u007f6f^5\u00f6\u00f1! \u008e\u00ed)\u008eT\u00e3\u00d6\u0093g`\u000f\u00d2\u0017dT\r\u00f3\u00f8\u001f\u00c5\u00a19^\u00e4\u00b9\u00c5\u0086\u008f\u00d6\u0095\u0000\u00003UT\u00f6ec\u00dc\u00cejBE^\u00f0\u0010\u00f9e\u00af\u0089\u000b\u00f3L\u00fa\u00ed>\u0002y\u00b4Lf8\u0015\u00da\u00e2\u00df;\u009d\u00b0\u00e1\u009fa\u00e3Um\u00a62\u009c\"4?\u00e6\u00eeH)\f\u00b7\u0000\u009c\u00c3\u00e1!\u008d\u0013\u00b7\u0006,v\u00bc\u0005\u00a0\u00a3s\u0012\u00b9\u0010\u00be_\u00c7\u0092\u00e9^\u00a2\u00830\u00d7}\u009a\u00b0\u00c7\u00eep\u00fcr\u00d1\u00a2\u0007gRg:\u000bh\u00a3\u0007u\u009cA\u008f(1\u00d1([\u00c1\u00a6s\u00a7v[X,\u00da\u00cb\u00b7\u00ecN\u0014}\u0086e\u001880\u00b04\u00cdo\u0014Wf\u0095\u00c8\u00ce{B\u001bB6z\u009a\u00a0\u00ee\u000f\u007f\u00bfl\u0095\u0016\u00c6\u00c8\u008d+\u00ed\u008a\u0000d\u00ec\u009b\"\u0007\u009ca\u00f9\u00efM\u00a4\u0018\u00a3\u0005\u0010z\u00b7zY\u00b6\u00c3\u0098\u0094\u0086*Y\u00b8k\u00fd(~D\u00a3\u00deq\u00a7`\u0018\u000e\u00e6\u00af_\u0097p\u0086\u0004\u0085\u00b2\u00ec\u00b9 \u000e\u00e2\u001b\u00f8\u00a2\u009b3\u0013\u00a7\u00fd\u00fd\u00dad90N\u00d6@5HBXA\u0088\u0095\u009fTR\u00a2\u00de\n\u00fbj?-\u0093\u0080>3\t\u00df\u00183\u0086\u00e2\u00ba=*\u0019\u0012XP\u00ab)\u00a5\u00a6\u00c1\u001a\u000f\u00a6g\u00a4\u0017b7\u00f9)\u0010\u00a3\u0083\u001e\u00b3\u00b1/\u0087\u00d2\u00f6>\u0004u\u00b0\u00faZ\"Y\u00fd9\u00d7\u00be\u00ee\u00cb\u00d1\u00fa\u00ab,n\u00bd\u00d1]\u007fj\u00ae!\u0083!\fjm\t\u00a1\u00df\u00b0\u009cvR]\rV";
                var4_3 = "\u00d5\u00c9.7\u00eb\u001d+\u00b2\u0014\u001a\u00b7\u00ef\u001f-\u0090\\\u0019\u00d1L\u001a\u00a4\u00dbe\u00d5\u00c9\u00d5\u00c6\u0086\u000b\u0006$\u00d8\u0010\u0015F\u0018\u0018\u0012N\u008e\u0010\u0083\u00b4\u008b]\u00e3\u00b9Sj\u0094Cn\u008f\u000bgs\u00a2\u00ab\n5/\t\u00f0\u00eeL\u00b5\u00b0\u009f\u00f5p\u0010\u0005\u00ad\u001f!\u00edz\b\u00a6\"@;t\u00ba\u00de\u00a4\u0014&\u0082\u0010\"\u00bf?;{S\u00dd\u00e1\"\u00ee\u0016\u00c8JdeI=\u0005\u008aJ\u00c5G\u00e6\u001e\u00e0\u00e2\u009d6p\u00b4W'\u00dd\u00e2\u00df\u0086I\u00few\\\u00c9\u008c\u00f9+V\u0014\u0086!\u00a7\u00ac8\u00be}\u00b6\u0010BE-\u00071\u00a0\u0089\\{?\u0086\u00c0dc}p\tr\u009b\u00ca\n3O\u00a3\u00f54\u0010\u0007\u00f2\u0085\u00f1$~+\u0087/D\f\u00af5\u008eW\u00cd?m0$lJ\u00f6\u0095\u0003\u00f4\u00b7\u00bf\u00d7\u00fa\"<\u00fee\u00bd\u0011\u00c8\u00c5:\u008f\u0082\u00960\u0013\u0099/\u0004\u00f8\u00f9\u00bd3\u00872\u00bc7\u00cb\u00c5\u00a5kJ\u00f6\u00b2\u00d2\u009a\u00de\u0089t\u00a8:P8\u00e4/r\u00a3\u0084'\u001e\u009f|\b\u00a4+\u0000\u001a|\u009e\u00df \fH\u0091\u008dV\u00d0u\u00a4Z\u00f7\u00b7E\u00d5F\u008a%\u00d5\u00c0\u00db\u00a7\u00c5\u0000\u00db\u00f0\u00ca\u00f9\u00c2\u00ef$a\u009a)\u00ee\u00f5(\u00cf1\u000ew\u008a\u00dc\u00c5i\u00a6\n\u0091\u00df\u0088\td\u00b7\u00b0\u0001\u00f1o\u00f8\u0098\u007f6f^5\u00f6\u00f1! \u008e\u00ed)\u008eT\u00e3\u00d6\u0093g`\u000f\u00d2\u0017dT\r\u00f3\u00f8\u001f\u00c5\u00a19^\u00e4\u00b9\u00c5\u0086\u008f\u00d6\u0095\u0000\u00003UT\u00f6ec\u00dc\u00cejBE^\u00f0\u0010\u00f9e\u00af\u0089\u000b\u00f3L\u00fa\u00ed>\u0002y\u00b4Lf8\u0015\u00da\u00e2\u00df;\u009d\u00b0\u00e1\u009fa\u00e3Um\u00a62\u009c\"4?\u00e6\u00eeH)\f\u00b7\u0000\u009c\u00c3\u00e1!\u008d\u0013\u00b7\u0006,v\u00bc\u0005\u00a0\u00a3s\u0012\u00b9\u0010\u00be_\u00c7\u0092\u00e9^\u00a2\u00830\u00d7}\u009a\u00b0\u00c7\u00eep\u00fcr\u00d1\u00a2\u0007gRg:\u000bh\u00a3\u0007u\u009cA\u008f(1\u00d1([\u00c1\u00a6s\u00a7v[X,\u00da\u00cb\u00b7\u00ecN\u0014}\u0086e\u001880\u00b04\u00cdo\u0014Wf\u0095\u00c8\u00ce{B\u001bB6z\u009a\u00a0\u00ee\u000f\u007f\u00bfl\u0095\u0016\u00c6\u00c8\u008d+\u00ed\u008a\u0000d\u00ec\u009b\"\u0007\u009ca\u00f9\u00efM\u00a4\u0018\u00a3\u0005\u0010z\u00b7zY\u00b6\u00c3\u0098\u0094\u0086*Y\u00b8k\u00fd(~D\u00a3\u00deq\u00a7`\u0018\u000e\u00e6\u00af_\u0097p\u0086\u0004\u0085\u00b2\u00ec\u00b9 \u000e\u00e2\u001b\u00f8\u00a2\u009b3\u0013\u00a7\u00fd\u00fd\u00dad90N\u00d6@5HBXA\u0088\u0095\u009fTR\u00a2\u00de\n\u00fbj?-\u0093\u0080>3\t\u00df\u00183\u0086\u00e2\u00ba=*\u0019\u0012XP\u00ab)\u00a5\u00a6\u00c1\u001a\u000f\u00a6g\u00a4\u0017b7\u00f9)\u0010\u00a3\u0083\u001e\u00b3\u00b1/\u0087\u00d2\u00f6>\u0004u\u00b0\u00faZ\"Y\u00fd9\u00d7\u00be\u00ee\u00cb\u00d1\u00fa\u00ab,n\u00bd\u00d1]\u007fj\u00ae!\u0083!\fjm\t\u00a1\u00df\u00b0\u009cvR]\rV".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 65;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00b8\u001cY&'yrQ\u00b6\u00e3}i\u00d2\u00d2\u00c1\u00d9\u008a\u00eaw\u0004\u001c\u00e9\u00ab0\u001dVl3\u00c9\u0014t\u00e8\u00ed;\u00a2\u00dbb\u00bf\u00d9W\u00d4\b\u00cd?\u00d8M\u00bb\u0099\u0084/";
                    var4_3 = "\u00b8\u001cY&'yrQ\u00b6\u00e3}i\u00d2\u00d2\u00c1\u00d9\u008a\u00eaw\u0004\u001c\u00e9\u00ab0\u001dVl3\u00c9\u0014t\u00e8\u00ed;\u00a2\u00dbb\u00bf\u00d9W\u00d4\b\u00cd?\u00d8M\u00bb\u0099\u0084/".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 79;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 31;
                            break;
                        }
                        case 1: {
                            v15 = 56;
                            break;
                        }
                        case 2: {
                            v15 = 16;
                            break;
                        }
                        case 3: {
                            v15 = 65;
                            break;
                        }
                        case 4: {
                            v15 = 107;
                            break;
                        }
                        case 5: {
                            v15 = 18;
                            break;
                        }
                        default: {
                            v15 = 124;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFDD24) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 235;
                case 1 -> 77;
                case 2 -> 82;
                case 3 -> 213;
                case 4 -> 60;
                case 5 -> 202;
                case 6 -> 19;
                case 7 -> 47;
                case 8 -> 249;
                case 9 -> 88;
                case 10 -> 42;
                case 11 -> 33;
                case 12 -> 227;
                case 13 -> 253;
                case 14 -> 224;
                case 15 -> 75;
                case 16 -> 61;
                case 17 -> 184;
                case 18 -> 167;
                case 19 -> 83;
                case 20 -> 74;
                case 21 -> 95;
                case 22 -> 137;
                case 23 -> 136;
                case 24 -> 37;
                case 25 -> 41;
                case 26 -> 90;
                case 27 -> 248;
                case 28 -> 200;
                case 29 -> 117;
                case 30 -> 121;
                case 31 -> 43;
                case 32 -> 172;
                case 33 -> 151;
                case 34 -> 21;
                case 35 -> 131;
                case 36 -> 123;
                case 37 -> 229;
                case 38 -> 247;
                case 39 -> 156;
                case 40 -> 30;
                case 41 -> 28;
                case 42 -> 102;
                case 43 -> 62;
                case 44 -> 169;
                case 45 -> 245;
                case 46 -> 218;
                case 47 -> 122;
                case 48 -> 73;
                case 49 -> 176;
                case 50 -> 240;
                case 51 -> 173;
                case 52 -> 222;
                case 53 -> 24;
                case 54 -> 23;
                case 55 -> 185;
                case 56 -> 78;
                case 57 -> 241;
                case 58 -> 97;
                case 59 -> 126;
                case 60 -> 39;
                case 61 -> 38;
                case 62 -> 243;
                case 63 -> 59;
                case 64 -> 91;
                case 65 -> 50;
                case 66 -> 85;
                case 67 -> 6;
                case 68 -> 116;
                case 69 -> 31;
                case 70 -> 251;
                case 71 -> 65;
                case 72 -> 129;
                case 73 -> 25;
                case 74 -> 48;
                case 75 -> 162;
                case 76 -> 204;
                case 77 -> 145;
                case 78 -> 193;
                case 79 -> 139;
                case 80 -> 210;
                case 81 -> 27;
                case 82 -> 120;
                case 83 -> 152;
                case 84 -> 103;
                case 85 -> 205;
                case 86 -> 107;
                case 87 -> 146;
                case 88 -> 255;
                case 89 -> 144;
                case 90 -> 252;
                case 91 -> 108;
                case 92 -> 148;
                case 93 -> 183;
                case 94 -> 29;
                case 95 -> 32;
                case 96 -> 203;
                case 97 -> 115;
                case 98 -> 100;
                case 99 -> 98;
                case 100 -> 106;
                case 101 -> 159;
                case 102 -> 34;
                case 103 -> 128;
                case 104 -> 180;
                case 105 -> 236;
                case 106 -> 87;
                case 107 -> 18;
                case 108 -> 130;
                case 109 -> 147;
                case 110 -> 242;
                case 111 -> 223;
                case 112 -> 4;
                case 113 -> 209;
                case 114 -> 250;
                case 115 -> 22;
                case 116 -> 111;
                case 117 -> 110;
                case 118 -> 244;
                case 119 -> 1;
                case 120 -> 105;
                case 121 -> 219;
                case 122 -> 197;
                case 123 -> 112;
                case 124 -> 84;
                case 125 -> 132;
                case 126 -> 187;
                case 127 -> 118;
                case 128 -> 56;
                case 129 -> 10;
                case 130 -> 46;
                case 131 -> 113;
                case 132 -> 143;
                case 133 -> 225;
                case 134 -> 215;
                case 135 -> 254;
                case 136 -> 119;
                case 137 -> 206;
                case 138 -> 231;
                case 139 -> 49;
                case 140 -> 127;
                case 141 -> 237;
                case 142 -> 69;
                case 143 -> 79;
                case 144 -> 58;
                case 145 -> 0;
                case 146 -> 140;
                case 147 -> 13;
                case 148 -> 149;
                case 149 -> 150;
                case 150 -> 14;
                case 151 -> 214;
                case 152 -> 8;
                case 153 -> 80;
                case 154 -> 166;
                case 155 -> 246;
                case 156 -> 181;
                case 157 -> 3;
                case 158 -> 71;
                case 159 -> 99;
                case 160 -> 20;
                case 161 -> 153;
                case 162 -> 142;
                case 163 -> 55;
                case 164 -> 199;
                case 165 -> 217;
                case 166 -> 182;
                case 167 -> 68;
                case 168 -> 141;
                case 169 -> 15;
                case 170 -> 178;
                case 171 -> 230;
                case 172 -> 211;
                case 173 -> 160;
                case 174 -> 170;
                case 175 -> 67;
                case 176 -> 191;
                case 177 -> 9;
                case 178 -> 76;
                case 179 -> 81;
                case 180 -> 190;
                case 181 -> 40;
                case 182 -> 135;
                case 183 -> 195;
                case 184 -> 196;
                case 185 -> 220;
                case 186 -> 2;
                case 187 -> 221;
                case 188 -> 11;
                case 189 -> 66;
                case 190 -> 134;
                case 191 -> 216;
                case 192 -> 233;
                case 193 -> 36;
                case 194 -> 96;
                case 195 -> 72;
                case 196 -> 234;
                case 197 -> 92;
                case 198 -> 154;
                case 199 -> 226;
                case 200 -> 54;
                case 201 -> 101;
                case 202 -> 94;
                case 203 -> 194;
                case 204 -> 228;
                case 205 -> 239;
                case 206 -> 201;
                case 207 -> 5;
                case 208 -> 86;
                case 209 -> 45;
                case 210 -> 53;
                case 211 -> 35;
                case 212 -> 124;
                case 213 -> 133;
                case 214 -> 104;
                case 215 -> 125;
                case 216 -> 174;
                case 217 -> 238;
                case 218 -> 52;
                case 219 -> 57;
                case 220 -> 64;
                case 221 -> 70;
                case 222 -> 163;
                case 223 -> 198;
                case 224 -> 17;
                case 225 -> 207;
                case 226 -> 51;
                case 227 -> 89;
                case 228 -> 179;
                case 229 -> 192;
                case 230 -> 232;
                case 231 -> 188;
                case 232 -> 138;
                case 233 -> 12;
                case 234 -> 177;
                case 235 -> 44;
                case 236 -> 212;
                case 237 -> 157;
                case 238 -> 208;
                case 239 -> 16;
                case 240 -> 168;
                case 241 -> 158;
                case 242 -> 7;
                case 243 -> 26;
                case 244 -> 155;
                case 245 -> 165;
                case 246 -> 63;
                case 247 -> 114;
                case 248 -> 175;
                case 249 -> 186;
                case 250 -> 171;
                case 251 -> 189;
                case 252 -> 109;
                case 253 -> 164;
                case 254 -> 93;
                default -> 161;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 78866523086213L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1961331480 + -((char)-25538), -1961331480 + -((char)-16777), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 121707413736249L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.Y();
                            try {
                                hANDLE2 = hANDLE;
                                if (bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(925485270 - 15039, -925485270 + -4127, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(925485270 - 15042, 925485270 + 11555, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(925485270 - 15041, -925485270 + -2200, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00f3\r\u00ab\u00f1R\u00cf\u007fX\u0010-\u00bb\u0081\u0086\u00ad\u009ay\u00ab-\u0080\u0012>\u00fc\u00df\u00de\u00af";
                    var4_3 = "\u00f3\r\u00ab\u00f1R\u00cf\u007fX\u0010-\u00bb\u0081\u0086\u00ad\u009ay\u00ab-\u0080\u0012>\u00fc\u00df\u00de\u00af".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 30;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a7\u001e\u0012\u00a0&5tz\u007f@YH\u00cci\u00dfP\u00ed\u00d7\u00c7;\u008f\u008a\u007f\u0097\u00ff%T\u0081j\u00d3&\u008f#\u0014:\u00fe\u00f9\u008c[\u0018\u000f\u0095\u0013\u009b\u0017\u0001\u00b7\u008c\u001c\u0099_\u00b9\u00ef\u0018\u00c3\u00d9\u0089\u00d8\\";
                        var4_3 = "\u00a7\u001e\u0012\u00a0&5tz\u007f@YH\u00cci\u00dfP\u00ed\u00d7\u00c7;\u008f\u008a\u007f\u0097\u00ff%T\u0081j\u00d3&\u008f#\u0014:\u00fe\u00f9\u008c[\u0018\u000f\u0095\u0013\u009b\u0017\u0001\u00b7\u008c\u001c\u0099_\u00b9\u00ef\u0018\u00c3\u00d9\u0089\u00d8\\".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 15;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 88;
                                break;
                            }
                            case 1: {
                                v15 = 70;
                                break;
                            }
                            case 2: {
                                v15 = 13;
                                break;
                            }
                            case 3: {
                                v15 = 100;
                                break;
                            }
                            case 4: {
                                v15 = 117;
                                break;
                            }
                            case 5: {
                                v15 = 8;
                                break;
                            }
                            default: {
                                v15 = 104;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x52F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 19;
                    case 1 -> 25;
                    case 2 -> 127;
                    case 3 -> 158;
                    case 4 -> 120;
                    case 5 -> 124;
                    case 6 -> 101;
                    case 7 -> 87;
                    case 8 -> 76;
                    case 9 -> 86;
                    case 10 -> 168;
                    case 11 -> 51;
                    case 12 -> 154;
                    case 13 -> 27;
                    case 14 -> 243;
                    case 15 -> 208;
                    case 16 -> 24;
                    case 17 -> 70;
                    case 18 -> 20;
                    case 19 -> 141;
                    case 20 -> 143;
                    case 21 -> 153;
                    case 22 -> 95;
                    case 23 -> 69;
                    case 24 -> 98;
                    case 25 -> 160;
                    case 26 -> 222;
                    case 27 -> 181;
                    case 28 -> 71;
                    case 29 -> 248;
                    case 30 -> 196;
                    case 31 -> 56;
                    case 32 -> 183;
                    case 33 -> 137;
                    case 34 -> 128;
                    case 35 -> 146;
                    case 36 -> 224;
                    case 37 -> 197;
                    case 38 -> 6;
                    case 39 -> 59;
                    case 40 -> 39;
                    case 41 -> 92;
                    case 42 -> 58;
                    case 43 -> 190;
                    case 44 -> 250;
                    case 45 -> 52;
                    case 46 -> 23;
                    case 47 -> 178;
                    case 48 -> 9;
                    case 49 -> 191;
                    case 50 -> 206;
                    case 51 -> 193;
                    case 52 -> 104;
                    case 53 -> 26;
                    case 54 -> 241;
                    case 55 -> 108;
                    case 56 -> 149;
                    case 57 -> 244;
                    case 58 -> 14;
                    case 59 -> 200;
                    case 60 -> 72;
                    case 61 -> 110;
                    case 62 -> 255;
                    case 63 -> 148;
                    case 64 -> 171;
                    case 65 -> 219;
                    case 66 -> 112;
                    case 67 -> 118;
                    case 68 -> 142;
                    case 69 -> 145;
                    case 70 -> 202;
                    case 71 -> 73;
                    case 72 -> 152;
                    case 73 -> 176;
                    case 74 -> 150;
                    case 75 -> 32;
                    case 76 -> 235;
                    case 77 -> 205;
                    case 78 -> 133;
                    case 79 -> 99;
                    case 80 -> 79;
                    case 81 -> 84;
                    case 82 -> 174;
                    case 83 -> 37;
                    case 84 -> 170;
                    case 85 -> 159;
                    case 86 -> 55;
                    case 87 -> 207;
                    case 88 -> 211;
                    case 89 -> 135;
                    case 90 -> 57;
                    case 91 -> 29;
                    case 92 -> 74;
                    case 93 -> 185;
                    case 94 -> 77;
                    case 95 -> 169;
                    case 96 -> 122;
                    case 97 -> 132;
                    case 98 -> 173;
                    case 99 -> 91;
                    case 100 -> 89;
                    case 101 -> 68;
                    case 102 -> 234;
                    case 103 -> 65;
                    case 104 -> 179;
                    case 105 -> 221;
                    case 106 -> 54;
                    case 107 -> 38;
                    case 108 -> 81;
                    case 109 -> 189;
                    case 110 -> 216;
                    case 111 -> 187;
                    case 112 -> 53;
                    case 113 -> 62;
                    case 114 -> 7;
                    case 115 -> 105;
                    case 116 -> 80;
                    case 117 -> 139;
                    case 118 -> 96;
                    case 119 -> 33;
                    case 120 -> 242;
                    case 121 -> 125;
                    case 122 -> 228;
                    case 123 -> 252;
                    case 124 -> 214;
                    case 125 -> 130;
                    case 126 -> 67;
                    case 127 -> 204;
                    case 128 -> 40;
                    case 129 -> 100;
                    case 130 -> 223;
                    case 131 -> 44;
                    case 132 -> 115;
                    case 133 -> 151;
                    case 134 -> 212;
                    case 135 -> 233;
                    case 136 -> 220;
                    case 137 -> 226;
                    case 138 -> 144;
                    case 139 -> 186;
                    case 140 -> 82;
                    case 141 -> 3;
                    case 142 -> 90;
                    case 143 -> 157;
                    case 144 -> 253;
                    case 145 -> 156;
                    case 146 -> 165;
                    case 147 -> 36;
                    case 148 -> 1;
                    case 149 -> 48;
                    case 150 -> 238;
                    case 151 -> 194;
                    case 152 -> 88;
                    case 153 -> 129;
                    case 154 -> 203;
                    case 155 -> 201;
                    case 156 -> 131;
                    case 157 -> 10;
                    case 158 -> 172;
                    case 159 -> 199;
                    case 160 -> 116;
                    case 161 -> 5;
                    case 162 -> 175;
                    case 163 -> 195;
                    case 164 -> 8;
                    case 165 -> 251;
                    case 166 -> 217;
                    case 167 -> 180;
                    case 168 -> 209;
                    case 169 -> 229;
                    case 170 -> 85;
                    case 171 -> 121;
                    case 172 -> 225;
                    case 173 -> 113;
                    case 174 -> 17;
                    case 175 -> 240;
                    case 176 -> 107;
                    case 177 -> 93;
                    case 178 -> 136;
                    case 179 -> 147;
                    case 180 -> 245;
                    case 181 -> 47;
                    case 182 -> 22;
                    case 183 -> 106;
                    case 184 -> 21;
                    case 185 -> 75;
                    case 186 -> 41;
                    case 187 -> 227;
                    case 188 -> 167;
                    case 189 -> 254;
                    case 190 -> 155;
                    case 191 -> 249;
                    case 192 -> 237;
                    case 193 -> 198;
                    case 194 -> 16;
                    case 195 -> 49;
                    case 196 -> 236;
                    case 197 -> 239;
                    case 198 -> 0;
                    case 199 -> 192;
                    case 200 -> 94;
                    case 201 -> 66;
                    case 202 -> 97;
                    case 203 -> 13;
                    case 204 -> 83;
                    case 205 -> 164;
                    case 206 -> 18;
                    case 207 -> 231;
                    case 208 -> 46;
                    case 209 -> 230;
                    case 210 -> 15;
                    case 211 -> 50;
                    case 212 -> 61;
                    case 213 -> 43;
                    case 214 -> 138;
                    case 215 -> 123;
                    case 216 -> 162;
                    case 217 -> 34;
                    case 218 -> 163;
                    case 219 -> 213;
                    case 220 -> 232;
                    case 221 -> 78;
                    case 222 -> 166;
                    case 223 -> 63;
                    case 224 -> 246;
                    case 225 -> 109;
                    case 226 -> 60;
                    case 227 -> 114;
                    case 228 -> 103;
                    case 229 -> 31;
                    case 230 -> 11;
                    case 231 -> 119;
                    case 232 -> 30;
                    case 233 -> 45;
                    case 234 -> 218;
                    case 235 -> 126;
                    case 236 -> 188;
                    case 237 -> 215;
                    case 238 -> 2;
                    case 239 -> 42;
                    case 240 -> 64;
                    case 241 -> 4;
                    case 242 -> 117;
                    case 243 -> 184;
                    case 244 -> 177;
                    case 245 -> 182;
                    case 246 -> 35;
                    case 247 -> 111;
                    case 248 -> 12;
                    case 249 -> 134;
                    case 250 -> 247;
                    case 251 -> 210;
                    case 252 -> 28;
                    case 253 -> 140;
                    case 254 -> 102;
                    default -> 161;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 125624742694640L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "Nb\n2yO6\u0017\tIh\u001984\r+\u000b.";
                    var5_4 = "Nb\n2yO6\u0017\tIh\u001984\r+\u000b.".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 34;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 7;
                                    break;
                                }
                                case 1: {
                                    v11 = 37;
                                    break;
                                }
                                case 2: {
                                    v11 = 90;
                                    break;
                                }
                                case 3: {
                                    v11 = 126;
                                    break;
                                }
                                case 4: {
                                    v11 = 62;
                                    break;
                                }
                                case 5: {
                                    v11 = 1;
                                    break;
                                }
                                default: {
                                    v11 = 39;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 86325679797664L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "u\\G|\u0004I\u0019\u0004sBKf\n\u007f]@f\bK\u0001U\\I\t\u007f]@f\bK\u0001YV\rx[]k\u0002F\u001bYQZa\u0003O";
                    var5_4 = "u\\G|\u0004I\u0019\u0004sBKf\n\u007f]@f\bK\u0001U\\I\t\u007f]@f\bK\u0001YV\rx[]k\u0002F\u001bYQZa\u0003O".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 95;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "WviS,n:\u0006WviS d";
                        var5_4 = "WviS,n:\u0006WviS d".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 119;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 99;
                                break;
                            }
                            case 1: {
                                v15 = 109;
                                break;
                            }
                            case 2: {
                                v15 = 113;
                                break;
                            }
                            case 3: {
                                v15 = 87;
                                break;
                            }
                            case 4: {
                                v15 = 50;
                                break;
                            }
                            case 5: {
                                v15 = 119;
                                break;
                            }
                            default: {
                                v15 = 42;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 20351094318653L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1539286080 - -22209, -1539286080 - -23853, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 63890009989390L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00a6\u0091K\u00e5U\u0003\rZ\u008a\u0005>\u00f5~\u00ad\u0010\r\u00f0\u000b\u00918\u0018Z\u00f4\u00a6\u00af\u00c9\u00e2\u00d2\u0086\u0010\u0017\u00bf\u00aaE@`\u00d4\u00dcb\u0002\u00b8\u00e6+\u00d4\f4\u0005\u001bL\u00da\u009a\u00843M \u0001`\u00e0\u0080\u00f0\u00d4\u009b\u00fe\fP{S*\u00db\u00a4\u00d6H\u00bc&\u00af\u008b\u00c1\u00a1\u00e9\u008b\u00ad\u008a\u00b4\u008f\u00e8\u00ef\u0083Z\u0096\u008a\u00e6\u00e4\u001f\u00e56\\5y.\u00feqK\u00df\u00a1";
                    var4_3 = "\u00a6\u0091K\u00e5U\u0003\rZ\u008a\u0005>\u00f5~\u00ad\u0010\r\u00f0\u000b\u00918\u0018Z\u00f4\u00a6\u00af\u00c9\u00e2\u00d2\u0086\u0010\u0017\u00bf\u00aaE@`\u00d4\u00dcb\u0002\u00b8\u00e6+\u00d4\f4\u0005\u001bL\u00da\u009a\u00843M \u0001`\u00e0\u0080\u00f0\u00d4\u009b\u00fe\fP{S*\u00db\u00a4\u00d6H\u00bc&\u00af\u008b\u00c1\u00a1\u00e9\u008b\u00ad\u008a\u00b4\u008f\u00e8\u00ef\u0083Z\u0096\u008a\u00e6\u00e4\u001f\u00e56\\5y.\u00feqK\u00df\u00a1".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 107;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d8\\\u0003i%\u00b5(6\u00ad\u000f\u0011\u0017N\u00ba\u00f0\u00a9Lat\u00c3\u00a6\u0017\u0084\u0000~!\u0095,\u00fd\u00e7iV\u00aa~y\u00bc\u00ef\u0080\u00f1%\u00f8\u0007u*\u00a8\u0014\r\u00e3\u00e0\"<\u00c2-\u00fb\u001f\u00a0\u0016\u000b\u00ba\u001e\u0089t7\u00c4:\u00ae\u00d2\u00a5\"\u00933\u00bb\u009fU\u0083\u00d2W11\u0012E#\u00ebeL\u00a4\u00a4h\u00c3Vk\u00b4:";
                        var4_3 = "\u00d8\\\u0003i%\u00b5(6\u00ad\u000f\u0011\u0017N\u00ba\u00f0\u00a9Lat\u00c3\u00a6\u0017\u0084\u0000~!\u0095,\u00fd\u00e7iV\u00aa~y\u00bc\u00ef\u0080\u00f1%\u00f8\u0007u*\u00a8\u0014\r\u00e3\u00e0\"<\u00c2-\u00fb\u001f\u00a0\u0016\u000b\u00ba\u001e\u0089t7\u00c4:\u00ae\u00d2\u00a5\"\u00933\u00bb\u009fU\u0083\u00d2W11\u0012E#\u00ebeL\u00a4\u00a4h\u00c3Vk\u00b4:".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 121;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 100;
                                break;
                            }
                            case 1: {
                                v15 = 75;
                                break;
                            }
                            case 2: {
                                v15 = 61;
                                break;
                            }
                            case 3: {
                                v15 = 93;
                                break;
                            }
                            case 4: {
                                v15 = 32;
                                break;
                            }
                            case 5: {
                                v15 = 118;
                                break;
                            }
                            default: {
                                v15 = 9;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD4BC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 242;
                    case 1 -> 75;
                    case 2 -> 171;
                    case 3 -> 202;
                    case 4 -> 28;
                    case 5 -> 208;
                    case 6 -> 1;
                    case 7 -> 104;
                    case 8 -> 254;
                    case 9 -> 49;
                    case 10 -> 60;
                    case 11 -> 52;
                    case 12 -> 200;
                    case 13 -> 66;
                    case 14 -> 195;
                    case 15 -> 89;
                    case 16 -> 236;
                    case 17 -> 129;
                    case 18 -> 44;
                    case 19 -> 192;
                    case 20 -> 77;
                    case 21 -> 88;
                    case 22 -> 181;
                    case 23 -> 14;
                    case 24 -> 148;
                    case 25 -> 164;
                    case 26 -> 194;
                    case 27 -> 249;
                    case 28 -> 216;
                    case 29 -> 136;
                    case 30 -> 176;
                    case 31 -> 29;
                    case 32 -> 123;
                    case 33 -> 239;
                    case 34 -> 212;
                    case 35 -> 215;
                    case 36 -> 105;
                    case 37 -> 211;
                    case 38 -> 39;
                    case 39 -> 214;
                    case 40 -> 152;
                    case 41 -> 84;
                    case 42 -> 172;
                    case 43 -> 61;
                    case 44 -> 177;
                    case 45 -> 95;
                    case 46 -> 117;
                    case 47 -> 100;
                    case 48 -> 156;
                    case 49 -> 54;
                    case 50 -> 56;
                    case 51 -> 15;
                    case 52 -> 59;
                    case 53 -> 180;
                    case 54 -> 146;
                    case 55 -> 113;
                    case 56 -> 227;
                    case 57 -> 233;
                    case 58 -> 167;
                    case 59 -> 226;
                    case 60 -> 128;
                    case 61 -> 7;
                    case 62 -> 137;
                    case 63 -> 186;
                    case 64 -> 221;
                    case 65 -> 198;
                    case 66 -> 106;
                    case 67 -> 32;
                    case 68 -> 244;
                    case 69 -> 133;
                    case 70 -> 125;
                    case 71 -> 154;
                    case 72 -> 230;
                    case 73 -> 188;
                    case 74 -> 20;
                    case 75 -> 50;
                    case 76 -> 0;
                    case 77 -> 68;
                    case 78 -> 92;
                    case 79 -> 250;
                    case 80 -> 5;
                    case 81 -> 174;
                    case 82 -> 135;
                    case 83 -> 255;
                    case 84 -> 121;
                    case 85 -> 21;
                    case 86 -> 80;
                    case 87 -> 103;
                    case 88 -> 131;
                    case 89 -> 142;
                    case 90 -> 81;
                    case 91 -> 143;
                    case 92 -> 204;
                    case 93 -> 189;
                    case 94 -> 114;
                    case 95 -> 151;
                    case 96 -> 76;
                    case 97 -> 153;
                    case 98 -> 241;
                    case 99 -> 46;
                    case 100 -> 223;
                    case 101 -> 33;
                    case 102 -> 240;
                    case 103 -> 62;
                    case 104 -> 170;
                    case 105 -> 196;
                    case 106 -> 161;
                    case 107 -> 107;
                    case 108 -> 110;
                    case 109 -> 102;
                    case 110 -> 94;
                    case 111 -> 35;
                    case 112 -> 220;
                    case 113 -> 47;
                    case 114 -> 73;
                    case 115 -> 159;
                    case 116 -> 162;
                    case 117 -> 40;
                    case 118 -> 18;
                    case 119 -> 38;
                    case 120 -> 12;
                    case 121 -> 13;
                    case 122 -> 124;
                    case 123 -> 74;
                    case 124 -> 23;
                    case 125 -> 26;
                    case 126 -> 157;
                    case 127 -> 243;
                    case 128 -> 31;
                    case 129 -> 63;
                    case 130 -> 149;
                    case 131 -> 139;
                    case 132 -> 55;
                    case 133 -> 9;
                    case 134 -> 115;
                    case 135 -> 93;
                    case 136 -> 163;
                    case 137 -> 120;
                    case 138 -> 253;
                    case 139 -> 219;
                    case 140 -> 132;
                    case 141 -> 57;
                    case 142 -> 225;
                    case 143 -> 43;
                    case 144 -> 111;
                    case 145 -> 178;
                    case 146 -> 247;
                    case 147 -> 11;
                    case 148 -> 191;
                    case 149 -> 173;
                    case 150 -> 190;
                    case 151 -> 116;
                    case 152 -> 45;
                    case 153 -> 222;
                    case 154 -> 138;
                    case 155 -> 237;
                    case 156 -> 24;
                    case 157 -> 203;
                    case 158 -> 228;
                    case 159 -> 182;
                    case 160 -> 246;
                    case 161 -> 101;
                    case 162 -> 251;
                    case 163 -> 109;
                    case 164 -> 175;
                    case 165 -> 96;
                    case 166 -> 224;
                    case 167 -> 64;
                    case 168 -> 150;
                    case 169 -> 8;
                    case 170 -> 78;
                    case 171 -> 184;
                    case 172 -> 217;
                    case 173 -> 83;
                    case 174 -> 130;
                    case 175 -> 126;
                    case 176 -> 206;
                    case 177 -> 187;
                    case 178 -> 229;
                    case 179 -> 185;
                    case 180 -> 218;
                    case 181 -> 70;
                    case 182 -> 25;
                    case 183 -> 213;
                    case 184 -> 17;
                    case 185 -> 127;
                    case 186 -> 10;
                    case 187 -> 205;
                    case 188 -> 234;
                    case 189 -> 118;
                    case 190 -> 197;
                    case 191 -> 16;
                    case 192 -> 2;
                    case 193 -> 37;
                    case 194 -> 41;
                    case 195 -> 86;
                    case 196 -> 165;
                    case 197 -> 169;
                    case 198 -> 248;
                    case 199 -> 42;
                    case 200 -> 19;
                    case 201 -> 108;
                    case 202 -> 51;
                    case 203 -> 207;
                    case 204 -> 166;
                    case 205 -> 158;
                    case 206 -> 199;
                    case 207 -> 183;
                    case 208 -> 144;
                    case 209 -> 201;
                    case 210 -> 209;
                    case 211 -> 4;
                    case 212 -> 141;
                    case 213 -> 90;
                    case 214 -> 82;
                    case 215 -> 22;
                    case 216 -> 179;
                    case 217 -> 6;
                    case 218 -> 210;
                    case 219 -> 71;
                    case 220 -> 122;
                    case 221 -> 232;
                    case 222 -> 36;
                    case 223 -> 58;
                    case 224 -> 245;
                    case 225 -> 91;
                    case 226 -> 97;
                    case 227 -> 27;
                    case 228 -> 252;
                    case 229 -> 85;
                    case 230 -> 48;
                    case 231 -> 87;
                    case 232 -> 67;
                    case 233 -> 119;
                    case 234 -> 65;
                    case 235 -> 3;
                    case 236 -> 238;
                    case 237 -> 160;
                    case 238 -> 140;
                    case 239 -> 98;
                    case 240 -> 72;
                    case 241 -> 34;
                    case 242 -> 155;
                    case 243 -> 112;
                    case 244 -> 231;
                    case 245 -> 193;
                    case 246 -> 69;
                    case 247 -> 235;
                    case 248 -> 53;
                    case 249 -> 147;
                    case 250 -> 168;
                    case 251 -> 134;
                    case 252 -> 79;
                    case 253 -> 30;
                    case 254 -> 99;
                    default -> 145;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 19543821018850L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1719769470 + -((char)-12203), 1719769470 + 28911, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 81914441611575L;
                    boolean bl = SshAgentIpcService.s();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-825347790 - -6343, -825347790 + -8905, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (!bl2) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 20595458954357L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "E\u00fd\u00ab\u00173\u0003\u00e3\u0010)";
                var4_3 = "E\u00fd\u00ab\u00173\u0003\u00e3\u0010)".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 57;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 3;
                                break;
                            }
                            case 1: {
                                v11 = 88;
                                break;
                            }
                            case 2: {
                                v11 = 85;
                                break;
                            }
                            case 3: {
                                v11 = 88;
                                break;
                            }
                            case 4: {
                                v11 = 79;
                                break;
                            }
                            case 5: {
                                v11 = 109;
                                break;
                            }
                            default: {
                                v11 = 88;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF0CF) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 220;
                    case 1 -> 151;
                    case 2 -> 35;
                    case 3 -> 14;
                    case 4 -> 181;
                    case 5 -> 132;
                    case 6 -> 10;
                    case 7 -> 87;
                    case 8 -> 166;
                    case 9 -> 76;
                    case 10 -> 233;
                    case 11 -> 165;
                    case 12 -> 192;
                    case 13 -> 175;
                    case 14 -> 72;
                    case 15 -> 252;
                    case 16 -> 167;
                    case 17 -> 125;
                    case 18 -> 24;
                    case 19 -> 75;
                    case 20 -> 217;
                    case 21 -> 64;
                    case 22 -> 144;
                    case 23 -> 148;
                    case 24 -> 68;
                    case 25 -> 123;
                    case 26 -> 12;
                    case 27 -> 85;
                    case 28 -> 0;
                    case 29 -> 152;
                    case 30 -> 172;
                    case 31 -> 210;
                    case 32 -> 241;
                    case 33 -> 173;
                    case 34 -> 1;
                    case 35 -> 164;
                    case 36 -> 40;
                    case 37 -> 70;
                    case 38 -> 248;
                    case 39 -> 161;
                    case 40 -> 251;
                    case 41 -> 207;
                    case 42 -> 250;
                    case 43 -> 177;
                    case 44 -> 228;
                    case 45 -> 51;
                    case 46 -> 214;
                    case 47 -> 17;
                    case 48 -> 239;
                    case 49 -> 115;
                    case 50 -> 34;
                    case 51 -> 3;
                    case 52 -> 184;
                    case 53 -> 235;
                    case 54 -> 222;
                    case 55 -> 74;
                    case 56 -> 9;
                    case 57 -> 37;
                    case 58 -> 99;
                    case 59 -> 23;
                    case 60 -> 232;
                    case 61 -> 19;
                    case 62 -> 71;
                    case 63 -> 246;
                    case 64 -> 43;
                    case 65 -> 190;
                    case 66 -> 83;
                    case 67 -> 212;
                    case 68 -> 142;
                    case 69 -> 7;
                    case 70 -> 219;
                    case 71 -> 80;
                    case 72 -> 81;
                    case 73 -> 126;
                    case 74 -> 84;
                    case 75 -> 55;
                    case 76 -> 36;
                    case 77 -> 114;
                    case 78 -> 209;
                    case 79 -> 168;
                    case 80 -> 156;
                    case 81 -> 218;
                    case 82 -> 67;
                    case 83 -> 11;
                    case 84 -> 230;
                    case 85 -> 100;
                    case 86 -> 146;
                    case 87 -> 199;
                    case 88 -> 196;
                    case 89 -> 234;
                    case 90 -> 25;
                    case 91 -> 198;
                    case 92 -> 127;
                    case 93 -> 27;
                    case 94 -> 134;
                    case 95 -> 62;
                    case 96 -> 31;
                    case 97 -> 21;
                    case 98 -> 119;
                    case 99 -> 176;
                    case 100 -> 109;
                    case 101 -> 183;
                    case 102 -> 86;
                    case 103 -> 242;
                    case 104 -> 238;
                    case 105 -> 93;
                    case 106 -> 143;
                    case 107 -> 163;
                    case 108 -> 90;
                    case 109 -> 229;
                    case 110 -> 57;
                    case 111 -> 48;
                    case 112 -> 231;
                    case 113 -> 159;
                    case 114 -> 94;
                    case 115 -> 121;
                    case 116 -> 102;
                    case 117 -> 60;
                    case 118 -> 243;
                    case 119 -> 107;
                    case 120 -> 227;
                    case 121 -> 91;
                    case 122 -> 5;
                    case 123 -> 182;
                    case 124 -> 112;
                    case 125 -> 110;
                    case 126 -> 106;
                    case 127 -> 113;
                    case 128 -> 63;
                    case 129 -> 160;
                    case 130 -> 254;
                    case 131 -> 118;
                    case 132 -> 131;
                    case 133 -> 47;
                    case 134 -> 15;
                    case 135 -> 28;
                    case 136 -> 4;
                    case 137 -> 189;
                    case 138 -> 162;
                    case 139 -> 53;
                    case 140 -> 120;
                    case 141 -> 224;
                    case 142 -> 137;
                    case 143 -> 30;
                    case 144 -> 211;
                    case 145 -> 204;
                    case 146 -> 138;
                    case 147 -> 194;
                    case 148 -> 78;
                    case 149 -> 26;
                    case 150 -> 155;
                    case 151 -> 158;
                    case 152 -> 50;
                    case 153 -> 154;
                    case 154 -> 205;
                    case 155 -> 201;
                    case 156 -> 245;
                    case 157 -> 103;
                    case 158 -> 237;
                    case 159 -> 208;
                    case 160 -> 38;
                    case 161 -> 54;
                    case 162 -> 178;
                    case 163 -> 139;
                    case 164 -> 61;
                    case 165 -> 197;
                    case 166 -> 46;
                    case 167 -> 49;
                    case 168 -> 16;
                    case 169 -> 202;
                    case 170 -> 44;
                    case 171 -> 39;
                    case 172 -> 185;
                    case 173 -> 104;
                    case 174 -> 77;
                    case 175 -> 149;
                    case 176 -> 169;
                    case 177 -> 136;
                    case 178 -> 29;
                    case 179 -> 221;
                    case 180 -> 117;
                    case 181 -> 45;
                    case 182 -> 141;
                    case 183 -> 101;
                    case 184 -> 140;
                    case 185 -> 188;
                    case 186 -> 147;
                    case 187 -> 225;
                    case 188 -> 145;
                    case 189 -> 174;
                    case 190 -> 79;
                    case 191 -> 20;
                    case 192 -> 56;
                    case 193 -> 135;
                    case 194 -> 97;
                    case 195 -> 8;
                    case 196 -> 66;
                    case 197 -> 206;
                    case 198 -> 6;
                    case 199 -> 150;
                    case 200 -> 213;
                    case 201 -> 133;
                    case 202 -> 130;
                    case 203 -> 244;
                    case 204 -> 95;
                    case 205 -> 236;
                    case 206 -> 129;
                    case 207 -> 195;
                    case 208 -> 153;
                    case 209 -> 89;
                    case 210 -> 32;
                    case 211 -> 216;
                    case 212 -> 22;
                    case 213 -> 203;
                    case 214 -> 33;
                    case 215 -> 187;
                    case 216 -> 105;
                    case 217 -> 180;
                    case 218 -> 128;
                    case 219 -> 116;
                    case 220 -> 253;
                    case 221 -> 88;
                    case 222 -> 58;
                    case 223 -> 179;
                    case 224 -> 226;
                    case 225 -> 96;
                    case 226 -> 41;
                    case 227 -> 215;
                    case 228 -> 2;
                    case 229 -> 157;
                    case 230 -> 52;
                    case 231 -> 69;
                    case 232 -> 255;
                    case 233 -> 18;
                    case 234 -> 122;
                    case 235 -> 186;
                    case 236 -> 171;
                    case 237 -> 170;
                    case 238 -> 13;
                    case 239 -> 240;
                    case 240 -> 98;
                    case 241 -> 59;
                    case 242 -> 65;
                    case 243 -> 82;
                    case 244 -> 108;
                    case 245 -> 124;
                    case 246 -> 247;
                    case 247 -> 42;
                    case 248 -> 191;
                    case 249 -> 111;
                    case 250 -> 92;
                    case 251 -> 249;
                    case 252 -> 223;
                    case 253 -> 200;
                    case 254 -> 193;
                    default -> 73;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

