/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShelvedChangeList
implements ExternalizableScheme {
    private static final Logger LOG = Logger.getInstance(ShelvedChangeList.class);
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ATTRIBUTE_RECYCLED_CHANGELIST = "recycled";
    @NonNls
    private static final String ATTRIBUTE_TOBE_DELETED_CHANGELIST = "toDelete";
    @NonNls
    private static final String ATTRIBUTE_DELETED_CHANGELIST = "deleted";
    @NonNls
    private static final String ELEMENT_BINARY = "binary";
    @NonNls
    private static final String PATH_FIELD_NAME = "PATH";
    @NonNls
    private static final String DESCRIPTION_FIELD_NAME = "DESCRIPTION";
    private Path myPath;
    @NotNull
    private String mySchemeName;
    @ApiStatus.Internal
    @NlsSafe
    public String DESCRIPTION;
    private Date myDate;
    private boolean myRecycled;
    private boolean myToDelete;
    private boolean myIsDeleted;
    private final List<ShelvedBinaryFile> myBinaryFiles;
    private volatile List<ShelvedChange> myChanges;
    @Nls
    private volatile String myChangesLoadingError;

    /*
     * WARNING - void declaration
     */
    ShelvedChangeList(@Nullable Path path, @NotNull String name, @NlsSafe String description, long time, boolean isRecycled, boolean isToDelete, boolean isDeleted, @NotNull List<ShelvedBinaryFile> list) {
        void binaryFiles;
        if (name == null) {
            ShelvedChangeList.$$$reportNull$$$0(0);
        }
        if (list == null) {
            ShelvedChangeList.$$$reportNull$$$0(1);
        }
        this.myChangesLoadingError = null;
        this.myPath = path;
        this.mySchemeName = name;
        this.DESCRIPTION = description;
        this.myDate = new Date(time);
        this.myRecycled = isRecycled;
        this.myToDelete = isToDelete;
        this.myIsDeleted = isDeleted;
        this.myBinaryFiles = binaryFiles;
    }

    public ShelvedChangeList(@NotNull Path path, @NlsSafe String description, List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> shelvedChanges) {
        if (path == null) {
            ShelvedChangeList.$$$reportNull$$$0(2);
        }
        if (shelvedChanges == null) {
            ShelvedChangeList.$$$reportNull$$$0(3);
        }
        this(path, description, binaryFiles, shelvedChanges, System.currentTimeMillis());
    }

    ShelvedChangeList(@NotNull Path path, @NlsSafe String description, List<ShelvedBinaryFile> binaryFiles, @NotNull List<ShelvedChange> shelvedChanges, long time) {
        if (path == null) {
            ShelvedChangeList.$$$reportNull$$$0(4);
        }
        if (shelvedChanges == null) {
            ShelvedChangeList.$$$reportNull$$$0(5);
        }
        this(path, description, description, time, false, false, false, binaryFiles);
        this.myChanges = shelvedChanges;
    }

    public boolean isRecycled() {
        return this.myRecycled;
    }

    public void setRecycled(boolean recycled) {
        this.myRecycled = recycled;
    }

    @Nls
    public String toString() {
        return this.DESCRIPTION;
    }

    public void loadChangesIfNeeded(@NotNull Project project) {
        if (project == null) {
            ShelvedChangeList.$$$reportNull$$$0(6);
        }
        if (this.myChanges != null) {
            return;
        }
        try {
            this.myChangesLoadingError = null;
            List<? extends FilePatch> list = ShelveChangesManager.loadPatchesWithoutContent(project, this.myPath, null);
            ArrayList<ShelvedChange> changes = new ArrayList<ShelvedChange>();
            for (FilePatch filePatch : list) {
                ShelvedChange change = ShelvedChangeList.createShelvedChange(project, this.myPath, filePatch);
                if (change != null) {
                    changes.add(change);
                    continue;
                }
                if (this.myChangesLoadingError != null) continue;
                String patchName = (String)ObjectUtils.coalesce((Object)filePatch.getBeforeName(), (Object)filePatch.getAfterName(), (Object)this.myPath.toString());
                this.myChangesLoadingError = VcsBundle.message((String)"shelve.loading.patch.error", (Object[])new Object[]{patchName});
            }
            this.myChanges = changes;
        }
        catch (Throwable e) {
            LOG.warn("Failed to parse the file patch: [" + String.valueOf(this.myPath) + "]", e);
            this.myChanges = Collections.emptyList();
            this.myChangesLoadingError = VcsBundle.message((String)"shelve.loading.patch.error", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Nullable
    public List<ShelvedChange> getChanges() {
        return this.myChanges;
    }

    @Deprecated(forRemoval=true)
    public List<ShelvedChange> getChanges(Project project) {
        this.loadChangesIfNeeded(project);
        return this.getChanges();
    }

    @Nullable
    @Nls
    public String getChangesLoadingError() {
        return this.myChangesLoadingError;
    }

    void setChanges(List<ShelvedChange> shelvedChanges) {
        this.myChanges = shelvedChanges;
    }

    @NotNull
    static List<ShelvedChange> createShelvedChangesFromFilePatches(@NotNull Project project, @NotNull Path patchPath, @NotNull Collection<? extends FilePatch> filePatches) {
        if (project == null) {
            ShelvedChangeList.$$$reportNull$$$0(7);
        }
        if (patchPath == null) {
            ShelvedChangeList.$$$reportNull$$$0(8);
        }
        if (filePatches == null) {
            ShelvedChangeList.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.mapNotNull(filePatches, patch -> ShelvedChangeList.createShelvedChange(project, patchPath, patch));
        if (list == null) {
            ShelvedChangeList.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    static ShelvedChange createShelvedChange(@NotNull Project project, @NotNull Path patchPath, @NotNull FilePatch patch) {
        if (project == null) {
            ShelvedChangeList.$$$reportNull$$$0(11);
        }
        if (patchPath == null) {
            ShelvedChangeList.$$$reportNull$$$0(12);
        }
        if (patch == null) {
            ShelvedChangeList.$$$reportNull$$$0(13);
        }
        String beforeName = patch.getBeforeName();
        String afterName = patch.getAfterName();
        if (beforeName == null || afterName == null) {
            LOG.warn("Failed to parse the file patch: [" + String.valueOf(patchPath) + "]:" + String.valueOf(patch));
            return null;
        }
        FileStatus status = patch.isNewFile() ? FileStatus.ADDED : (patch.isDeletedFile() ? FileStatus.DELETED : FileStatus.MODIFIED);
        return ShelvedChange.create(project, patchPath, beforeName, afterName, status);
    }

    public List<ShelvedBinaryFile> getBinaryFiles() {
        return this.myBinaryFiles;
    }

    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            ShelvedChangeList.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void setName(@NotNull String newName) {
        if (newName == null) {
            ShelvedChangeList.$$$reportNull$$$0(15);
        }
        this.mySchemeName = newName;
    }

    public boolean isValid() {
        return Files.exists(this.myPath, new LinkOption[0]);
    }

    public void markToDelete(boolean toDeleted) {
        this.myToDelete = toDeleted;
    }

    public boolean isMarkedToDelete() {
        return this.myToDelete;
    }

    public void setDeleted(boolean isDeleted) {
        this.myIsDeleted = isDeleted;
    }

    public boolean isDeleted() {
        return this.myIsDeleted;
    }

    @Nullable
    public Path getPath() {
        return this.myPath;
    }

    @NlsSafe
    @NotNull
    public String getDescription() {
        String string = Objects.requireNonNullElse(this.DESCRIPTION, "");
        if (string == null) {
            ShelvedChangeList.$$$reportNull$$$0(16);
        }
        return string;
    }

    @ApiStatus.Internal
    public void setDescription(@NotNull @NlsSafe String description) {
        if (description == null) {
            ShelvedChangeList.$$$reportNull$$$0(17);
        }
        this.DESCRIPTION = description;
    }

    @NotNull
    public Date getDate() {
        Date date = Objects.requireNonNullElseGet(this.myDate, () -> new Date(System.currentTimeMillis()));
        if (date == null) {
            ShelvedChangeList.$$$reportNull$$$0(18);
        }
        return date;
    }

    public void setDate(@NotNull Date date) {
        if (date == null) {
            ShelvedChangeList.$$$reportNull$$$0(19);
        }
        this.myDate = date;
    }

    public void updateDate() {
        this.myDate = new Date(System.currentTimeMillis());
    }

    @NotNull
    public static ShelvedChangeList readExternal(@NotNull Element element, @NotNull PathMacroSubstitutor pathMacroSubstitutor) throws InvalidDataException {
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(20);
        }
        if (pathMacroSubstitutor == null) {
            ShelvedChangeList.$$$reportNull$$$0(21);
        }
        Path path = null;
        String description = null;
        for (Map.Entry<String, String> field : ShelvedChangeList.readFields(element).entrySet()) {
            if (PATH_FIELD_NAME.equals(field.getKey())) {
                String value = pathMacroSubstitutor.expandPath(field.getValue());
                if (value.isEmpty()) continue;
                path = Paths.get(value, new String[0]);
                continue;
            }
            if (!DESCRIPTION_FIELD_NAME.equals(field.getKey())) continue;
            description = field.getValue();
        }
        String name = element.getAttributeValue(NAME_ATTRIBUTE, "");
        long time = Long.parseLong(element.getAttributeValue(ATTRIBUTE_DATE));
        boolean isRecycled = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_RECYCLED_CHANGELIST));
        boolean isToDelete = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_TOBE_DELETED_CHANGELIST));
        boolean isDeleted = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_DELETED_CHANGELIST));
        List children = element.getChildren(ELEMENT_BINARY);
        ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>(children.size());
        for (Element child : children) {
            ShelvedBinaryFile binaryFile = ShelvedBinaryFile.readExternal(child, pathMacroSubstitutor);
            binaryFiles.add(binaryFile);
        }
        return new ShelvedChangeList(path, name, description, time, isRecycled, isToDelete, isDeleted, binaryFiles);
    }

    public static void writeExternal(@NotNull ShelvedChangeList shelvedChangeList, @NotNull Element element, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        if (shelvedChangeList == null) {
            ShelvedChangeList.$$$reportNull$$$0(22);
        }
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(23);
        }
        if (shelvedChangeList.myPath != null) {
            String pathString = ShelvedChangeList.collapsePath(shelvedChangeList.myPath.toString().replace(File.separatorChar, '/'), pathMacroSubstitutor);
            ShelvedChangeList.writeField(element, PATH_FIELD_NAME, pathString);
        }
        ShelvedChangeList.writeField(element, DESCRIPTION_FIELD_NAME, shelvedChangeList.DESCRIPTION);
        element.setAttribute(NAME_ATTRIBUTE, shelvedChangeList.getName());
        element.setAttribute(ATTRIBUTE_DATE, Long.toString(shelvedChangeList.myDate.getTime()));
        element.setAttribute(ATTRIBUTE_RECYCLED_CHANGELIST, Boolean.toString(shelvedChangeList.isRecycled()));
        if (shelvedChangeList.isMarkedToDelete()) {
            element.setAttribute(ATTRIBUTE_TOBE_DELETED_CHANGELIST, "true");
        }
        if (shelvedChangeList.isDeleted()) {
            element.setAttribute(ATTRIBUTE_DELETED_CHANGELIST, "true");
        }
        for (ShelvedBinaryFile file : shelvedChangeList.getBinaryFiles()) {
            Element child = new Element(ELEMENT_BINARY);
            file.writeExternal(child, pathMacroSubstitutor);
            element.addContent(child);
        }
    }

    static void writeField(@NotNull Element element, @NotNull String name, @Nullable String value) {
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(24);
        }
        if (name == null) {
            ShelvedChangeList.$$$reportNull$$$0(25);
        }
        if (value == null) {
            return;
        }
        element.addContent(new Element("option").setAttribute(NAME_ATTRIBUTE, name).setAttribute("value", value));
    }

    @Nullable
    static String collapsePath(@Nullable String path, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        if (pathMacroSubstitutor == null || path == null) {
            return path;
        }
        return pathMacroSubstitutor.collapsePath(path);
    }

    @NotNull
    static Map<String, String> readFields(@NotNull Element element) {
        if (element == null) {
            ShelvedChangeList.$$$reportNull$$$0(26);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (Element child : element.getChildren()) {
            if (!child.getName().equals("option")) continue;
            String fieldName = child.getAttributeValue(NAME_ATTRIBUTE);
            String fieldValue = child.getAttributeValue("value");
            if (fieldName == null || fieldValue == null) continue;
            result2.put(fieldName, fieldValue);
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            ShelvedChangeList.$$$reportNull$$$0(27);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 16, 18, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_ATTRIBUTE;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatches";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_DATE;
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMacroSubstitutor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangeList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createShelvedChangesFromFilePatches";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "readFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesIfNeeded";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createShelvedChangesFromFilePatches";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 27: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createShelvedChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setDate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeField";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readFields";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 16, 18, 27 -> new IllegalStateException(string);
        };
    }
}

