/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.old.descriptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.archetype.old.descriptor.TemplateDescriptor;

public class ArchetypeDescriptor {
    private String id;
    private List<String> sources = new ArrayList<String>();
    private List<String> testSources;
    private List<String> resources = new ArrayList<String>();
    private List<String> testResources;
    private List<String> siteResources;
    private Map<String, TemplateDescriptor> sourcesDescriptors;
    private Map<String, TemplateDescriptor> testSourcesDescriptors;
    private Map<String, TemplateDescriptor> resourcesDescriptors;
    private Map<String, TemplateDescriptor> testResourcesDescriptors;
    private Map<String, TemplateDescriptor> siteResourcesDescriptors;
    private boolean allowPartial;

    public ArchetypeDescriptor() {
        this.testSources = new ArrayList<String>();
        this.testResources = new ArrayList<String>();
        this.siteResources = new ArrayList<String>();
        this.sourcesDescriptors = new HashMap<String, TemplateDescriptor>();
        this.testSourcesDescriptors = new HashMap<String, TemplateDescriptor>();
        this.resourcesDescriptors = new HashMap<String, TemplateDescriptor>();
        this.testResourcesDescriptors = new HashMap<String, TemplateDescriptor>();
        this.siteResourcesDescriptors = new HashMap<String, TemplateDescriptor>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addSource(String source) {
        this.sources.add(source);
        this.putSourceDescriptor(source, new TemplateDescriptor());
    }

    public List<String> getSources() {
        return this.sources;
    }

    public void putSourceDescriptor(String source, TemplateDescriptor descriptor) {
        this.sourcesDescriptors.put(source, descriptor);
    }

    public TemplateDescriptor getSourceDescriptor(String source) {
        return this.sourcesDescriptors.get(source);
    }

    public Map<String, TemplateDescriptor> getSourcesDescriptors() {
        return this.sourcesDescriptors;
    }

    public void addTestSource(String testSource) {
        this.testSources.add(testSource);
        this.putTestSourceDescriptor(testSource, new TemplateDescriptor());
    }

    public List<String> getTestSources() {
        return this.testSources;
    }

    public void putTestSourceDescriptor(String testSource, TemplateDescriptor descriptor) {
        this.testSourcesDescriptors.put(testSource, descriptor);
    }

    public TemplateDescriptor getTestSourceDescriptor(String testSource) {
        return this.testSourcesDescriptors.get(testSource);
    }

    public Map<String, TemplateDescriptor> getTestSourcesDescriptors() {
        return this.testSourcesDescriptors;
    }

    public void addResource(String resource) {
        this.resources.add(resource);
        this.putResourceDescriptor(resource, new TemplateDescriptor());
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void putResourceDescriptor(String resource, TemplateDescriptor descriptor) {
        this.resourcesDescriptors.put(resource, descriptor);
    }

    public TemplateDescriptor getResourceDescriptor(String resource) {
        return this.resourcesDescriptors.get(resource);
    }

    public Map<String, TemplateDescriptor> getReourcesDescriptors() {
        return this.resourcesDescriptors;
    }

    public void addTestResource(String testResource) {
        this.testResources.add(testResource);
        this.putTestResourceDescriptor(testResource, new TemplateDescriptor());
    }

    public List<String> getTestResources() {
        return this.testResources;
    }

    public void putTestResourceDescriptor(String testResource, TemplateDescriptor descriptor) {
        this.testResourcesDescriptors.put(testResource, descriptor);
    }

    public TemplateDescriptor getTestResourceDescriptor(String testResource) {
        return this.testResourcesDescriptors.get(testResource);
    }

    public Map<String, TemplateDescriptor> getTestReourcesDescriptors() {
        return this.testResourcesDescriptors;
    }

    public void addSiteResource(String siteResource) {
        this.siteResources.add(siteResource);
        this.putSiteResourceDescriptor(siteResource, new TemplateDescriptor());
    }

    public List<String> getSiteResources() {
        return this.siteResources;
    }

    public void putSiteResourceDescriptor(String siteResource, TemplateDescriptor descriptor) {
        this.siteResourcesDescriptors.put(siteResource, descriptor);
    }

    public TemplateDescriptor getSiteResourceDescriptor(String siteResource) {
        return this.siteResourcesDescriptors.get(siteResource);
    }

    public Map<String, TemplateDescriptor> getSiteReourcesDescriptors() {
        return this.siteResourcesDescriptors;
    }

    public boolean isAllowPartial() {
        return this.allowPartial;
    }

    public void setAllowPartial(boolean allowPartial) {
        this.allowPartial = allowPartial;
    }
}

