/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.lower.PolymorphicSignatureLowering;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhaseDescription(name="VarargLowering", prerequisite={PolymorphicSignatureLowering.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\n*\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0014H\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/VarargLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "addVararg", "Lorg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilder;", "createBuilder", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "startOffset", "", "endOffset", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nVarargLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/VarargLowering\n+ 2 IrArrayBuilder.kt\norg/jetbrains/kotlin/backend/jvm/ir/IrArrayBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n20#2:117\n1#3:118\n*S KotlinDebug\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/VarargLowering\n*L\n69#1:117\n69#1:118\n*E\n"})
public final class VarargLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public VarargLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid((IrElement)irFile);
    }

    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
        if (IrUtilsKt.isAnnotationClass((IrClass)AdditionalIrUtilsKt.getConstructedClass((IrConstructor)constructor))) {
            return (IrExpression)expression2;
        }
        return super.visitConstructorCall(expression2);
    }

    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.transformChildrenVoid((IrElement)expression2);
        IrFunctionSymbol function2 = (IrFunctionSymbol)expression2.getSymbol();
        IrFunction irFunction = function2.getOwner();
        for (Pair pair : CollectionsKt.zip((Iterable)irFunction.getParameters(), (Iterable)((Iterable)expression2.getArguments()))) {
            IrValueParameter parameter = (IrValueParameter)pair.component1();
            IrExpression argument = (IrExpression)pair.component2();
            if (argument != null || parameter.getVarargElementType() == null || IrUtilsKt.hasDefaultValue((IrValueParameter)parameter)) continue;
            IrType arrayType = IrTypesKt.makeNotNull((IrType)IrTypeUtilsKt.substitute((IrType)parameter.getType(), (Map)IrUtilsKt.getTypeSubstitutionMap((IrFunctionAccessExpression)expression2)));
            expression2.getArguments().set(parameter.getIndexInParameters(), (Object)IrArrayBuilderKt.irArrayOf$default(VarargLowering.createBuilder$default(this, 0, 0, 3, null), arrayType, null, 2, null));
        }
        return (IrExpression)expression2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        void $this$irArray$iv;
        IrArrayBuilder irArrayBuilder;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JvmIrBuilder jvmIrBuilder = this.createBuilder(expression2.getStartOffset(), expression2.getEndOffset());
        IrType arrayType$iv = expression2.getType();
        boolean $i$f$irArray = false;
        IrArrayBuilder $this$irArray_u24lambda_u240$iv = irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
        boolean bl = false;
        IrArrayBuilder $this$visitVararg_u24lambda_u240 = $this$irArray_u24lambda_u240$iv;
        boolean bl2 = false;
        this.addVararg($this$visitVararg_u24lambda_u240, expression2);
        return irArrayBuilder.build();
    }

    private final void addVararg(IrArrayBuilder $this$addVararg, IrVararg expression2) {
        for (IrVarargElement element : expression2.getElements()) {
            boolean bl;
            IrVarargElement irVarargElement = element;
            if (irVarargElement instanceof IrExpression) {
                bl = $this$addVararg.unaryPlus(((IrExpression)element).transform((IrTransformer)this, null));
                continue;
            }
            if (irVarargElement instanceof IrSpreadElement) {
                IrExpression spread = ((IrSpreadElement)element).getExpression();
                if (spread instanceof IrFunctionAccessExpression && VarargLoweringKt.isArrayOf(((IrFunctionSymbol)((IrFunctionAccessExpression)spread).getSymbol()).getOwner())) {
                    IrExpression argument;
                    if ((IrExpression)((IrFunctionAccessExpression)spread).getArguments().get(0) == null) continue;
                    if (argument instanceof IrVararg) {
                        this.addVararg($this$addVararg, (IrVararg)argument);
                        continue;
                    }
                }
                bl = $this$addVararg.addSpread(spread.transform((IrTransformer)this, null));
                continue;
            }
            throw new IllegalStateException(("Unexpected IrVarargElement subclass: " + element).toString());
        }
    }

    private final JvmIrBuilder createBuilder(int startOffset, int endOffset) {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull((Object)scopeWithIr);
        return JvmIrBuilderKt.createJvmIrBuilder(this.context, scopeWithIr, startOffset, endOffset);
    }

    static /* synthetic */ JvmIrBuilder createBuilder$default(VarargLowering varargLowering, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = -1;
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return varargLowering.createBuilder(n, n2);
    }
}

