/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.profiler.ui.timeline.TimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ui.timeline.TimelinePanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0010\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000eH\u0016J7\u0010\u0011\u001a\u00020\u00122\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J7\u0010\u0019\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/ui/timeline/DefaultTimelineCellRenderer;", "T", "F", "Lcom/intellij/profiler/ui/timeline/TimelineCellRenderer;", "Lcom/intellij/ui/SimpleColoredComponent;", "<init>", "()V", "paint", "", "panel", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "g", "Ljava/awt/Graphics2D;", "node", "Lcom/intellij/profiler/ui/timeline/TimelineModel$TimelineInterval;", "getBackground", "Lcom/intellij/ui/JBColor;", "getNodeRendererComponent", "Ljava/awt/Component;", "Lcom/intellij/profiler/ui/timeline/TimelinePanel;", "value", "isSelected", "", "hasFocus", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Ljava/lang/Object;ZZ)Ljava/awt/Component;", "customizeCellRenderer", "(Lcom/intellij/profiler/ui/timeline/TimelinePanel;Ljava/lang/Object;ZZ)V", "intellij.profiler.common"})
public class DefaultTimelineCellRenderer<T, F>
extends SimpleColoredComponent
implements TimelineCellRenderer<T, F> {
    @Override
    public void paint(@NotNull TimelineComponent<?, F> panel2, @NotNull Graphics2D g, @NotNull TimelineModel.TimelineInterval<F> node) {
        Intrinsics.checkNotNullParameter(panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        JBColor color = this.getBackground(panel2, node);
        double aQuarter = (double)panel2.getRowHeight() / 8.0;
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds.width <= 1) {
            g.setColor((Color)color);
            Line2D.Double line = new Line2D.Double(clipBounds.x, aQuarter + 0.5, clipBounds.x, (double)panel2.getRowHeight() - aQuarter - 0.5);
            g.draw(line);
        } else {
            Rectangle $this$paint_u24lambda_u240 = clipBounds;
            boolean bl = false;
            int adjustedX = $this$paint_u24lambda_u240.x;
            int adjustedWidth = $this$paint_u24lambda_u240.width;
            Rectangle2D.Double outerRect = new Rectangle2D.Double(adjustedX, aQuarter, adjustedWidth, (double)panel2.getRowHeight() - 2.0 * aQuarter);
            g.setColor((Color)color);
            g.fill(outerRect);
        }
    }

    @NotNull
    public JBColor getBackground(@NotNull TimelineComponent<?, F> panel2, @NotNull TimelineModel.TimelineInterval<F> node) {
        Intrinsics.checkNotNullParameter(panel2, (String)"panel");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return new JBColor(0xDBDBDB, 0xA3A3A3);
    }

    @Override
    @NotNull
    public Component getNodeRendererComponent(@NotNull TimelinePanel<T, ?> panel2, T value, boolean isSelected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(panel2, (String)"panel");
        this.clear();
        this.customizeCellRenderer(panel2, value, isSelected, hasFocus);
        return (Component)((Object)this);
    }

    public void customizeCellRenderer(@NotNull TimelinePanel<T, ?> panel2, T value, boolean isSelected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(panel2, (String)"panel");
        this.append((String)panel2.getStringConverter().invoke(value));
    }
}

