/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvm.shared.scratch.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchEditorLinesTranslator;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchEditorSyncHighlighter;
import org.jetbrains.kotlin.idea.jvm.shared.scratch.ui.ScratchEditorSyncHighlighterKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"configureSyncHighlighting", "", "sourceEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "previewEditor", "translator", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorLinesTranslator;", "configureSourceAndPreviewHighlighting", "configureExclusiveCaretRowHighlighting", "configureHighlightUpdateOnDocumentChange", "highlighter", "Lorg/jetbrains/kotlin/idea/jvm/shared/scratch/ui/ScratchEditorSyncHighlighter;", "configureSourceToPreviewHighlighting", "configurePreviewToSourceHighlighting", "kotlin.jvm.shared"})
public final class ScratchEditorSyncHighlighterKt {
    public static final void configureSyncHighlighting(@NotNull EditorEx sourceEditor, @NotNull EditorEx previewEditor, @NotNull ScratchEditorLinesTranslator translator) {
        Intrinsics.checkNotNullParameter((Object)sourceEditor, (String)"sourceEditor");
        Intrinsics.checkNotNullParameter((Object)previewEditor, (String)"previewEditor");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        ScratchEditorSyncHighlighterKt.configureExclusiveCaretRowHighlighting(sourceEditor, previewEditor);
        ScratchEditorSyncHighlighterKt.configureSourceAndPreviewHighlighting(sourceEditor, previewEditor, translator);
    }

    private static final void configureSourceAndPreviewHighlighting(EditorEx sourceEditor, EditorEx previewEditor, ScratchEditorLinesTranslator translator) {
        ScratchEditorSyncHighlighter syncHighlighter = ScratchEditorSyncHighlighter.Companion.create(sourceEditor, previewEditor, translator);
        ScratchEditorSyncHighlighterKt.configureHighlightUpdateOnDocumentChange(sourceEditor, previewEditor, syncHighlighter);
        ScratchEditorSyncHighlighterKt.configureSourceToPreviewHighlighting(sourceEditor, syncHighlighter);
        ScratchEditorSyncHighlighterKt.configurePreviewToSourceHighlighting(previewEditor, syncHighlighter);
    }

    private static final void configureExclusiveCaretRowHighlighting(EditorEx sourceEditor, EditorEx previewEditor) {
        FocusChangeListener exclusiveCaretHighlightingListener2 = new FocusChangeListener(sourceEditor, previewEditor){
            final /* synthetic */ EditorEx $sourceEditor;
            final /* synthetic */ EditorEx $previewEditor;
            {
                this.$sourceEditor = $sourceEditor;
                this.$previewEditor = $previewEditor;
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            }

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.$sourceEditor.getSettings().setCaretRowShown(false);
                this.$previewEditor.getSettings().setCaretRowShown(false);
                editor.getSettings().setCaretRowShown(true);
            }
        };
        sourceEditor.addFocusListener(exclusiveCaretHighlightingListener2);
        previewEditor.addFocusListener(exclusiveCaretHighlightingListener2);
    }

    private static final void configureHighlightUpdateOnDocumentChange(EditorEx sourceEditor, EditorEx previewEditor, ScratchEditorSyncHighlighter highlighter) {
        Project project = sourceEditor.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        DocumentListener updateHighlightOnDocumentChangeListener2 = new DocumentListener(project2, highlighter){
            final /* synthetic */ Project $project;
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;
            {
                this.$project = $project;
                this.$highlighter = $highlighter;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                PsiDocumentManager.getInstance((Project)this.$project).performWhenAllCommitted(() -> configureHighlightUpdateOnDocumentChange.updateHighlightOnDocumentChangeListener.1.documentChanged$lambda$0(this.$highlighter));
            }

            private static final void documentChanged$lambda$0(ScratchEditorSyncHighlighter $highlighter) {
                $highlighter.highlightByCurrentlyFocusedEditor();
            }
        };
        KotlinPluginDisposable disposable = KotlinPluginDisposable.Companion.getInstance(project2);
        previewEditor.getDocument().addDocumentListener(updateHighlightOnDocumentChangeListener2, (Disposable)disposable);
        sourceEditor.getDocument().addDocumentListener(updateHighlightOnDocumentChangeListener2, (Disposable)disposable);
    }

    private static final void configureSourceToPreviewHighlighting(EditorEx sourceEditor, ScratchEditorSyncHighlighter highlighter) {
        sourceEditor.getCaretModel().addCaretListener(new CaretListener(highlighter){
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;
            {
                this.$highlighter = $highlighter;
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$highlighter.highlightPreviewBySource();
            }
        });
        sourceEditor.addFocusListener(new FocusChangeListener(highlighter){
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;
            {
                this.$highlighter = $highlighter;
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            }

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.$highlighter.highlightPreviewBySource();
            }
        });
    }

    private static final void configurePreviewToSourceHighlighting(EditorEx previewEditor, ScratchEditorSyncHighlighter highlighter) {
        previewEditor.getCaretModel().addCaretListener(new CaretListener(highlighter){
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;
            {
                this.$highlighter = $highlighter;
            }

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$highlighter.highlightSourceByPreview();
            }
        });
        previewEditor.addFocusListener(new FocusChangeListener(highlighter){
            final /* synthetic */ ScratchEditorSyncHighlighter $highlighter;
            {
                this.$highlighter = $highlighter;
            }

            public void focusLost(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            }

            public void focusGained(Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.$highlighter.highlightSourceByPreview();
            }
        });
    }
}

