/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointType;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpointType;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointChecker;", "", "<init>", "()V", "breakpointTypes", "", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "check", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointChecker$BreakpointType;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "", "Companion", "BreakpointType", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nBreakpointChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakpointChecker.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointChecker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n4135#2,11:70\n774#3:81\n865#3,2:82\n1617#3,9:84\n1869#3:93\n1870#3:95\n1626#3:96\n1#4:94\n*S KotlinDebug\n*F\n+ 1 BreakpointChecker.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointChecker\n*L\n42#1:70,11\n43#1:81\n43#1:82,2\n57#1:84,9\n57#1:93\n57#1:95\n57#1:96\n57#1:94\n*E\n"})
public final class BreakpointChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<XLineBreakpointType<?>> breakpointTypes;
    @NotNull
    private static final Map<Class<? extends Object>, BreakpointType> BREAKPOINT_TYPES;

    /*
     * WARNING - void declaration
     */
    public BreakpointChecker() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        BreakpointChecker breakpointChecker = this;
        BreakpointChecker breakpointChecker2 = this;
        boolean bl = false;
        ExtensionPoint extensionPoint = ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(XBreakpointType.EXTENSION_POINT_NAME.getName());
        Object[] objectArray = extensionPoint.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
        Object[] objectArray2 = objectArray;
        boolean $i$f$filterIsInstance = false;
        void var6_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof XLineBreakpointType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XLineBreakpointType it = (XLineBreakpointType)element$iv$iv;
            boolean bl2 = false;
            if (!(it instanceof KotlinBreakpointType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        breakpointChecker2.breakpointTypes = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BreakpointType> check(@NotNull KtFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List actualBreakpointTypes = new ArrayList();
        for (XLineBreakpointType<?> breakpointType : this.breakpointTypes) {
            BreakpointType sign;
            if (BREAKPOINT_TYPES.get(breakpointType.getClass()) == null) continue;
            boolean isApplicable2 = breakpointType.canPutAt(file.getVirtualFile(), line, file.getProject());
            if (breakpointType instanceof KotlinLineBreakpointType) {
                if (!isApplicable2) continue;
                KotlinLineBreakpointType kotlinLineBreakpointType = (KotlinLineBreakpointType)breakpointType;
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                VirtualFile virtualFile = file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                List<JavaLineBreakpointType.JavaBreakpointVariant> variants = kotlinLineBreakpointType.computeVariants(project, (XSourcePosition)new SourceInfo(virtualFile, line, 0, 0, null, null, 60, null));
                if (!((Collection)variants).isEmpty()) {
                    void $this$mapNotNullTo$iv$iv;
                    Collection collection = actualBreakpointTypes;
                    Iterable $this$mapNotNull$iv = variants;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        BreakpointType it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        JavaLineBreakpointType.JavaBreakpointVariant it = (JavaLineBreakpointType.JavaBreakpointVariant)element$iv$iv;
                        boolean bl2 = false;
                        if (BREAKPOINT_TYPES.get(it.getClass()) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                    continue;
                }
                ((Collection)actualBreakpointTypes).add(sign);
                continue;
            }
            if (!isApplicable2) continue;
            ((Collection)actualBreakpointTypes).add(sign);
        }
        return actualBreakpointTypes;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(KotlinLineBreakpointType.class, (Object)((Object)BreakpointType.Line)), TuplesKt.to(KotlinFieldBreakpointType.class, (Object)((Object)BreakpointType.Field)), TuplesKt.to(KotlinFunctionBreakpointType.class, (Object)((Object)BreakpointType.Function)), TuplesKt.to(JavaLineBreakpointType.LambdaJavaBreakpointVariant.class, (Object)((Object)BreakpointType.Lambda)), TuplesKt.to(KotlinLineBreakpointType.LineKotlinBreakpointVariant.class, (Object)((Object)BreakpointType.Line)), TuplesKt.to(KotlinLineBreakpointType.KotlinBreakpointVariant.class, (Object)((Object)BreakpointType.All)), TuplesKt.to(JavaLineBreakpointType.ConditionalReturnJavaBreakpointVariant.class, (Object)((Object)BreakpointType.Return))};
        BREAKPOINT_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointChecker$BreakpointType;", "", "prefix", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "Line", "Field", "Function", "Lambda", "Return", "All", "kotlin.jvm-debugger.core"})
    public static final class BreakpointType
    extends Enum<BreakpointType> {
        @NotNull
        private final String prefix;
        public static final /* enum */ BreakpointType Line = new BreakpointType("L");
        public static final /* enum */ BreakpointType Field = new BreakpointType("F");
        public static final /* enum */ BreakpointType Function = new BreakpointType("M");
        public static final /* enum */ BreakpointType Lambda = new BreakpointType("\u03bb");
        public static final /* enum */ BreakpointType Return = new BreakpointType("R");
        public static final /* enum */ BreakpointType All = new BreakpointType("*");
        private static final /* synthetic */ BreakpointType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BreakpointType(String prefix2) {
            this.prefix = prefix2;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        public static BreakpointType[] values() {
            return (BreakpointType[])$VALUES.clone();
        }

        public static BreakpointType valueOf(String value) {
            return Enum.valueOf(BreakpointType.class, value);
        }

        @NotNull
        public static EnumEntries<BreakpointType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = breakpointTypeArray = new BreakpointType[]{BreakpointType.Line, BreakpointType.Field, BreakpointType.Function, BreakpointType.Lambda, BreakpointType.Return, BreakpointType.All};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R%\u0010\u0004\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointChecker$Companion;", "", "<init>", "()V", "BREAKPOINT_TYPES", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointChecker$BreakpointType;", "getBREAKPOINT_TYPES", "()Ljava/util/Map;", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Class<? extends Object>, BreakpointType> getBREAKPOINT_TYPES() {
            return BREAKPOINT_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

