/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

public class KotlinStringTemplateSurrounder
extends KotlinExpressionSurrounder {
    @NlsSafe
    public String getTemplateDescription() {
        return "\"${expr}\"";
    }

    @Override
    public boolean isApplicable(@NotNull KtExpression expression) {
        if (expression == null) {
            KotlinStringTemplateSurrounder.$$$reportNull$$$0(0);
        }
        return !(expression instanceof KtStringTemplateExpression) && super.isApplicable(expression);
    }

    @Override
    protected void surroundExpression(@NotNull ActionContext context, @NotNull KtExpression expression, @NotNull ModPsiUpdater updater2) {
        if (context == null) {
            KotlinStringTemplateSurrounder.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            KotlinStringTemplateSurrounder.$$$reportNull$$$0(2);
        }
        if (updater2 == null) {
            KotlinStringTemplateSurrounder.$$$reportNull$$$0(3);
        }
        KtPsiFactory factory2 = new KtPsiFactory(context.project());
        KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)factory2.createExpression(KotlinStringTemplateSurrounder.getCodeTemplate(expression));
        KtStringTemplateEntry templateEntry = stringTemplateExpression.getEntries()[0];
        KtExpression innerExpression = templateEntry.getExpression();
        assert (innerExpression != null) : "KtExpression should exists for " + String.valueOf(stringTemplateExpression);
        innerExpression.replace((PsiElement)expression);
        expression = (KtExpression)expression.replace((PsiElement)stringTemplateExpression);
        int offset = expression.getTextRange().getEndOffset();
        updater2.select(TextRange.from((int)offset, (int)0));
    }

    private static String getCodeTemplate(KtExpression expression) {
        if (expression.getChildren().length > 0 || expression instanceof KtConstantExpression) {
            return "\"${a}\"";
        }
        return "\"$a\"";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinStringTemplateSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

