/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.pipeline;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u00020\u00102\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!J\u0014\u0010\"\u001a\u00020\u00102\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0016\u0010%\u001a\u00020\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0016\u0010)\u001a\u00020\u00102\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0'H\u0002J\u0016\u0010,\u001a\u00020\u00102\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0'H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/fir/pipeline/Visitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitorVoid;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "visited", "", "Lorg/jetbrains/kotlin/name/ClassId;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitResolvedNamedReference", "resolvedNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "visitResolvedQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "lookupInType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "lookupEverythingInClass", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "lookupInMember", "memberSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "lookupInTypeParameters", "typeParameterSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "lookupInParameters", "parameterSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "lookupInAnnotations", "annotations", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nCommonDependenciesReferencer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonDependenciesReferencer.kt\norg/jetbrains/kotlin/fir/pipeline/Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 4 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt$forEachType$1\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,154:1\n1#2:155\n71#3,8:156\n79#3,13:165\n94#3:180\n72#4:164\n13472#5,2:178\n*S KotlinDebug\n*F\n+ 1 CommonDependenciesReferencer.kt\norg/jetbrains/kotlin/fir/pipeline/Visitor\n*L\n76#1:156,8\n76#1:165,13\n76#1:180\n76#1:164\n76#1:178,2\n*E\n"})
final class Visitor
extends FirDefaultVisitorVoid {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Set<ClassId> visited;

    public Visitor(@NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session;
        this.scopeSession = scopeSession;
        this.visited = new LinkedHashSet();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof FirExpression) {
            this.lookupInType(FirTypeUtilsKt.getResolvedType((FirExpression)element));
        }
        element.acceptChildren(this);
    }

    @Override
    public void visitResolvedNamedReference(@NotNull FirResolvedNamedReference resolvedNamedReference) {
        CallableId callableId;
        Intrinsics.checkNotNullParameter((Object)resolvedNamedReference, (String)"resolvedNamedReference");
        FirBasedSymbol<?> firBasedSymbol = resolvedNamedReference.getResolvedSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        CallableId it = callableId = symbol.getCallableId();
        boolean bl = false;
        Object object = !(it.isLocal() || it.getClassId() != null) ? callableId : null;
        if (object == null) {
            return;
        }
        CallableId id = object;
        FirSymbolProviderKt.getSymbolProvider(this.session).getTopLevelCallableSymbols(id.getPackageName(), id.getCallableName());
    }

    @Override
    public void visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier) {
        Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
        this.lookupInType(FirTypeUtilsKt.getResolvedType(resolvedQualifier));
        this.visitElement(resolvedQualifier);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef) {
        Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
        this.lookupInType(resolvedTypeRef.getConeType());
    }

    private final void lookupInType(ConeKotlinType type2) {
        ConeKotlinType $this$forEachType_u24default$iv = type2;
        boolean $i$f$forEachType = false;
        Object[] objectArray = new ConeKotlinType[]{$this$forEachType_u24default$iv};
        List stack$iv = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)stack$iv).isEmpty()) {
            ConeClassLikeLookupTag lookupTag;
            ConeKotlinType it;
            ConeKotlinType next$iv;
            Object object = AddToStdlibKt.popLast((List)stack$iv);
            boolean bl = false;
            it = next$iv = (it = (ConeKotlinType)object);
            boolean bl2 = false;
            if (ConeTypeUtilsKt.getClassLikeLookupTagIfAny(it) != null && !(lookupTag instanceof ConeClassLikeLookupTagWithFixedSymbol)) {
                ClassId classId = lookupTag.getClassId();
                if (FirSymbolProviderKt.getSymbolProvider(this.session).getClassLikeSymbolByClassId(classId) != null) {
                    FirClassLikeSymbol<?> symbol;
                    this.lookupEverythingInClass(symbol);
                }
            }
            ConeKotlinType coneKotlinType = next$iv;
            if (coneKotlinType instanceof ConeFlexibleType) {
                stack$iv.add(((ConeFlexibleType)next$iv).getLowerBound());
                if (((ConeFlexibleType)next$iv).isTrivial()) continue;
                stack$iv.add(((ConeFlexibleType)next$iv).getUpperBound());
                continue;
            }
            if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                stack$iv.add(((ConeDefinitelyNotNullType)next$iv).getOriginal());
                continue;
            }
            if (coneKotlinType instanceof ConeIntersectionType) {
                stack$iv.addAll(((ConeIntersectionType)next$iv).getIntersectedTypes());
                continue;
            }
            ConeTypeProjection[] $this$forEach$iv$iv = next$iv.getTypeArguments();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv.length;
            for (int j = 0; j < n; ++j) {
                ConeTypeProjection element$iv$iv;
                ConeTypeProjection it$iv = element$iv$iv = $this$forEach$iv$iv[j];
                boolean bl3 = false;
                if (!(it$iv instanceof ConeKotlinTypeProjection)) continue;
                stack$iv.add(((ConeKotlinTypeProjection)it$iv).getType());
            }
        }
    }

    public final void lookupEverythingInClass(@NotNull FirClassLikeSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        if (!this.visited.add(symbol.getClassId())) {
            return;
        }
        for (ConeClassLikeType supertype : SupertypeUtilsKt.getSuperTypes$default(symbol, this.session, true, false, false, null, 28, null)) {
            this.lookupInType(supertype);
        }
        this.lookupInTypeParameters(symbol.getTypeParameterSymbols());
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)symbol);
        if (firClassLikeSymbol != null) {
            FirClassLikeSymbol<?> it = firClassLikeSymbol;
            boolean bl = false;
            this.lookupEverythingInClass(it);
        }
        this.lookupInAnnotations(symbol.getAnnotations());
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(ScopeUtilsKt.defaultType(symbol), this.session, this.scopeSession, CallableCopyTypeCalculator.CalculateDeferredForceLazyResolution.INSTANCE, FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
        if (firTypeScope == null) {
            return;
        }
        FirTypeScope scope = firTypeScope;
        scope.processDeclaredConstructors((Function1<? super FirConstructorSymbol, Unit>)((Function1)arg_0 -> Visitor.lookupEverythingInClass$lambda$3(this, arg_0)));
        FirContainingNamesAwareScopeKt.processAllCallables(scope, arg_0 -> Visitor.lookupEverythingInClass$lambda$4(this, arg_0));
        if (symbol instanceof FirClassSymbol) {
            FirContainingNamesAwareScope firContainingNamesAwareScope = ImplicitReceiverUtilsKt.staticScope((FirClassSymbol)symbol, this.session, this.scopeSession);
            if (firContainingNamesAwareScope == null) {
                return;
            }
            FirContainingNamesAwareScope staticScope = firContainingNamesAwareScope;
            FirContainingNamesAwareScopeKt.processAllCallables(staticScope, arg_0 -> Visitor.lookupEverythingInClass$lambda$5(this, arg_0));
        }
    }

    private final void lookupInMember(FirCallableSymbol<?> memberSymbol) {
        this.lookupInAnnotations(memberSymbol.getAnnotations());
        this.lookupInTypeParameters(memberSymbol.getTypeParameterSymbols());
        this.lookupInParameters(memberSymbol.getContextParameterSymbols());
        FirReceiverParameterSymbol firReceiverParameterSymbol = memberSymbol.getReceiverParameterSymbol();
        if (firReceiverParameterSymbol != null) {
            FirReceiverParameterSymbol parameterSymbol = firReceiverParameterSymbol;
            boolean bl = false;
            this.lookupInType(parameterSymbol.getResolvedType());
            this.lookupInAnnotations(parameterSymbol.getAnnotations());
        }
        this.lookupInType(memberSymbol.getResolvedReturnType());
        if (memberSymbol instanceof FirFunctionSymbol) {
            this.lookupInParameters(((FirFunctionSymbol)memberSymbol).getValueParameterSymbols());
        }
    }

    private final void lookupInTypeParameters(List<FirTypeParameterSymbol> typeParameterSymbols) {
        for (FirTypeParameterSymbol typeParameterSymbol : typeParameterSymbols) {
            this.lookupInAnnotations(typeParameterSymbol.getAnnotations());
            for (FirResolvedTypeRef typeRef : typeParameterSymbol.getResolvedBounds()) {
                this.lookupInType(typeRef.getConeType());
            }
        }
    }

    private final void lookupInParameters(List<FirValueParameterSymbol> parameterSymbols) {
        for (FirValueParameterSymbol parameterSymbol : parameterSymbols) {
            this.lookupInType(parameterSymbol.getResolvedReturnType());
            this.lookupInAnnotations(parameterSymbol.getAnnotations());
        }
    }

    private final void lookupInAnnotations(List<? extends FirAnnotation> annotations2) {
        for (FirAnnotation firAnnotation : annotations2) {
            FirClassLikeSymbol<?> it;
            if (ToSymbolUtilsKt.toClassLikeSymbol(FirTypeUtilsKt.getResolvedType(firAnnotation), this.session) == null) continue;
            boolean bl = false;
            this.lookupEverythingInClass(it);
        }
    }

    private static final Unit lookupEverythingInClass$lambda$3(Visitor this$0, FirConstructorSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.lookupInMember(it);
        return Unit.INSTANCE;
    }

    private static final Unit lookupEverythingInClass$lambda$4(Visitor this$0, FirCallableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.lookupInMember(it);
        return Unit.INSTANCE;
    }

    private static final Unit lookupEverythingInClass$lambda$5(Visitor this$0, FirCallableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.lookupInMember(it);
        return Unit.INSTANCE;
    }
}

