/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XmlSchemaTagsProcessor;
import com.intellij.xml.util.XmlUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class XsdEnumerationDescriptor<T extends XmlElement>
extends XmlEnumerationDescriptor<T> {
    private boolean myExhaustiveEnum;

    public abstract XmlTag getDeclaration();

    @Override
    public String getDefaultValue() {
        if (this.isFixed()) {
            return this.getDeclaration().getAttributeValue("fixed");
        }
        return this.getDeclaration().getAttributeValue("default");
    }

    @Override
    public boolean isFixed() {
        return this.getDeclaration().getAttributeValue("fixed") != null;
    }

    @Override
    public String[] getEnumeratedValues() {
        return this.getEnumeratedValues(false);
    }

    @Override
    public String[] getValuesForCompletion() {
        return this.getEnumeratedValues(true);
    }

    private String[] getEnumeratedValues(boolean forCompletion) {
        SmartList list = new SmartList();
        this.processEnumeration(null, (PairProcessor<PsiElement, String>)((PairProcessor)(arg_0, arg_1) -> XsdEnumerationDescriptor.lambda$getEnumeratedValues$0((List)list, arg_0, arg_1)), forCompletion);
        String defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            list.add(defaultValue);
        }
        return ArrayUtilRt.toStringArray((Collection)list);
    }

    private boolean processEnumeration(XmlElement context, PairProcessor<? super PsiElement, ? super String> processor, boolean forCompletion) {
        if (this.getDeclaration() == null) {
            return false;
        }
        XmlTag contextTag = context != null ? (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)context, XmlTag.class, (boolean)false) : null;
        XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)XmlUtil.findXmlDescriptorByType(this.getDeclaration(), contextTag);
        if (elementDescriptor != null && elementDescriptor.getType() instanceof ComplexTypeDescriptor) {
            TypeDescriptor type = elementDescriptor.getType();
            return this.processEnumerationImpl(type.getDeclaration(), (ComplexTypeDescriptor)type, processor, forCompletion);
        }
        String namespacePrefix = this.getDeclaration().getNamespacePrefix();
        XmlTag type = this.getDeclaration().findFirstSubTag((String)(!namespacePrefix.isEmpty() ? namespacePrefix + ":" : "") + "simpleType");
        if (type != null) {
            return this.processEnumerationImpl(type, null, processor, forCompletion);
        }
        return false;
    }

    private boolean processEnumerationImpl(XmlTag declaration, @Nullable ComplexTypeDescriptor type, PairProcessor<? super PsiElement, ? super String> pairProcessor, boolean forCompletion) {
        String namespace;
        XmlNSDescriptorImpl nsDescriptor;
        XmlAttribute name = declaration.getAttribute("name");
        if (name != null && "boolean".equals(name.getValue()) && type != null && (nsDescriptor = type.getNsDescriptor()) != null && "http://www.w3.org/2001/XMLSchema".equals(namespace = nsDescriptor.getDefaultNamespace())) {
            XmlAttributeValue valueElement = name.getValueElement();
            pairProcessor.process((Object)valueElement, (Object)"true");
            pairProcessor.process((Object)valueElement, (Object)"false");
            if (!forCompletion) {
                pairProcessor.process((Object)valueElement, (Object)"1");
                pairProcessor.process((Object)valueElement, (Object)"0");
            }
            this.myExhaustiveEnum = true;
            return true;
        }
        Ref found = new Ref((Object)Boolean.FALSE);
        this.myExhaustiveEnum = XmlUtil.processEnumerationValues(declaration, (Processor<? super XmlTag>)((Processor)tag -> {
            found.set((Object)Boolean.TRUE);
            XmlAttribute name1 = tag.getAttribute("value");
            return name1 == null || pairProcessor.process(tag, (Object)name1.getValue());
        }));
        return (Boolean)found.get();
    }

    @Override
    public PsiElement getValueDeclaration(XmlElement attributeValue, String value) {
        PsiElement declaration = super.getValueDeclaration(attributeValue, value);
        if (declaration == null && !this.myExhaustiveEnum) {
            return this.getDeclaration();
        }
        return declaration;
    }

    @Override
    public boolean isEnumerated(@Nullable XmlElement context) {
        return this.processEnumeration(context, (PairProcessor<PsiElement, String>)PairProcessor.alwaysTrue(), false);
    }

    @Override
    public PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        Ref result = new Ref();
        this.processEnumeration((XmlElement)this.getDeclaration(), (PairProcessor<PsiElement, String>)((PairProcessor)(element, s) -> {
            if (value.equals(s)) {
                result.set(element);
                return false;
            }
            return true;
        }), false);
        return (PsiElement)result.get();
    }

    @Override
    protected PsiElement getDefaultValueDeclaration() {
        return this.getDeclaration();
    }

    @Override
    public boolean isList() {
        XmlElementDescriptorImpl elementDescriptor = (XmlElementDescriptorImpl)XmlUtil.findXmlDescriptorByType(this.getDeclaration(), null);
        if (elementDescriptor == null) {
            return false;
        }
        TypeDescriptor type = elementDescriptor.getType(null);
        if (!(type instanceof ComplexTypeDescriptor)) {
            return false;
        }
        final Ref result = new Ref((Object)false);
        new XmlSchemaTagsProcessor(((ComplexTypeDescriptor)type).getNsDescriptor(), new String[0]){

            @Override
            protected void tagStarted(XmlTag tag, String tagName, XmlTag context, @Nullable XmlTag ref) {
                if ("list".equals(tagName) || "union".equals(tagName)) {
                    result.set((Object)true);
                }
            }
        }.startProcessing(type.getDeclaration());
        return (Boolean)result.get();
    }

    private static /* synthetic */ boolean lambda$getEnumeratedValues$0(List list, PsiElement element, String s) {
        list.add(s);
        return true;
    }
}

