/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.Messages;

public class DatabaseImpact {
    public static final int TYPE_IMPACT_NONE = 0;
    public static final int TYPE_IMPACT_READ = 1;
    public static final int TYPE_IMPACT_WRITE = 2;
    public static final int TYPE_IMPACT_READ_WRITE = 3;
    public static final int TYPE_IMPACT_TRUNCATE = 4;
    public static final int TYPE_IMPACT_DELETE = 5;
    public static final int TYPE_IMPACT_UPDATE = 6;
    public static final String[] typeDesc = new String[]{Messages.getString("DatabaseImpact.TypeDesc.Label.None"), Messages.getString("DatabaseImpact.TypeDesc.Label.Read"), Messages.getString("DatabaseImpact.TypeDesc.Label.Write"), Messages.getString("DatabaseImpact.TypeDesc.Label.ReadOrWrite"), Messages.getString("DatabaseImpact.TypeDesc.Label.Truncate"), Messages.getString("DatabaseImpact.TypeDesc.Label.Delete"), Messages.getString("DatabaseImpact.TypeDesc.Label.Update")};
    private String transname;
    private String stepname;
    private String dbname;
    private String table;
    private String field;
    private String valuename;
    private String valueorigin;
    private String sql;
    private String remark;
    private int type;

    public DatabaseImpact(int type, String transname, String stepname, String dbname, String table, String field, String valuename, String valueorigin, String sql, String remark) {
        this.type = type;
        this.transname = transname;
        this.stepname = stepname;
        this.dbname = dbname;
        this.table = table;
        this.field = field;
        this.valuename = valuename;
        this.valueorigin = valueorigin;
        this.sql = sql;
        this.remark = remark;
    }

    public String getTransformationName() {
        return this.transname;
    }

    public String getStepName() {
        return this.stepname;
    }

    public String getValueOrigin() {
        return this.valueorigin;
    }

    public String getDatabaseName() {
        return this.dbname;
    }

    public String getTable() {
        return this.table;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.valuename;
    }

    public String getSQL() {
        return this.sql;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getTypeDesc() {
        return typeDesc[this.type];
    }

    public static final int getTypeDesc(String typedesc) {
        for (int i = 1; i < typeDesc.length; ++i) {
            if (!typeDesc[i].equalsIgnoreCase(typedesc)) continue;
            return i;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public RowMetaAndData getRow() {
        RowMetaAndData r = new RowMetaAndData();
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.Type"), 2), (Object)this.getTypeDesc());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.Transformation"), 2), (Object)this.getTransformationName());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.Step"), 2), (Object)this.getStepName());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.Database"), 2), (Object)this.getDatabaseName());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.Table"), 2), (Object)this.getTable());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.Field"), 2), (Object)this.getField());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.Value"), 2), (Object)this.getValue());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.ValueOrigin"), 2), (Object)this.getValueOrigin());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.SQL"), 2), (Object)this.getSQL());
        r.addValue(new ValueMeta(Messages.getString("DatabaseImpact.RowDesc.Label.Remarks"), 2), (Object)this.getRemark());
        return r;
    }
}

