/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ClientKeyExchangeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpClientKeyExchangeSerializer
extends ClientKeyExchangeSerializer<SrpClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SrpClientKeyExchangeMessage msg;

    public SrpClientKeyExchangeSerializer(SrpClientKeyExchangeMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing SRPClientKeyExchangeMessage");
        this.writeSerializedPublicKeyLength(this.msg);
        this.writeSerializedPublicKey(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeSerializedPublicKeyLength(SrpClientKeyExchangeMessage msg) {
        this.appendInt((Integer)msg.getPublicKeyLength().getValue(), 2);
        LOGGER.debug("SerializedPublicKexLength: " + msg.getPublicKeyLength().getValue());
    }

    private void writeSerializedPublicKey(SrpClientKeyExchangeMessage msg) {
        this.appendBytes((byte[])msg.getPublicKey().getValue());
        LOGGER.debug("SerializedPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }
}

