/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.VersionedBytesStore;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;

public abstract class WrappedStateStore<S extends StateStore, K, V>
implements StateStore,
CachedStateStore<K, V> {
    private final S wrapped;

    public static boolean isTimestamped(StateStore stateStore) {
        if (stateStore instanceof TimestampedBytesStore) {
            return true;
        }
        if (stateStore instanceof WrappedStateStore) {
            return WrappedStateStore.isTimestamped(((WrappedStateStore)stateStore).wrapped());
        }
        return false;
    }

    public static boolean isVersioned(StateStore stateStore) {
        if (stateStore instanceof VersionedBytesStore) {
            return true;
        }
        if (stateStore instanceof WrappedStateStore) {
            return WrappedStateStore.isVersioned(((WrappedStateStore)stateStore).wrapped());
        }
        return false;
    }

    public WrappedStateStore(S wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        this.wrapped.init(context, root);
    }

    @Override
    public void init(StateStoreContext context, StateStore root) {
        this.wrapped.init(context, root);
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<K, V> listener, boolean sendOldValues) {
        if (this.wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)this.wrapped).setFlushListener(listener, sendOldValues);
        }
        return false;
    }

    @Override
    public void flushCache() {
        if (this.wrapped instanceof CachedStateStore) {
            ((CachedStateStore)this.wrapped).flushCache();
        }
    }

    @Override
    public void clearCache() {
        if (this.wrapped instanceof CachedStateStore) {
            ((CachedStateStore)this.wrapped).clearCache();
        }
    }

    @Override
    public String name() {
        return this.wrapped.name();
    }

    @Override
    public boolean persistent() {
        return this.wrapped.persistent();
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    void validateStoreOpen() {
        if (!this.wrapped.isOpen()) {
            throw new InvalidStateStoreException("Store " + this.wrapped.name() + " is currently closed.");
        }
    }

    @Override
    public void flush() {
        this.wrapped.flush();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        long start = config.isCollectExecutionInfo() ? System.nanoTime() : -1L;
        QueryResult<R> result = this.wrapped().query(query, positionBound, config);
        if (config.isCollectExecutionInfo()) {
            long end = System.nanoTime();
            result.addExecutionInfo("Handled in " + this.getClass() + " via WrappedStateStore in " + (end - start) + "ns");
        }
        return result;
    }

    @Override
    public Position getPosition() {
        return this.wrapped.getPosition();
    }

    public S wrapped() {
        return this.wrapped;
    }
}

