/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.util.PropertiesUtil;

public class DataConfigNode
implements ConfigNode {
    public final String name;
    public final Map<String, String> attributes;
    public final Map<String, List<ConfigNode>> kids;
    public final String textData;

    public DataConfigNode(ConfigNode root) {
        LinkedHashMap kids = new LinkedHashMap();
        this.name = root.name();
        this.attributes = DataConfigNode.wrapSubstituting(root.attributes());
        this.textData = root.txt();
        root.forEachChild(it -> {
            List nodes = kids.computeIfAbsent(it.name(), k -> new ArrayList());
            nodes.add(new DataConfigNode((ConfigNode)it));
            return Boolean.TRUE;
        });
        for (Map.Entry entry : kids.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.setValue(List.copyOf((Collection)entry.getValue()));
        }
        this.kids = Map.copyOf(kids);
    }

    private static String substituteVal(String s) {
        return PropertiesUtil.substitute((String)s, (Function)((Function)SUBSTITUTES.get()));
    }

    private static Map<String, String> wrapSubstituting(Map<String, String> delegate) {
        if (delegate.size() == 0) {
            return delegate;
        }
        return new SubstitutingMap(delegate);
    }

    public String name() {
        return this.name;
    }

    public String txt() {
        return DataConfigNode.substituteVal(this.textData);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public ConfigNode child(String name) {
        List<ConfigNode> val = this.kids.get(name);
        return val == null || val.isEmpty() ? null : val.get(0);
    }

    public List<ConfigNode> getAll(String name) {
        return this.kids.getOrDefault(name, List.of());
    }

    public List<ConfigNode> getAll(Predicate<ConfigNode> test, Set<String> matchNames) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        for (String s : matchNames) {
            List<ConfigNode> vals = this.kids.get(s);
            if (vals == null) continue;
            vals.forEach(it -> {
                if (test == null || test.test((ConfigNode)it)) {
                    result.add((ConfigNode)it);
                }
            });
        }
        return result;
    }

    public void forEachChild(Function<ConfigNode, Boolean> fun) {
        this.kids.forEach((s, configNodes) -> {
            if (configNodes != null) {
                configNodes.forEach(fun::apply);
            }
        });
    }

    private static class SubstitutingMap
    extends AbstractMap<String, String> {
        private final Map<String, String> delegate;

        SubstitutingMap(Map<String, String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String get(Object key) {
            return DataConfigNode.substituteVal(this.delegate.get(key));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public void forEach(BiConsumer<? super String, ? super String> action) {
            this.delegate.forEach((? super K k, ? super V v) -> action.accept((String)k, DataConfigNode.substituteVal(v)));
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new AbstractSet<Map.Entry<String, String>>(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    return delegate.entrySet().stream().map(entry -> new SubstitutingEntry((Map.Entry<String, String>)entry)).iterator();
                }

                @Override
                public int size() {
                    return delegate.size();
                }
            };
        }

        private static class SubstitutingEntry
        implements Map.Entry<String, String> {
            private final Map.Entry<String, String> delegateEntry;

            SubstitutingEntry(Map.Entry<String, String> delegateEntry) {
                this.delegateEntry = delegateEntry;
            }

            @Override
            public String getKey() {
                return this.delegateEntry.getKey();
            }

            @Override
            public String getValue() {
                return DataConfigNode.substituteVal(this.delegateEntry.getValue());
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

