/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.mlt.SimpleMLTQParser;

public class CloudMLTQParser
extends SimpleMLTQParser {
    public CloudMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String id = this.localParams.get("v");
        SolrDocument doc = this.getDocument(id);
        if (doc == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + id + "]");
        }
        try {
            Query docIdQuery = this.createIdQuery(this.req.getSchema().getUniqueKeyField().getName(), id);
            return this.parseMLTQuery(() -> this.getFieldsFromDoc(doc), mlt -> this.likeDoc(mlt, doc), docIdQuery);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad Request", (Throwable)e);
        }
    }

    protected Query likeDoc(MoreLikeThis moreLikeThis, SolrDocument doc) throws IOException {
        HashMap filteredDocument = new HashMap();
        for (String field : moreLikeThis.getFieldNames()) {
            Collection fieldValues = doc.getFieldValues(field);
            if (fieldValues == null) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (Object val : fieldValues) {
                if (val instanceof IndexableField) {
                    values.add(((IndexableField)val).stringValue());
                    continue;
                }
                values.add((String)val);
            }
            filteredDocument.put(field, values);
        }
        return moreLikeThis.like(filteredDocument);
    }

    protected String[] getFieldsFromDoc(SolrDocument doc) {
        ArrayList<String> fields = new ArrayList<String>();
        for (String field : doc.getFieldNames()) {
            SchemaField f = this.req.getSchema().getFieldOrNull(field);
            if (f == null || !f.stored() || !f.getType().isExplicitAnalyzer()) continue;
            fields.add(field);
        }
        return fields.toArray(new String[0]);
    }

    private SolrDocument getDocument(String id) {
        SolrCore core = this.req.getCore();
        SolrQueryResponse rsp = new SolrQueryResponse();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("id", new String[]{id});
        SolrQueryRequestBase request = new SolrQueryRequestBase(core, (SolrParams)params){};
        core.getRequestHandler("/get").handleRequest(request, rsp);
        NamedList<Object> response = rsp.getValues();
        return (SolrDocument)response.get("doc");
    }
}

